/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.drools.core.util.StringUtils;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.LhsBuilder;
import org.drools.decisiontable.parser.RhsBuilder;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.SourceBuilder;
import org.drools.decisiontable.parser.xls.PropertiesSheetListener;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.drools.template.model.Package;
import org.drools.template.model.Rule;
import org.drools.template.parser.DecisionTableParseException;

public class DefaultRuleSheetListener
implements RuleSheetListener {
    public static final String QUERIES_TAG = "Queries";
    public static final String FUNCTIONS_TAG = "Functions";
    public static final String DECLARES_TAG = "Declare";
    public static final String UNIT_TAG = "Unit";
    public static final String IMPORT_TAG = "Import";
    public static final String SEQUENTIAL_FLAG = "Sequential";
    public static final String ESCAPE_QUOTES_FLAG = "EscapeQuotes";
    public static final String MIN_SALIENCE_TAG = "SequentialMinPriority";
    public static final String MAX_SALIENCE_TAG = "SequentialMaxPriority";
    public static final String NUMERIC_DISABLED_FLAG = "NumericDisabled";
    public static final String IGNORE_NUMERIC_FORMAT_FLAG = "IgnoreNumericFormat";
    public static final String VARIABLES_TAG = "Variables";
    public static final String RULE_TABLE_TAG = "ruletable";
    public static final String RULESET_TAG = "RuleSet";
    public static final String DIALECT_TAG = "Dialect";
    private static final int ACTION_ROW = 1;
    private static final int OBJECT_TYPE_ROW = 2;
    private static final int CODE_ROW = 3;
    private static final int LABEL_ROW = 4;
    private boolean _isInRuleTable = false;
    private int _ruleRow;
    private int _ruleStartColumn;
    private int _ruleStartRow;
    private Rule _currentRule;
    private String _currentRulePrefix;
    private boolean _currentSequentialFlag = false;
    private boolean _currentEscapeQuotesFlag = true;
    private boolean _currentNumericDisabledFlag = false;
    private boolean _currentIgnoreNumericFormatFlag = false;
    private int _currentSalience = 65535;
    private int _minSalienceTag = 0;
    private Map<Integer, ActionType> _actions;
    private final HashMap<Integer, String> _cellComments = new HashMap();
    private final List<Rule> _ruleList = new ArrayList<Rule>();
    private Collection<SourceBuilder> sourceBuilders;
    private final PropertiesSheetListener _propertiesListener = new PropertiesSheetListener();
    private final boolean showPackage;
    private final boolean trimCell;
    private String worksheetName = null;

    public DefaultRuleSheetListener() {
        this(true, true);
    }

    public DefaultRuleSheetListener(boolean showPackage, boolean trimCell) {
        this.showPackage = showPackage;
        this.trimCell = trimCell;
    }

    public void setWorksheetName(String worksheetName) {
        this.worksheetName = worksheetName;
    }

    @Override
    public PropertiesSheetListener.CaseInsensitiveMap getProperties() {
        return this._propertiesListener.getProperties();
    }

    @Override
    public Package getRuleSet() {
        if (this._ruleList.isEmpty()) {
            throw new DecisionTableParseException("No RuleTable cells in spreadsheet.");
        }
        return this.buildRuleSet();
    }

    protected void addRule(Rule newRule) {
        this._ruleList.add(newRule);
    }

    private Package buildRuleSet() {
        List<String> list;
        List<String> list2;
        List<String> dialects;
        String defaultPackageName = "rule_table";
        String rulesetName = this.getProperties().getSingleProperty(RULESET_TAG, "rule_table");
        Package ruleset = new Package(this.showPackage ? rulesetName : null);
        for (Rule rule : this._ruleList) {
            ruleset.addRule(rule);
        }
        List<String> units = this.getProperties().getProperty(UNIT_TAG);
        if (units != null && !units.isEmpty()) {
            ruleset.setRuleUnit(units.get(0));
        }
        if ((dialects = this.getProperties().getProperty(DIALECT_TAG)) != null && !dialects.isEmpty()) {
            ruleset.setDialect(dialects.get(0));
        }
        List<Import> importList = RuleSheetParserUtil.getImportList(this.getProperties().getProperty(IMPORT_TAG));
        for (Import import_ : importList) {
            ruleset.addImport(import_);
        }
        List<Global> variableList = RuleSheetParserUtil.getVariableList(this.getProperties().getProperty(VARIABLES_TAG));
        for (Global global : variableList) {
            ruleset.addVariable(global);
        }
        List<String> list3 = this.getProperties().getProperty(FUNCTIONS_TAG);
        if (list3 != null) {
            for (String string : list3) {
                ruleset.addFunctions(string);
            }
        }
        if ((list2 = this.getProperties().getProperty(QUERIES_TAG)) != null) {
            for (String query : list2) {
                ruleset.addQueries(query);
            }
        }
        if ((list = this.getProperties().getProperty(DECLARES_TAG)) != null) {
            for (String declaration : list) {
                ruleset.addDeclaredType(declaration);
            }
        }
        for (ActionType.Code code : ActionType.ATTRIBUTE_CODE_SET) {
            List<String> values = this.getProperties().getProperty(code.getColHeader());
            if (values == null) continue;
            if (values.size() > 1) {
                List<String> cells = this.getProperties().getPropertyCells(code.getColHeader());
                throw new DecisionTableParseException("Multiple values for " + code.getColHeader() + " in cells " + cells.toString());
            }
            String value = values.get(0);
            switch (code) {
                case SALIENCE: {
                    try {
                        ruleset.setSalience(Integer.valueOf(value));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new DecisionTableParseException("Priority is not an integer literal, in cell " + this.getProperties().getSinglePropertyCell(code.getColHeader()));
                    }
                }
                case DURATION: {
                    try {
                        ruleset.setDuration(Long.valueOf(value));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new DecisionTableParseException("Duration is not an integer literal, in cell " + this.getProperties().getSinglePropertyCell(code.getColHeader()));
                    }
                }
                case TIMER: {
                    ruleset.setTimer(value);
                    break;
                }
                case ENABLED: {
                    ruleset.setEnabled(RuleSheetParserUtil.isStringMeaningTrue(value));
                    break;
                }
                case CALENDARS: {
                    ruleset.setCalendars(value);
                    break;
                }
                case NOLOOP: {
                    ruleset.setNoLoop(RuleSheetParserUtil.isStringMeaningTrue(value));
                    break;
                }
                case LOCKONACTIVE: {
                    ruleset.setLockOnActive(RuleSheetParserUtil.isStringMeaningTrue(value));
                    break;
                }
                case AUTOFOCUS: {
                    ruleset.setAutoFocus(RuleSheetParserUtil.isStringMeaningTrue(value));
                    break;
                }
                case ACTIVATIONGROUP: {
                    ruleset.setActivationGroup(value);
                    break;
                }
                case AGENDAGROUP: {
                    ruleset.setAgendaGroup(value);
                    break;
                }
                case RULEFLOWGROUP: {
                    ruleset.setRuleFlowGroup(value);
                    break;
                }
                case DATEEFFECTIVE: {
                    ruleset.setDateEffective(value);
                    break;
                }
                case DATEEXPIRES: {
                    ruleset.setDateExpires(value);
                }
            }
        }
        return ruleset;
    }

    public void startSheet(String name) {
    }

    public void finishSheet() {
        this._propertiesListener.finishSheet();
        this.finishRuleTable();
        this.flushRule();
    }

    public void newRow(int rowNumber, int columns) {
        if (this._currentRule != null) {
            this.flushRule();
        }
    }

    private void flushRule() {
        if (this.sourceBuilders == null) {
            return;
        }
        for (SourceBuilder src : this.sourceBuilders) {
            if (!src.hasValues()) continue;
            switch (src.getActionTypeCode()) {
                case CONDITION: {
                    Condition cond = new Condition();
                    cond.setSnippet(StringUtils.replaceOutOfQuotes((String)src.getResult(), (String)"\\n", (String)" "));
                    this._currentRule.addCondition(cond);
                    break;
                }
                case ACTION: {
                    Consequence cons = new Consequence();
                    cons.setSnippet(StringUtils.replaceOutOfQuotes((String)src.getResult(), (String)"\\n", (String)" "));
                    this._currentRule.addConsequence(cons);
                    break;
                }
                case METADATA: {
                    this._currentRule.addMetadata(src.getResult());
                }
            }
            src.clearValues();
        }
    }

    public void newCell(int row, int column, String value, int mergedColStart) {
        if (this.isCellValueEmpty(value)) {
            return;
        }
        if (this._isInRuleTable && row == this._ruleStartRow) {
            return;
        }
        if (this._isInRuleTable) {
            this.processRuleCell(row, column, value, mergedColStart);
        } else {
            this.processNonRuleCell(row, column, value);
        }
    }

    private void initRuleTable(int row, int column, String value, boolean firstTable) {
        this.preInitRuleTable(row, column, value);
        this._isInRuleTable = true;
        this._actions = new HashMap<Integer, ActionType>();
        this.sourceBuilders = new TreeSet<SourceBuilder>(Comparator.comparing(SourceBuilder::getColumn));
        this._ruleStartColumn = column;
        this._ruleStartRow = row;
        this._ruleRow = row + 4 + 1;
        this._currentRulePrefix = RuleSheetParserUtil.getRuleName(value);
        if (this.worksheetName != null) {
            this._currentRulePrefix = this._currentRulePrefix + " " + this.worksheetName;
        }
        this._currentSequentialFlag = this.getFlagValue(SEQUENTIAL_FLAG, false);
        this._currentEscapeQuotesFlag = this.getFlagValue(ESCAPE_QUOTES_FLAG, true);
        this._currentNumericDisabledFlag = this.getFlagValue(NUMERIC_DISABLED_FLAG, false);
        this._currentIgnoreNumericFormatFlag = this.getFlagValue(IGNORE_NUMERIC_FORMAT_FLAG, false);
        if (firstTable) {
            this._currentSalience = this.getNumericValue(MAX_SALIENCE_TAG, this._currentSalience);
            this._minSalienceTag = this.getNumericValue(MIN_SALIENCE_TAG, this._minSalienceTag);
        }
        String headCell = RuleSheetParserUtil.rc2name(this._ruleStartRow, this._ruleStartColumn);
        String ruleCell = RuleSheetParserUtil.rc2name(this._ruleRow, this._ruleStartColumn);
        this._currentRule = this.createNewRuleForRow(this._ruleRow, headCell, ruleCell);
        this._ruleList.add(this._currentRule);
        this.postInitRuleTable(row, column, value);
    }

    protected void preInitRuleTable(int row, int column, String value) {
    }

    protected Rule getCurrentRule() {
        return this._currentRule;
    }

    protected void postInitRuleTable(int row, int column, String value) {
    }

    private boolean getFlagValue(String name, boolean defaultValue) {
        return RuleSheetParserUtil.isStringMeaningTrue(this.getProperties().getSingleProperty(name, "" + defaultValue));
    }

    private int getNumericValue(String name, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperties().getSingleProperty(name, "" + defaultValue));
        }
        catch (NumberFormatException nfe) {
            throw new DecisionTableParseException("Invalid numeric value for option: " + name, (Throwable)nfe);
        }
    }

    private void finishRuleTable() {
        if (this._isInRuleTable) {
            this._currentSequentialFlag = false;
            this._isInRuleTable = false;
        }
    }

    private void processNonRuleCell(int row, int column, String value) {
        String testVal = value.trim().toLowerCase();
        if (this.isRuleTable(testVal)) {
            this.initRuleTable(row, column, value.trim(), true);
        } else {
            this._propertiesListener.newCell(row, column, value, -1);
        }
    }

    private void processRuleCell(int row, int column, String value, int mergedColStart) {
        String trimVal = this.trimCell ? value.trim() : value;
        String testVal = trimVal.toLowerCase();
        if (this.isRuleTable(testVal)) {
            this.finishRuleTable();
            this.initRuleTable(row, column, trimVal, false);
            return;
        }
        if (column < this._ruleStartColumn) {
            return;
        }
        if (row == this._ruleStartRow) {
            return;
        }
        switch (row - this._ruleStartRow) {
            case 1: {
                ActionType.addNewActionType(this._actions, trimVal, column, row);
                break;
            }
            case 2: {
                this.objectTypeRow(row, column, trimVal, mergedColStart);
                break;
            }
            case 3: {
                this.codeRow(row, column, trimVal);
                break;
            }
            case 4: {
                this.labelRow(row, column, trimVal);
                break;
            }
            default: {
                this.nextDataCell(row, column, trimVal);
            }
        }
    }

    private boolean isRuleTable(String testVal) {
        return Objects.equals(RULE_TABLE_TAG, testVal) || testVal.startsWith("ruletable ");
    }

    private void objectTypeRow(int row, int column, String value, int mergedColStart) {
        if (value.contains("$param") || value.contains("$1")) {
            throw new DecisionTableParseException("It looks like you have snippets in the row that is meant for object declarations. Please insert an additional row before the snippets, at cell " + RuleSheetParserUtil.rc2name(row, column));
        }
        ActionType action = this.getActionForColumn(row, column);
        if (mergedColStart == -1) {
            if (action.getCode() == ActionType.Code.CONDITION) {
                LhsBuilder src = new LhsBuilder(row - 1, column, value);
                action.setSourceBuilder(src);
                this.sourceBuilders.add(src);
            } else if (action.getCode() == ActionType.Code.ACTION) {
                RhsBuilder src = new RhsBuilder(ActionType.Code.ACTION, row - 1, column, value);
                action.setSourceBuilder(src);
                this.sourceBuilders.add(src);
            }
        } else if (column == mergedColStart) {
            if (action.getCode() == ActionType.Code.CONDITION) {
                action.setSourceBuilder(new LhsBuilder(row - 1, column, value));
                this.sourceBuilders.add(action.getSourceBuilder());
            } else if (action.getCode() == ActionType.Code.ACTION) {
                action.setSourceBuilder(new RhsBuilder(ActionType.Code.ACTION, row - 1, column, value));
                this.sourceBuilders.add(action.getSourceBuilder());
            }
        } else {
            ActionType startOfMergeAction = this.getActionForColumn(row, mergedColStart);
            action.setSourceBuilder(startOfMergeAction.getSourceBuilder());
        }
    }

    private void codeRow(int row, int column, String value) {
        ActionType actionType = this.getActionForColumn(row, column);
        if (actionType.getSourceBuilder() == null) {
            if (actionType.getCode() == ActionType.Code.CONDITION) {
                actionType.setSourceBuilder(new LhsBuilder(row - 2, column, null));
                this.sourceBuilders.add(actionType.getSourceBuilder());
            } else if (actionType.getCode() == ActionType.Code.ACTION) {
                actionType.setSourceBuilder(new RhsBuilder(ActionType.Code.ACTION, row - 2, column, null));
                this.sourceBuilders.add(actionType.getSourceBuilder());
            } else if (actionType.getCode() == ActionType.Code.SALIENCE) {
                actionType.setSourceBuilder(new LhsBuilder(row - 2, column, null));
                this.sourceBuilders.add(actionType.getSourceBuilder());
            } else if (actionType.getCode() == ActionType.Code.METADATA) {
                actionType.setSourceBuilder(new RhsBuilder(ActionType.Code.METADATA, row - 2, column, null));
                this.sourceBuilders.add(actionType.getSourceBuilder());
            }
        }
        if (value.trim().equals("") && (actionType.getCode() == ActionType.Code.ACTION || actionType.getCode() == ActionType.Code.CONDITION || actionType.getCode() == ActionType.Code.METADATA)) {
            throw new DecisionTableParseException("Code description in cell " + RuleSheetParserUtil.rc2name(row, column) + " does not contain any code specification. It should!");
        }
        actionType.addTemplate(row, column, value);
    }

    private void labelRow(int row, int column, String value) {
        ActionType actionType = this.getActionForColumn(row, column);
        if (!(value.trim().equals("") || actionType.getCode() != ActionType.Code.ACTION && actionType.getCode() != ActionType.Code.CONDITION)) {
            this._cellComments.put(column, value);
        } else {
            this._cellComments.put(column, "From cell: " + RuleSheetParserUtil.rc2name(row, column));
        }
    }

    private ActionType getActionForColumn(int row, int column) {
        ActionType actionType = this._actions.get(column);
        if (actionType == null) {
            throw new DecisionTableParseException("Code description in cell " + RuleSheetParserUtil.rc2name(row, column) + " does not have an 'ACTION' or 'CONDITION' column header.");
        }
        return actionType;
    }

    private void nextDataCell(int row, int column, String value) {
        ActionType actionType = this.getActionForColumn(row, column);
        if (row - this._ruleRow > 1) {
            this.finishRuleTable();
            this.processNonRuleCell(row, column, value);
            return;
        }
        if (row > this._ruleRow) {
            String headCell = RuleSheetParserUtil.rc2name(this._ruleStartRow, this._ruleStartColumn);
            String ruleCell = RuleSheetParserUtil.rc2name(row, this._ruleStartColumn);
            this._currentRule = this.createNewRuleForRow(row, headCell, ruleCell);
            this._ruleList.add(this._currentRule);
            ++this._ruleRow;
        }
        switch (actionType.getCode()) {
            case CONDITION: 
            case ACTION: 
            case METADATA: {
                if (actionType.getSourceBuilder() == null) {
                    throw new DecisionTableParseException("Data cell " + RuleSheetParserUtil.rc2name(row, column) + " has an empty column header.");
                }
                actionType.addCellValue(row, column, value, this._currentEscapeQuotesFlag, this.trimCell);
                break;
            }
            case SALIENCE: {
                if (this._currentSequentialFlag) break;
                if (value.startsWith("(") && value.endsWith(")")) {
                    this._currentRule.setSalience(value);
                    break;
                }
                try {
                    this._currentRule.setSalience(Integer.valueOf(value));
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new DecisionTableParseException("Priority is not an integer literal, in cell " + RuleSheetParserUtil.rc2name(row, column));
                }
            }
            case NAME: {
                this._currentRule.setName(value);
                break;
            }
            case DESCRIPTION: {
                this._currentRule.setDescription(value);
                break;
            }
            case ACTIVATIONGROUP: {
                this._currentRule.setActivationGroup(value);
                break;
            }
            case AGENDAGROUP: {
                this._currentRule.setAgendaGroup(value);
                break;
            }
            case RULEFLOWGROUP: {
                this._currentRule.setRuleFlowGroup(value);
                break;
            }
            case NOLOOP: {
                this._currentRule.setNoLoop(RuleSheetParserUtil.isStringMeaningTrue(value));
                break;
            }
            case LOCKONACTIVE: {
                this._currentRule.setLockOnActive(RuleSheetParserUtil.isStringMeaningTrue(value));
                break;
            }
            case AUTOFOCUS: {
                this._currentRule.setAutoFocus(RuleSheetParserUtil.isStringMeaningTrue(value));
                break;
            }
            case DURATION: {
                try {
                    this._currentRule.setDuration(Long.valueOf(value));
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new DecisionTableParseException("Duration is not an integer literal, in cell " + RuleSheetParserUtil.rc2name(row, column));
                }
            }
            case TIMER: {
                this._currentRule.setTimer(value);
                break;
            }
            case ENABLED: {
                this._currentRule.setEnabled(RuleSheetParserUtil.isStringMeaningTrue(value));
                break;
            }
            case CALENDARS: {
                this._currentRule.setCalendars(value);
                break;
            }
            case DATEEFFECTIVE: {
                this._currentRule.setDateEffective(value);
                break;
            }
            case DATEEXPIRES: {
                this._currentRule.setDateExpires(value);
            }
        }
    }

    private Rule createNewRuleForRow(int row, String headCell, String ruleCell) {
        Integer salience = null;
        if (this._currentSequentialFlag && (salience = Integer.valueOf(this._currentSalience--)) < this._minSalienceTag) {
            throw new DecisionTableParseException("Salience less than the minimum specified on row: " + row);
        }
        int spreadsheetRow = row + 1;
        String name = this._currentRulePrefix + "_" + spreadsheetRow;
        Rule rule = new Rule(name, salience, spreadsheetRow);
        rule.setComment(" rule values at " + ruleCell + ", header at " + headCell);
        return rule;
    }

    private boolean isCellValueEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    public boolean isNumericDisabled() {
        return this._currentNumericDisabledFlag;
    }

    public boolean doesIgnoreNumericFormat() {
        return this._currentIgnoreNumericFormatFlag;
    }
}

