/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.xls;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelNumberFormat;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.drools.core.util.DateUtils;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;
import org.drools.template.parser.DataListener;
import org.drools.template.parser.DecisionTableParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelParser
implements DecisionTableParser {
    private static final Logger log = LoggerFactory.getLogger(ExcelParser.class);
    public static final String DEFAULT_RULESHEET_NAME = "Decision Tables";
    private Map<String, List<DataListener>> _listeners = new HashMap<String, List<DataListener>>();
    private boolean _useFirstSheet;

    private static void initMinInflateRatio() {
        String minInflateRatio = System.getProperty("drools.excelParser.minInflateRatio");
        if (minInflateRatio != null) {
            try {
                ZipSecureFile.setMinInflateRatio((double)Double.parseDouble(minInflateRatio));
            }
            catch (NumberFormatException nfe) {
                log.error("Invalid value '" + minInflateRatio + "' for property drools.excelParser.minInflateRatio. It has to be a double");
            }
        } else {
            ZipSecureFile.setMinInflateRatio((double)0.01);
        }
    }

    public ExcelParser(Map<String, List<DataListener>> sheetListeners) {
        this._listeners = sheetListeners;
        ExcelParser.initMinInflateRatio();
    }

    public ExcelParser(List<DataListener> sheetListeners) {
        this._listeners.put(DEFAULT_RULESHEET_NAME, sheetListeners);
        this._useFirstSheet = true;
        ExcelParser.initMinInflateRatio();
    }

    public ExcelParser(DataListener listener) {
        ArrayList<DataListener> listeners = new ArrayList<DataListener>();
        listeners.add(listener);
        this._listeners.put(DEFAULT_RULESHEET_NAME, listeners);
        this._useFirstSheet = true;
        ExcelParser.initMinInflateRatio();
    }

    @Override
    public void parseFile(InputStream inStream) {
        try {
            this.parseWorkbook(WorkbookFactory.create((InputStream)inStream));
        }
        catch (IOException e) {
            throw new DecisionTableParseException("Failed to open Excel stream, please check that the content is xls97 format.", (Throwable)e);
        }
    }

    @Override
    public void parseFile(File file) {
        try {
            this.parseWorkbook(WorkbookFactory.create((File)file, (String)null, (boolean)true));
        }
        catch (IOException e) {
            throw new DecisionTableParseException("Failed to open Excel stream, please check that the content is xls97 format.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseWorkbook(Workbook workbook) {
        try {
            try {
                if (this._useFirstSheet) {
                    Sheet sheet = workbook.getSheetAt(0);
                    this.processSheet(sheet, this._listeners.get(DEFAULT_RULESHEET_NAME));
                } else {
                    for (String sheetName : this._listeners.keySet()) {
                        Sheet sheet = workbook.getSheet(sheetName);
                        if (sheet == null) {
                            throw new IllegalStateException("Could not find the sheetName (" + sheetName + ") in the workbook sheetNames.");
                        }
                        this.processSheet(sheet, this._listeners.get(sheetName));
                    }
                }
            }
            finally {
                workbook.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private CellRangeAddress[] getMergedCells(Sheet sheet) {
        CellRangeAddress[] ranges = new CellRangeAddress[sheet.getNumMergedRegions()];
        for (int i = 0; i < ranges.length; ++i) {
            ranges[i] = sheet.getMergedRegion(i);
        }
        return ranges;
    }

    private void processSheet(Sheet sheet, List<? extends DataListener> listeners) {
        int maxRows = sheet.getLastRowNum();
        CellRangeAddress[] mergedRanges = this.getMergedCells(sheet);
        DataFormatter formatter = new DataFormatter(Locale.ENGLISH);
        FormulaEvaluator formulaEvaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        for (int i = 0; i <= maxRows; ++i) {
            Row row = sheet.getRow(i);
            int lastCellNum = row != null ? row.getLastCellNum() : 0;
            this.newRow(listeners, i, lastCellNum);
            block8: for (int cellNum = 0; cellNum < lastCellNum; ++cellNum) {
                Cell cell = row.getCell(cellNum);
                if (cell == null) continue;
                double num = 0.0;
                CellRangeAddress merged = this.getRangeIfMerged(cell, mergedRanges);
                int mergedColStart = -1;
                if (merged != null) {
                    cell = sheet.getRow(merged.getFirstRow()).getCell(merged.getFirstColumn());
                    mergedColStart = cell.getColumnIndex();
                }
                switch (cell.getCellType()) {
                    case BOOLEAN: {
                        this.newCell(listeners, i, cellNum, cell.getBooleanCellValue() ? "true" : "false", mergedColStart);
                        continue block8;
                    }
                    case FORMULA: {
                        try {
                            this.newCell(listeners, i, cellNum, this.getFormulaValue(formatter, formulaEvaluator, cell), mergedColStart);
                        }
                        catch (RuntimeException e) {
                            log.warn("Cannot resolve externally linked value: " + formatter.formatCellValue(cell));
                            String cachedValue = this.tryToReadCachedValue(cell);
                            this.newCell(listeners, i, cellNum, cachedValue, mergedColStart);
                        }
                        continue block8;
                    }
                    case NUMERIC: {
                        if (!this.isNumericDisabled(listeners)) {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                this.newCell(listeners, i, cellNum, "\"" + DateUtils.format((Date)cell.getDateCellValue()) + "\"", mergedColStart);
                                continue block8;
                            }
                            num = cell.getNumericCellValue();
                            if (this.doesIgnoreNumericFormat(listeners) && !this.isGeneralFormat(cell)) {
                                this.newCell(listeners, i, cellNum, String.valueOf(num), mergedColStart);
                                continue block8;
                            }
                        }
                    }
                    default: {
                        if (num - (double)Math.round(num) != 0.0) {
                            this.newCell(listeners, i, cellNum, String.valueOf(num), mergedColStart);
                            continue block8;
                        }
                        this.newCell(listeners, i, cellNum, formatter.formatCellValue(cell), mergedColStart);
                    }
                }
            }
        }
        this.finishSheet(listeners);
    }

    private boolean isGeneralFormat(Cell cell) {
        CellStyle style = cell.getCellStyle();
        ExcelNumberFormat nf = ExcelNumberFormat.from((CellStyle)style);
        return nf.getFormat().equalsIgnoreCase("General");
    }

    private String getFormulaValue(DataFormatter formatter, FormulaEvaluator formulaEvaluator, Cell cell) {
        if (formulaEvaluator.evaluate(cell).getCellType() == CellType.BOOLEAN) {
            return cell.getBooleanCellValue() ? "true" : "false";
        }
        return formatter.formatCellValue(cell, formulaEvaluator);
    }

    private String tryToReadCachedValue(Cell cell) {
        String cachedValue;
        DataFormatter formatter = new DataFormatter(Locale.ENGLISH);
        switch (cell.getCachedFormulaResultType()) {
            case NUMERIC: {
                double num = cell.getNumericCellValue();
                if (num - (double)Math.round(num) != 0.0) {
                    cachedValue = String.valueOf(num);
                    break;
                }
                cachedValue = formatter.formatCellValue(cell);
                break;
            }
            case STRING: {
                cachedValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cachedValue = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                cachedValue = String.valueOf(cell.getErrorCellValue());
                break;
            }
            default: {
                throw new DecisionTableParseException(String.format("Can't read cached value for cell[row=%d, col=%d, value=%s]!", cell.getRowIndex(), cell.getColumnIndex(), cell));
            }
        }
        return cachedValue;
    }

    CellRangeAddress getRangeIfMerged(Cell cell, CellRangeAddress[] mergedRanges) {
        for (int i = 0; i < mergedRanges.length; ++i) {
            CellRangeAddress r = mergedRanges[i];
            if (!r.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            return r;
        }
        return null;
    }

    private void finishSheet(List<? extends DataListener> listeners) {
        for (DataListener dataListener : listeners) {
            dataListener.finishSheet();
        }
    }

    private void newRow(List<? extends DataListener> listeners, int row, int cols) {
        for (DataListener dataListener : listeners) {
            dataListener.newRow(row, cols);
        }
    }

    public void newCell(List<? extends DataListener> listeners, int row, int column, String value, int mergedColStart) {
        for (DataListener dataListener : listeners) {
            dataListener.newCell(row, column, value, mergedColStart);
        }
    }

    private boolean isNumericDisabled(List<? extends DataListener> listeners) {
        for (DataListener dataListener : listeners) {
            if (!(dataListener instanceof DefaultRuleSheetListener)) continue;
            return ((DefaultRuleSheetListener)dataListener).isNumericDisabled();
        }
        return false;
    }

    private boolean doesIgnoreNumericFormat(List<? extends DataListener> listeners) {
        for (DataListener dataListener : listeners) {
            if (!(dataListener instanceof DefaultRuleSheetListener)) continue;
            return ((DefaultRuleSheetListener)dataListener).doesIgnoreNumericFormat();
        }
        return false;
    }
}

