/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.util.Locale;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieSession;

public class DecimalSeparatorTest {
    private KieSession ksession;

    public void init() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmodule = ks.newKieModuleModel();
        KieBaseModel baseModel = kmodule.newKieBaseModel("defaultKBase").setDefault(true);
        baseModel.newKieSessionModel("defaultKSession").setDefault(true);
        kfs.writeKModuleXML(kmodule.toXML());
        kfs.write(ks.getResources().newClassPathResource("decimalSeparator.drl.xls", this.getClass()));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)0L, (long)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size());
        this.ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
    }

    @After
    public void clear() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test
    public void testDecimalSeparatorInFrench() {
        Locale.setDefault(Locale.FRENCH);
        this.init();
        this.ksession.insert((Object)"Hello");
        Assert.assertEquals((long)1L, (long)this.ksession.fireAllRules());
    }

    @Test
    public void testDecimalSeparatorInEnglish() {
        Locale.setDefault(Locale.ENGLISH);
        this.init();
        this.ksession.insert((Object)"Hello");
        Assert.assertEquals((long)1L, (long)this.ksession.fireAllRules());
    }
}

