/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import org.drools.core.definitions.rule.impl.RuleImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.model.KieModuleModel;

public class PrioritySetWithFormulaTest {
    private KieBase kieBase;

    @Before
    public void init() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmodule = ks.newKieModuleModel();
        kfs.writeKModuleXML(kmodule.toXML());
        kfs.write(ks.getResources().newClassPathResource("prioritySetWithFormula.drl.xls", this.getClass()));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)0L, (long)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size());
        this.kieBase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
    }

    @Test
    public void test() {
        RuleImpl cheeseWorld11 = (RuleImpl)this.kieBase.getRule("test", "CheeseWorld_11");
        Assert.assertEquals((long)5L, (long)cheeseWorld11.getSalience().getValue());
        RuleImpl cheeseWorld12 = (RuleImpl)this.kieBase.getRule("test", "CheeseWorld_12");
        Assert.assertEquals((long)12L, (long)cheeseWorld12.getSalience().getValue());
    }
}

