/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.project;

import org.assertj.core.api.Assertions;
import org.drools.decisiontable.project.Person;
import org.drools.decisiontable.project.Result;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.KieResources;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class MultiKieBaseTest {
    @Test
    public void testOK() {
        KieServices ks = KieServices.get();
        KieResources kr = ks.getResources();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/org/drools/decisiontable/project/rules/Sample.drl", kr.newFileSystemResource("src/test/resources/org/drools/decisiontable/project/rules/Sample.drl")).write("src/main/resources/org/drools/decisiontable/project/dtable/CanDrink.drl.xls", kr.newFileSystemResource("src/test/resources/org/drools/decisiontable/project/dtable/CanDrink.drl.xls"));
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("rulesKB").addPackage("org.drools.decisiontable.project.rules").newKieSessionModel("rules");
        kproj.newKieBaseModel("dtblaleKB").addPackage("org.drools.decisiontable.project.dtable").newKieSessionModel("dtable");
        kfs.writeKModuleXML(kproj.toXML());
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        KieContainer kc = ks.newKieContainer(kb.getKieModule().getReleaseId());
        KieSession sessionRules = kc.newKieSession("rules");
        Result res1 = new Result();
        sessionRules.insert((Object)res1);
        sessionRules.insert((Object)new Person("Mario", 45));
        sessionRules.fireAllRules();
        Assertions.assertThat((String)res1.toString()).isEqualTo("Hello Mario");
        KieSession sessionDtable = kc.newKieSession("dtable");
        Result res2 = new Result();
        sessionDtable.insert((Object)res2);
        sessionDtable.insert((Object)new Person("Mario", 45));
        sessionDtable.fireAllRules();
        Assertions.assertThat((String)res2.toString()).isEqualTo("Mario can drink");
    }

    @Test
    public void testWrongFolder() {
        KieServices ks = KieServices.get();
        KieResources kr = ks.getResources();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/org/drools/decisiontable/projectwrong/rules/Sample.drl", kr.newFileSystemResource("src/test/resources/org/drools/decisiontable/project/rules/Sample.drl")).write("src/main/resources/org/drools/decisiontable/projectwrong/dtable/CanDrink.drl.xls", kr.newFileSystemResource("src/test/resources/org/drools/decisiontable/project/dtable/CanDrink.drl.xls"));
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("rulesKB").addPackage("org.drools.decisiontable.projectwrong.rules").newKieSessionModel("rules");
        kproj.newKieBaseModel("dtblaleKB").addPackage("org.drools.decisiontable.projectwrong.dtable").newKieSessionModel("dtable");
        kfs.writeKModuleXML(kproj.toXML());
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        KieContainer kc = ks.newKieContainer(kb.getKieModule().getReleaseId());
        KieSession sessionRules = kc.newKieSession("rules");
        Result res1 = new Result();
        sessionRules.insert((Object)res1);
        sessionRules.insert((Object)new Person("Mario", 45));
        sessionRules.fireAllRules();
        Assertions.assertThat((String)res1.toString()).isNull();
        KieSession sessionDtable = kc.newKieSession("dtable");
        Result res2 = new Result();
        sessionDtable.insert((Object)res2);
        sessionDtable.insert((Object)new Person("Mario", 45));
        sessionDtable.fireAllRules();
        Assertions.assertThat((String)res2.toString()).isNull();
    }
}

