/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import org.assertj.core.api.Assertions;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.model.KieModuleModel;

public class PrioritySetWithFormulaTest {
    private KieBase kieBase;

    @Before
    public void init() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmodule = ks.newKieModuleModel();
        kfs.writeKModuleXML(kmodule.toXML());
        kfs.write(ks.getResources().newClassPathResource("prioritySetWithFormula.drl.xls", this.getClass()));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assertions.assertThat((int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size()).isEqualTo(0);
        this.kieBase = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).getKieBase();
    }

    @Test
    public void test() {
        RuleImpl cheeseWorld11 = (RuleImpl)this.kieBase.getRule("test", "CheeseWorld_11");
        Assertions.assertThat((int)cheeseWorld11.getSalience().getValue()).isEqualTo(5);
        RuleImpl cheeseWorld12 = (RuleImpl)this.kieBase.getRule("test", "CheeseWorld_12");
        Assertions.assertThat((int)cheeseWorld12.getSalience().getValue()).isEqualTo(12);
    }
}

