/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.Person;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.internal.io.ResourceFactory;

public class XlsFormulaTest {
    @Test
    public void testFormulaValue() throws Exception {
        Resource dt = ResourceFactory.newClassPathResource((String)"/data/XlsFormula.drl.xls", this.getClass());
        KieSession ksession = this.getKieSession(dt);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("michael", "stilton", 1));
        ksession.fireAllRules();
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("10");
        ksession.insert((Object)new Person("michael", "stilton", 2));
        ksession.fireAllRules();
        Assertions.assertThat((String)((String)list.get(1))).isEqualTo("11");
        ksession.insert((Object)new Person("michael", "stilton", 3));
        ksession.fireAllRules();
        Assertions.assertThat((String)((String)list.get(2))).isEqualTo("21");
    }

    private KieSession getKieSession(Resource dt) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write(dt);
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        Assertions.assertThat((boolean)kb.getResults().getMessages().isEmpty()).isTrue();
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        return ksession;
    }
}

