/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.Test;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class FixedPatternTest {
    @Test
    public void testFixedPattern() throws FileNotFoundException {
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLS);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"fixedPattern.drl.xls", this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1L);
        ksession.insert((Object)2);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((long)((Long)list.get(0))).isEqualTo(1L);
        ksession.dispose();
    }
}

