/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;
import org.drools.decisiontable.parser.RuleMatrixSheetListener;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.xls.ExcelParser;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class SpreadsheetCompilerUnitTest {
    @Test
    public void testLoadFromClassPath() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/MultiSheetDST.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("rule \"How cool am I_12\"") > drl.indexOf("rule \"How cool am I_11\"") ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("import example.model.User;") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("import example.model.Car;") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("package ") > -1 ? 1 : 0) != 0).isTrue();
        InputStream ins = this.getClass().getResourceAsStream("/data/MultiSheetDST.drl.xls");
        drl = converter.compile(false, ins, InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("rule \"How cool am I_12\"") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("import example.model.User;") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("import example.model.Car;") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("package ") == -1 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testMultilineActions() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("MultiLinesInAction.drl.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"\\n"});
    }

    @Test
    public void testMultilineActionsAndMultiLineInConstant() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("MultiLinesInActionAndMultiLineInConstant.drl.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).contains(new CharSequence[]{" **\n** "});
    }

    @Test
    public void testMultilineActionsAndMultiLineAsConstant() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("MultiLinesInActionAndMultiLineAsConstant.drl.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).contains(new CharSequence[]{" **\\n** "});
    }

    @Test
    public void testMultilineCommentsInDescription() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/Multiline comment example.drl.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).containsSubsequence(new CharSequence[]{"/* Say", "Hello */", "/* Say", "Goobye */"});
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"// Say"});
    }

    @Test
    public void testMultilineComplexCommentsInDescription() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/Multiline comment example complex.drl.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).containsSubsequence(new CharSequence[]{"/* Do these actions:", "- Print Greeting", "- Set params: {message:'bye cruel world', status:'bye'} */", "/* Print message: \"Bye!\"", "Author: james@company.org */"});
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"* - Print Greeting"});
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"* - Set params: {message:'bye cruel world', status:'bye'}"});
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"* Author: james@company.org"});
    }

    @Test
    public void testLoadSpecificWorksheet() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/MultiSheetDST.drl.xls");
        String drl = converter.compile(stream, "Another Sheet");
        Assertions.assertThat((String)drl).isNotNull();
    }

    @Test
    public void testLoadCustomListener() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/CustomWorkbook.drl.xls");
        String drl = converter.compile(stream, InputType.XLS, (RuleSheetListener)new RuleMatrixSheetListener());
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("\"matrix\"") != -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("$v : FundVisibility") != -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("FundType") != -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("Role") != -1 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testLoadCsv() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/ComplexWorkbook.drl.csv");
        String drl = converter.compile(stream, InputType.CSV);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("myObject.setIsValid(1, 2)") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("myObject.size () > 50") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size () > 1)") > 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testLoadBasicWithMergedCells() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/BasicWorkbook.drl.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        System.out.println(drl);
        Pattern p = Pattern.compile(".*setIsValid\\(Y\\).*setIsValid\\(Y\\).*setIsValid\\(Y\\).*", 40);
        Matcher m = p.matcher(drl);
        Assertions.assertThat((boolean)m.matches()).isTrue();
        Assertions.assertThat((drl.indexOf("This is a function block") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("global Class1 obj1;") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("myObject.setIsValid(10-Jul-1974)") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("myObject.getColour().equals(blue)") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size () > 12\\\")") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("b: Bar() eval(myObject.size() < 3)") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("b: Bar() eval(myObject.size() < 9)") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size () > 1)") < drl.indexOf("b: Bar() eval(myObject.size() < 3)") ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("myObject.setIsValid(\"19-Jul-1992\")") > -1 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testDeclaresXLS() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("DeclaresWorkbook.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("declare Smurf name : String end") > -1 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testDeclaresCSV() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("DeclaresWorkbook.drl.csv", InputType.CSV);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("declare Smurf name : String end") > -1 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testAttributesXLS() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("Attributes.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        int rule1 = drl.indexOf("rule \"N1\"");
        Assertions.assertThat((rule1 == -1 ? 1 : 0) != 0).isFalse();
        Assertions.assertThat((drl.indexOf("no-loop true", rule1) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("duration 100", rule1) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("salience 1", rule1) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("ruleflow-group \"RFG1\"", rule1) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("agenda-group \"AG1\"", rule1) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("timer (T1)", rule1) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("lock-on-active true", rule1) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("activation-group \"g1\"", rule1) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("auto-focus true", rule1) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("calendars \"CAL1\"", rule1) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("date-effective \"01-Jan-2007\"", rule1) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("date-expires \"31-Dec-2007\"", rule1) > -1 ? 1 : 0) != 0).isTrue();
        int rule2 = drl.indexOf("rule \"N2\"");
        Assertions.assertThat((rule2 == -1 ? 1 : 0) != 0).isFalse();
        Assertions.assertThat((drl.indexOf("no-loop false", rule2) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("duration 200", rule2) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("salience 2", rule2) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("ruleflow-group \"RFG2\"", rule2) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("agenda-group \"AG2\"", rule2) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("timer (T2)", rule2) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("lock-on-active false", rule2) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("activation-group \"g2\"", rule2) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("auto-focus false", rule2) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("calendars \"CAL2\"", rule2) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("date-effective \"01-Jan-2012\"", rule2) > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("date-expires \"31-Dec-2015\"", rule2) > -1 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testPropertiesXLS() {
        ArrayList<DefaultRuleSheetListener> listeners = new ArrayList<DefaultRuleSheetListener>();
        DefaultRuleSheetListener listener = new DefaultRuleSheetListener();
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("Properties.drl.xls");
        parser.parseFile(is);
        listener.getProperties();
        String rulesetName = listener.getProperties().getSingleProperty("RuleSet");
        Assertions.assertThat((String)rulesetName).isNotNull();
        Assertions.assertThat((String)rulesetName).isEqualTo("Properties");
        List importList = RuleSheetParserUtil.getImportList((List)listener.getProperties().getProperty("Import"));
        Assertions.assertThat((List)importList).isNotNull();
        Assertions.assertThat((int)importList.size()).isEqualTo(1);
        Assertions.assertThat((String)((Import)importList.get(0)).getClassName()).isEqualTo("java.util.List");
        List variableList = RuleSheetParserUtil.getVariableList((List)listener.getProperties().getProperty("Variables"));
        Assertions.assertThat((List)variableList).isNotNull();
        Assertions.assertThat((int)variableList.size()).isEqualTo(1);
        Assertions.assertThat((String)((Global)variableList.get(0)).getClassName()).isEqualTo("java.util.List");
        Assertions.assertThat((String)((Global)variableList.get(0)).getIdentifier()).isEqualTo("list");
        List functions = listener.getProperties().getProperty("Functions");
        Assertions.assertThat((List)functions).isNotNull();
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)functions.get(0))).isEqualTo("A function");
        List queries = listener.getProperties().getProperty("Queries");
        Assertions.assertThat((List)queries).isNotNull();
        Assertions.assertThat((int)queries.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)queries.get(0))).isEqualTo("A query");
        List declarations = listener.getProperties().getProperty("Declare");
        Assertions.assertThat((List)declarations).isNotNull();
        Assertions.assertThat((int)declarations.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)declarations.get(0))).isEqualTo("A declared type");
        String sequentialFlag = listener.getProperties().getSingleProperty("Sequential");
        Assertions.assertThat((String)sequentialFlag).isNotNull();
        Assertions.assertThat((String)sequentialFlag).isEqualTo("false");
        String escapeQuotesFlag = listener.getProperties().getSingleProperty("EscapeQuotes");
        Assertions.assertThat((String)escapeQuotesFlag).isNotNull();
        Assertions.assertThat((String)escapeQuotesFlag).isEqualTo("false");
    }

    @Test
    public void testPropertiesWithWhiteSpaceXLS() {
        ArrayList<DefaultRuleSheetListener> listeners = new ArrayList<DefaultRuleSheetListener>();
        DefaultRuleSheetListener listener = new DefaultRuleSheetListener();
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("PropertiesWithWhiteSpace.drl.xls");
        parser.parseFile(is);
        listener.getProperties();
        String rulesetName = listener.getProperties().getSingleProperty("RuleSet");
        Assertions.assertThat((String)rulesetName).isNotNull();
        Assertions.assertThat((String)rulesetName).isEqualTo("Properties");
        List importList = RuleSheetParserUtil.getImportList((List)listener.getProperties().getProperty("Import"));
        Assertions.assertThat((List)importList).isNotNull();
        Assertions.assertThat((int)importList.size()).isEqualTo(1);
        Assertions.assertThat((String)((Import)importList.get(0)).getClassName()).isEqualTo("java.util.List");
        List variableList = RuleSheetParserUtil.getVariableList((List)listener.getProperties().getProperty("Variables"));
        Assertions.assertThat((List)variableList).isNotNull();
        Assertions.assertThat((int)variableList.size()).isEqualTo(1);
        Assertions.assertThat((String)((Global)variableList.get(0)).getClassName()).isEqualTo("java.util.List");
        Assertions.assertThat((String)((Global)variableList.get(0)).getIdentifier()).isEqualTo("list");
        List functions = listener.getProperties().getProperty("Functions");
        Assertions.assertThat((List)functions).isNotNull();
        Assertions.assertThat((int)functions.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)functions.get(0))).isEqualTo("A function");
        List queries = listener.getProperties().getProperty("Queries");
        Assertions.assertThat((List)queries).isNotNull();
        Assertions.assertThat((int)queries.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)queries.get(0))).isEqualTo("A query");
        List declarations = listener.getProperties().getProperty("Declare");
        Assertions.assertThat((List)declarations).isNotNull();
        Assertions.assertThat((int)declarations.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)declarations.get(0))).isEqualTo("A declared type");
        String sequentialFlag = listener.getProperties().getSingleProperty("Sequential");
        Assertions.assertThat((String)sequentialFlag).isNotNull();
        Assertions.assertThat((String)sequentialFlag).isEqualTo("false");
        String escapeQuotesFlag = listener.getProperties().getSingleProperty("EscapeQuotes");
        Assertions.assertThat((String)escapeQuotesFlag).isNotNull();
        Assertions.assertThat((String)escapeQuotesFlag).isEqualTo("false");
    }

    @Test
    public void testProcessSheetForExtremeLowNumbers() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/BasicWorkbook_with_low_values.drl.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        System.out.println(drl);
        Assertions.assertThat((drl.indexOf("myObject.size() < 0") == -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("myObject.size() < 8.0E-11") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("myObject.size() < 9.0E-7") > -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("myObject.size() < 3.0E-4") > -1 ? 1 : 0) != 0).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegativeNumbers() throws Exception {
        KieBase kbase = this.readKnowledgeBase("/data/DT_WithNegativeNumbers.drl.xls");
        KieSession ksession = kbase.newKieSession();
        try {
            IntHolder i1 = new IntHolder(1);
            IntHolder i2 = new IntHolder(-1);
            ksession.insert((Object)i1);
            ksession.insert((Object)i2);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testOOXMLParseCellValue() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/BZ963584.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
    }

    @Test
    public void testNoConstraintsEmptyCells() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/NoConstraintsEmptyCells.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        String expected = "package data;\n//generated from Decision Table\nimport org.drools.decisiontable.Person;\n// rule values at C10, header at C5\nrule \"Cheese fans_10\"\n  when\n    Person(age == \"55\")\n  then\nend\n// rule values at C11, header at C5\nrule \"Cheese fans_11\"\n  when\n    Person(name == \"Fred\")\n  then\nend\n// rule values at C12, header at C5\nrule \"Cheese fans_12\"\n  when\n    Person(name == \"Fred\", age == \"55\")\n  then\nend";
        Assertions.assertThat((String)"package data;\n//generated from Decision Table\nimport org.drools.decisiontable.Person;\n// rule values at C10, header at C5\nrule \"Cheese fans_10\"\n  when\n    Person(age == \"55\")\n  then\nend\n// rule values at C11, header at C5\nrule \"Cheese fans_11\"\n  when\n    Person(name == \"Fred\")\n  then\nend\n// rule values at C12, header at C5\nrule \"Cheese fans_12\"\n  when\n    Person(name == \"Fred\", age == \"55\")\n  then\nend").isEqualToIgnoringWhitespace((CharSequence)drl);
    }

    @Test
    public void testNoConstraintsSpacesInCells() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/NoConstraintsSpacesInCells.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        String expected = "package data;\n//generated from Decision Table\nimport org.drools.decisiontable.Person;\n// rule values at C10, header at C5\nrule \"Cheese fans_10\"\n  when\n    Person(age == \"55\")\n  then\nend\n// rule values at C11, header at C5\nrule \"Cheese fans_11\"\n  when\n    Person(name == \"Fred\")\n  then\nend\n// rule values at C12, header at C5\nrule \"Cheese fans_12\"\n  when\n    Person(name == \"Fred\", age == \"55\")\n  then\nend";
        Assertions.assertThat((String)"package data;\n//generated from Decision Table\nimport org.drools.decisiontable.Person;\n// rule values at C10, header at C5\nrule \"Cheese fans_10\"\n  when\n    Person(age == \"55\")\n  then\nend\n// rule values at C11, header at C5\nrule \"Cheese fans_11\"\n  when\n    Person(name == \"Fred\")\n  then\nend\n// rule values at C12, header at C5\nrule \"Cheese fans_12\"\n  when\n    Person(name == \"Fred\", age == \"55\")\n  then\nend").isEqualToIgnoringWhitespace((CharSequence)drl);
    }

    @Test
    public void testNoConstraintsDelimitedSpacesInCells() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/NoConstraintsDelimitedSpacesInCells.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        String expected = "package data;\n//generated from Decision Table\nimport org.drools.decisiontable.Person;\n// rule values at C10, header at C5\nrule \"Cheese fans_10\"\n  when\n    Person(name == \"     \", age == \"55\")\n  then\nend\n// rule values at C11, header at C5\nrule \"Cheese fans_11\"\n  when\n    Person(name == \"Fred\", age == \"\")\n  then\nend\n// rule values at C12, header at C5\nrule \"Cheese fans_12\"\n  when\n    Person(name == \"Fred\", age == \"55\")\n  then\nend\n// rule values at C13, header at C5\nrule \"Cheese fans_13\"\n  when\n    Person(name == \"     \", age == \"\")\n  then\nend\n// rule values at C14, header at C5\nrule \"Cheese fans_14\"\n  when\n    Person(name == \"\", age == \"55\")\n  then\nend\n// rule values at C15, header at C5\nrule \"Cheese fans_15\"\n  when\n    Person(name == \"Fred\", age == \"\")\n  then\nend";
        Assertions.assertThat((String)"package data;\n//generated from Decision Table\nimport org.drools.decisiontable.Person;\n// rule values at C10, header at C5\nrule \"Cheese fans_10\"\n  when\n    Person(name == \"     \", age == \"55\")\n  then\nend\n// rule values at C11, header at C5\nrule \"Cheese fans_11\"\n  when\n    Person(name == \"Fred\", age == \"\")\n  then\nend\n// rule values at C12, header at C5\nrule \"Cheese fans_12\"\n  when\n    Person(name == \"Fred\", age == \"55\")\n  then\nend\n// rule values at C13, header at C5\nrule \"Cheese fans_13\"\n  when\n    Person(name == \"     \", age == \"\")\n  then\nend\n// rule values at C14, header at C5\nrule \"Cheese fans_14\"\n  when\n    Person(name == \"\", age == \"55\")\n  then\nend\n// rule values at C15, header at C5\nrule \"Cheese fans_15\"\n  when\n    Person(name == \"Fred\", age == \"\")\n  then\nend").isEqualToIgnoringWhitespace((CharSequence)drl);
    }

    @Test
    public void testForAllConstraintQuoteRemoval() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/ForAllConstraintQuoteRemoval.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        String expected = "package data;\n//generated from Decision Table\nimport com.brms.dto.fact.*;\ndialect \"mvel\";\n// rule values at C21, header at C16\nrule \"enrichment_21\"\n  when\n    p:Payment(fileFormat == \"TOTO\")\n  then\n    System.out.println(true);\nend\n// rule values at C22, header at C16\nrule \"enrichment_22\"\n  when\n    p:Payment(fileFormat == \"TOTO\")\n  then\n    System.out.println(true);\nend\n// rule values at C23, header at C16\nrule \"enrichment_23\"\n  when\n    p:Payment(fileFormat == \"TOTO\" || fileFormat == \"TITI\" || fileFormat == \"TOR\")\n  then\n    System.out.println(true);\nend\n// rule values at C24, header at C16\nrule \"enrichment_24\"\n  when\n    p:Payment(fileFormat == \"TOTO\" || fileFormat == \"TOR\")\n  then\n    System.out.println(true);\nend\n// rule values at C25, header at C16\nrule \"enrichment_25\"\n  when\n    p:Payment(fileFormat == \"TITI\", isConsistencyCheckEnabled == \"true\")\n  then\n    System.out.println(true);\nend\n// rule values at C26, header at C16\nrule \"enrichment_26\"\n  when\n  then\n    System.out.println(false);\nend\n";
        Assertions.assertThat((String)"package data;\n//generated from Decision Table\nimport com.brms.dto.fact.*;\ndialect \"mvel\";\n// rule values at C21, header at C16\nrule \"enrichment_21\"\n  when\n    p:Payment(fileFormat == \"TOTO\")\n  then\n    System.out.println(true);\nend\n// rule values at C22, header at C16\nrule \"enrichment_22\"\n  when\n    p:Payment(fileFormat == \"TOTO\")\n  then\n    System.out.println(true);\nend\n// rule values at C23, header at C16\nrule \"enrichment_23\"\n  when\n    p:Payment(fileFormat == \"TOTO\" || fileFormat == \"TITI\" || fileFormat == \"TOR\")\n  then\n    System.out.println(true);\nend\n// rule values at C24, header at C16\nrule \"enrichment_24\"\n  when\n    p:Payment(fileFormat == \"TOTO\" || fileFormat == \"TOR\")\n  then\n    System.out.println(true);\nend\n// rule values at C25, header at C16\nrule \"enrichment_25\"\n  when\n    p:Payment(fileFormat == \"TITI\", isConsistencyCheckEnabled == \"true\")\n  then\n    System.out.println(true);\nend\n// rule values at C26, header at C16\nrule \"enrichment_26\"\n  when\n  then\n    System.out.println(false);\nend\n").isEqualToIgnoringWhitespace((CharSequence)drl);
    }

    private KieBase readKnowledgeBase(String resource) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        DecisionTableConfiguration config = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        config.setInputType(DecisionTableInputType.XLS);
        kbuilder.add(ResourceFactory.newClassPathResource((String)resource, this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)config);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Test
    public void testFunctionCellMerged() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/FunctionCellMerged.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((boolean)drl.contains("function void test(){")).isTrue();
    }

    @Test
    public void testMoreThan9InputParamSubstitution() throws Exception {
        String EXPECTED_CONDITION = "eval ($objects: Object (id == a ||  == b ||  == c ||  == d ||  == e ||  == f ||  == g ||  == h ||  == i  ||  == j  ) )";
        String EXPECTED_ACTION = "System.out.println(\u201ctest\u201d + a  + b   + c  + d  + e  + f  + g + h  + i + j);";
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/DROOLS-836.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((boolean)drl.contains("eval ($objects: Object (id == a ||  == b ||  == c ||  == d ||  == e ||  == f ||  == g ||  == h ||  == i  ||  == j  ) )")).isTrue();
        Assertions.assertThat((boolean)drl.contains("System.out.println(\u201ctest\u201d + a  + b   + c  + d  + e  + f  + g + h  + i + j);")).isTrue();
    }

    @Test
    public void testDtableUsingExcelFunction() throws Exception {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/RuleNameUsingExcelFunction.drl.xls", InputType.XLS);
        String EXPECTED_RULE_NAME = "rule \"RULE_500\"";
        Assertions.assertThat((boolean)drl.contains("rule \"RULE_500\"")).isTrue();
    }

    @Test
    public void checkLhsBuilderFixValue() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/DROOLS-1279.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        String expected = "package data;\n//generated from Decision Table\nimport com.sample.DecisionTableTest.Message;\ndialect \"mvel\"\n// rule values at C12, header at C7\nrule \"HelloWorld_12\"\n  when\n    m:Message(checktest in(\"AAA\"), status == \"Message.HELLO\")\n  then\n    System.out.println(m.getMessage());\n    m.setMessage(\"Goodbye cruel world\");update(m);\n    m.setChecktest(\"BBB\");update(m);\nend\n// rule values at C13, header at C7\nrule \"HelloWorld_13\"\n  when\n    m:Message(checktest in(\"BBB\", \"CCC\"), status == \"Message.GOODBYE\")\n  then\n    System.out.println(m.getMessage());\nend\n";
        Assertions.assertThat((String)"package data;\n//generated from Decision Table\nimport com.sample.DecisionTableTest.Message;\ndialect \"mvel\"\n// rule values at C12, header at C7\nrule \"HelloWorld_12\"\n  when\n    m:Message(checktest in(\"AAA\"), status == \"Message.HELLO\")\n  then\n    System.out.println(m.getMessage());\n    m.setMessage(\"Goodbye cruel world\");update(m);\n    m.setChecktest(\"BBB\");update(m);\nend\n// rule values at C13, header at C7\nrule \"HelloWorld_13\"\n  when\n    m:Message(checktest in(\"BBB\", \"CCC\"), status == \"Message.GOODBYE\")\n  then\n    System.out.println(m.getMessage());\nend\n").isEqualToIgnoringWhitespace((CharSequence)drl);
    }

    @Test
    public void testLhsOrder() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/LhsOrder.drl.xls", InputType.XLS);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])Stream.of(drl.split("\n")).map(String::trim).toArray()).as("Lhs order is wrong", new Object[0])).containsSequence(new Object[]{"accumulate(Person(name == \"John\", $a : age); $max:max($a))", "$p:Person(name == \"John\", age == $max)"});
    }

    @Test
    public void testNewLineInConstraint() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/NewLineInConstraint.drl.xls", InputType.XLS);
        Assertions.assertThat((boolean)drl.contains("map[\"Key2\"] == var2")).isTrue();
    }

    @Test
    public void testNoUnit() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/CanDrink.drl.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assertions.assertThat((boolean)drl.contains("$p: Person(age < 18)")).isTrue();
    }

    @Test
    public void testNoLhsParam() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/CanDrinkNoParam.drl.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assertions.assertThat((boolean)drl.contains("$p : Person( age < 18 )\n")).isTrue();
    }

    @Test
    public void testChecksOnLhs() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/CanDrinkCheckOnLhs.drl.xls");
        String drl = converter.compile(stream, InputType.XLS);
        System.out.println(drl);
        Assertions.assertThat((boolean)drl.contains("$p : Person(age < 18, name == \"Matteo\")\n")).isTrue();
    }

    @Test
    public void testRuleUnit() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/CanDrinkUnit.drl.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assertions.assertThat((boolean)drl.contains("unit CanDrinkUnit;")).isTrue();
        Assertions.assertThat((boolean)drl.contains("query Results $r: /results end")).isTrue();
        Assertions.assertThat((boolean)drl.contains("$p: /persons[age < 18]")).isTrue();
    }

    @Test
    public void testUseWatchAnnotation() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/CanDrinkUsingWatch.drl.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assertions.assertThat((boolean)drl.contains("$p: Person(age < 18) @watch(name)")).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZipBomb() {
        System.setProperty("drools.excelParser.minInflateRatio", "0.001");
        try {
            SpreadsheetCompiler converter = new SpreadsheetCompiler();
            InputStream stream = this.getClass().getResourceAsStream("/data/Sample2.drl.xlsx");
            String drl = converter.compile(stream, InputType.XLS);
            Assertions.assertThat((boolean)drl.contains("m:Message(status == Message.HELLO)")).isTrue();
        }
        finally {
            System.clearProperty("drools.excelParser.minInflateRatio");
        }
    }

    @Test
    public void testForAll() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/Hal1.drl.xls", InputType.XLS);
        Assertions.assertThat((boolean)drl.contains("m : Message(number >5 && number <=10)")).isTrue();
    }

    public static class IntHolder {
        private int value;

        public IntHolder(int i) {
            this.value = i;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "IntHolder [value=" + this.value + "]";
        }
    }
}

