/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.csv;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.parser.csv.CsvLineParser;
import org.junit.Test;

public class CsvLineParserTest {
    @Test
    public void testSimpleLineParse() {
        CsvLineParser parser = new CsvLineParser();
        String s = "a,b,c";
        List list = parser.parse((CharSequence)"a,b,c");
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("a");
        Assertions.assertThat((String)((String)list.get(1))).isEqualTo("b");
        Assertions.assertThat((String)((String)list.get(2))).isEqualTo("c");
    }

    @Test
    public void testLineParse() {
        CsvLineParser parser = new CsvLineParser();
        String s = "a,\"b\",c";
        List list = parser.parse((CharSequence)"a,\"b\",c");
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("a");
        Assertions.assertThat((String)((String)list.get(1))).isEqualTo("b");
        Assertions.assertThat((String)((String)list.get(2))).isEqualTo("c");
    }

    @Test
    public void testDoubleQuotes() {
        CsvLineParser parser = new CsvLineParser();
        String s = "a,\"\"\"b\"\"\",c";
        List list = parser.parse((CharSequence)"a,\"\"\"b\"\"\",c");
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("a");
        Assertions.assertThat((String)((String)list.get(1))).isEqualTo("\"b\"");
        Assertions.assertThat((String)((String)list.get(2))).isEqualTo("c");
    }
}

