/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.RulesheetUtil;
import org.drools.decisiontable.parser.xls.PropertiesSheetListener;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.Package;
import org.drools.template.model.Rule;
import org.drools.template.parser.DecisionTableParseException;
import org.junit.Ignore;
import org.junit.Test;

public class RuleWorksheetParseFromFileTest {
    private RuleSheetListener listener;
    private InputStream stream;
    private Package ruleset;

    @Test
    public void testBasicWorkbookProperties() throws Exception {
        this.stream = RuleWorksheetParseFromFileTest.class.getResourceAsStream("/data/BasicWorkbook.drl.xls");
        this.listener = RulesheetUtil.getRuleSheetListener(this.stream);
        PropertiesSheetListener.CaseInsensitiveMap props = this.listener.getProperties();
        Assertions.assertThat((Map)props).isNotNull();
        Assertions.assertThat((String)props.getSingleProperty("RuleSet")).isEqualTo("data");
        Assertions.assertThat((String)props.getSingleProperty("misc")).isEqualTo("someMisc");
    }

    @Test
    public void testComplexWorkbookProperties() throws Exception {
        this.stream = RuleWorksheetParseFromFileTest.class.getResourceAsStream("/data/ComplexWorkbook.drl.xls");
        this.listener = RulesheetUtil.getRuleSheetListener(this.stream);
        PropertiesSheetListener.CaseInsensitiveMap props = this.listener.getProperties();
        Assertions.assertThat((Map)props).isNotNull();
        Assertions.assertThat((String)props.getSingleProperty("RuleSet")).isEqualTo("data");
    }

    @Test
    public void testWorkbookParse() throws Exception {
        this.stream = RuleWorksheetParseFromFileTest.class.getResourceAsStream("/data/BasicWorkbook.drl.xls");
        this.listener = RulesheetUtil.getRuleSheetListener(this.stream);
        this.ruleset = this.listener.getRuleSet();
        Assertions.assertThat((Object)this.ruleset).isNotNull();
        Rule firstRule = (Rule)this.ruleset.getRules().get(0);
        Assertions.assertThat((String)firstRule.getSalience()).isNotNull();
        Assertions.assertThat((int)Integer.parseInt(firstRule.getSalience())).isGreaterThan(0);
        Assertions.assertThat((String)this.ruleset.getName()).isEqualTo("data");
        Assertions.assertThat((List)this.ruleset.getImports()).hasSize(3);
        Assertions.assertThat((List)this.ruleset.getRules()).hasSize(6);
        Assertions.assertThat((List)this.ruleset.getImports()).extracting(x -> x.getClassName()).containsExactly((Object[])new String[]{"blah.class1", "blah.class2", "lah.di.dah"});
        Rule rule = (Rule)this.ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        Assertions.assertThat((String)cond.getSnippet()).isEqualTo("Foo(myObject.getColour().equals(red), myObject.size () > 12\\\")");
        Consequence cons = (Consequence)rule.getConsequences().get(0);
        Assertions.assertThat((Object)cons).isNotNull();
        Assertions.assertThat((String)cons.getSnippet()).isEqualTo("myObject.setIsValid(Y);");
        Rule rule5 = (Rule)this.ruleset.getRules().get(5);
        Condition cond5 = (Condition)rule5.getConditions().get(1);
        Assertions.assertThat((String)cond5.getSnippet()).isEqualTo("myObject.size () > 7");
        Consequence cons5 = (Consequence)rule5.getConsequences().get(0);
        Assertions.assertThat((String)cons5.getSnippet()).isEqualTo("myObject.setIsValid(10-Jul-1974)");
    }

    @Test
    public void testQuoteEscapingEnabled() throws Exception {
        this.stream = RuleWorksheetParseFromFileTest.class.getResourceAsStream("/data/QuoteEscapeEnabledWorkbook.drl.xls");
        this.listener = RulesheetUtil.getRuleSheetListener(this.stream);
        this.ruleset = this.listener.getRuleSet();
        Assertions.assertThat((Object)this.ruleset).isNotNull();
        Rule rule = (Rule)this.ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        Assertions.assertThat((String)cond.getSnippet()).isEqualTo("Foo(myObject.getColour().equals(red), myObject.size () > 12\\\")");
    }

    @Test
    public void testQuoteEscapingDisabled() throws Exception {
        this.stream = RuleWorksheetParseFromFileTest.class.getResourceAsStream("/data/QuoteEscapeDisabledWorkbook.drl.xls");
        this.listener = RulesheetUtil.getRuleSheetListener(this.stream);
        this.ruleset = this.listener.getRuleSet();
        Assertions.assertThat((Object)this.ruleset).isNotNull();
        Rule rule = (Rule)this.ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        Assertions.assertThat((String)cond.getSnippet()).isEqualTo("Foo(myObject.getColour().equals(red), myObject.size () > \"12\")");
        Rule rule1 = (Rule)this.ruleset.getRules().get(1);
        Condition cond1 = (Condition)rule1.getConditions().get(0);
        Assertions.assertThat((String)cond1.getSnippet()).isEqualTo("Foo(myObject.getColour().equals(blue), myObject.size () > 12\")");
    }

    @Test
    public void testSalienceRange() throws Exception {
        this.stream = RuleWorksheetParseFromFileTest.class.getResourceAsStream("/data/SalienceRangeWorkbook.drl.xls");
        this.listener = RulesheetUtil.getRuleSheetListener(this.stream);
        this.ruleset = this.listener.getRuleSet();
        Assertions.assertThat((Object)this.ruleset).isNotNull();
        List rules = this.ruleset.getRules();
        Assertions.assertThat((String)((Rule)rules.get(0)).getSalience()).isEqualTo("10000");
        Assertions.assertThat((String)((Rule)rules.get(1)).getSalience()).isEqualTo("9999");
    }

    @Test
    public void testSalienceOutOfRange() throws Exception {
        this.stream = RuleWorksheetParseFromFileTest.class.getResourceAsStream("/data/SalienceOutOfRangeWorkbook.drl.xls");
        Assertions.assertThatExceptionOfType(DecisionTableParseException.class).isThrownBy(() -> RulesheetUtil.getRuleSheetListener(this.stream));
    }

    @Test
    public void testComplexWorksheetMissingConditionsInLocaleEnUs() throws Exception {
        Locale originalDefaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        try {
            this.doComplexWorksheetMissingConditions();
        }
        finally {
            Locale.setDefault(originalDefaultLocale);
        }
    }

    @Test
    @Ignore
    public void testComplexWorksheetMissingConditionsInLocaleFrFr() throws Exception {
        Locale originalDefaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.FRANCE);
        try {
            this.doComplexWorksheetMissingConditions();
        }
        finally {
            Locale.setDefault(originalDefaultLocale);
        }
    }

    private void doComplexWorksheetMissingConditions() throws IOException {
        this.stream = RuleWorksheetParseFromFileTest.class.getResourceAsStream("/data/ComplexWorkbook.drl.xls");
        this.listener = RulesheetUtil.getRuleSheetListener(this.stream);
        this.ruleset = this.listener.getRuleSet();
        Assertions.assertThat((List)this.ruleset.getRules()).hasSize(6);
        Assertions.assertThat((List)this.ruleset.getImports()).hasSize(0);
        Rule rule = (Rule)this.ruleset.getRules().get(0);
        Assertions.assertThat((List)rule.getConditions()).hasSize(3);
        Assertions.assertThat((List)rule.getConsequences()).hasSize(2);
        Consequence cons = (Consequence)rule.getConsequences().get(1);
        Assertions.assertThat((String)cons.getSnippet()).isEqualTo("myObject.setIsValid(1, 2)");
        Condition con = (Condition)rule.getConditions().get(2);
        Assertions.assertThat((String)con.getSnippet()).isEqualTo("myObject.size() < $3.00");
        Rule rule4 = (Rule)this.ruleset.getRules().get(4);
        Assertions.assertThat((List)rule4.getConditions()).hasSize(1);
        Rule rule5 = (Rule)this.ruleset.getRules().get(5);
        Assertions.assertThat((List)rule5.getConditions()).hasSize(2);
        Assertions.assertThat((List)rule5.getConsequences()).hasSize(1);
    }

    @Test
    public void testNumericDisabled() throws Exception {
        this.stream = RuleWorksheetParseFromFileTest.class.getResourceAsStream("/data/NumericDisabled.drl.xls");
        this.listener = RulesheetUtil.getRuleSheetListener(this.stream);
        this.ruleset = this.listener.getRuleSet();
        Assertions.assertThat((Object)this.ruleset).isNotNull();
        Rule rule = (Rule)this.ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        Assertions.assertThat((String)cond.getSnippet()).isEqualTo("Cheese(price == 6600)");
    }

    @Test
    public void numericDisabled_timestamp() throws Exception {
        this.stream = RuleWorksheetParseFromFileTest.class.getResourceAsStream("/data/NumericDisabledForTimestamp.drl.xls");
        this.listener = RulesheetUtil.getRuleSheetListener(this.stream);
        this.ruleset = this.listener.getRuleSet();
        Assertions.assertThat((Object)this.ruleset).isNotNull();
        Rule rule = (Rule)this.ruleset.getRules().get(0);
        Consequence cond = (Consequence)rule.getConsequences().get(1);
        Assertions.assertThat((String)cond.getSnippet()).containsIgnoringWhitespaces(new CharSequence[]{"value = \"00:00:00\""});
    }
}

