/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;
import org.drools.decisiontable.parser.RuleMatrixSheetListener;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.xls.ExcelParser;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class SpreadsheetCompilerUnitTest {
    private SpreadsheetCompiler converter;

    @Before
    public void setUp() {
        this.converter = new SpreadsheetCompiler();
    }

    @Test
    public void testLoadFromClassPath() {
        String drl = this.converter.compile("/data/MultiSheetDST.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("rule \"How cool am I_12\"") > drl.indexOf("rule \"How cool am I_11\"") ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"import example.model.User;"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"import example.model.Car;"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"package "});
        InputStream ins = this.getClass().getResourceAsStream("/data/MultiSheetDST.drl.xls");
        drl = this.converter.compile(false, ins, InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("rule \"How cool am I_12\"") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"import example.model.User;"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"import example.model.Car;"});
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"package "});
    }

    @Test
    public void testMultilineActions() {
        InputStream stream = this.getClass().getResourceAsStream("MultiLinesInAction.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"\\n"});
    }

    @Test
    public void testMultilineActionsAndMultiLineInConstant() {
        InputStream stream = this.getClass().getResourceAsStream("MultiLinesInActionAndMultiLineInConstant.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).contains(new CharSequence[]{" **\n** "});
    }

    @Test
    public void testMultilineActionsAndMultiLineAsConstant() {
        InputStream stream = this.getClass().getResourceAsStream("MultiLinesInActionAndMultiLineAsConstant.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).contains(new CharSequence[]{" **\\n** "});
    }

    @Test
    public void testMultilineCommentsInDescription() {
        InputStream stream = this.getClass().getResourceAsStream("/data/Multiline comment example.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).containsSubsequence(new CharSequence[]{"/* Say", "Hello */", "/* Say", "Goobye */"});
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"// Say"});
    }

    @Test
    public void testMultilineComplexCommentsInDescription() {
        InputStream stream = this.getClass().getResourceAsStream("/data/Multiline comment example complex.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).containsSubsequence(new CharSequence[]{"/* Do these actions:", "- Print Greeting", "- Set params: {message:'bye cruel world', status:'bye'} */", "/* Print message: \"Bye!\"", "Author: james@company.org */"});
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"* - Print Greeting"});
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"* - Set params: {message:'bye cruel world', status:'bye'}"});
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"* Author: james@company.org"});
    }

    @Test
    public void testLoadSpecificWorksheet() {
        InputStream stream = this.getClass().getResourceAsStream("/data/MultiSheetDST.drl.xls");
        String drl = this.converter.compile(stream, "Another Sheet");
        Assertions.assertThat((String)drl).isNotNull();
    }

    @Test
    public void testLoadCustomListener() {
        InputStream stream = this.getClass().getResourceAsStream("/data/CustomWorkbook.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS, (RuleSheetListener)new RuleMatrixSheetListener());
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("\"matrix\"") != -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("$v : FundVisibility") != -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("FundType") != -1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("Role") != -1 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testLoadCsv() {
        InputStream stream = this.getClass().getResourceAsStream("/data/ComplexWorkbook.drl.csv");
        String drl = this.converter.compile(stream, InputType.CSV);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("myObject.setIsValid(1, 2)") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("myObject.size () > 50") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size () > 1)") > 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testLoadBasicWithMergedCells() {
        InputStream stream = this.getClass().getResourceAsStream("/data/BasicWorkbook.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        Pattern p = Pattern.compile(".*setIsValid\\(Y\\).*setIsValid\\(Y\\).*setIsValid\\(Y\\).*", 40);
        Matcher m = p.matcher(drl);
        Assertions.assertThat((boolean)m.matches()).isTrue();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"This is a function block"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"global Class1 obj1;"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"myObject.setIsValid(10-Jul-1974)"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"myObject.getColour().equals(blue)"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"Foo(myObject.getColour().equals(red), myObject.size () > 12\\\")"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"b: Bar() eval(myObject.size() < 3)"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"b: Bar() eval(myObject.size() < 9)"});
        Assertions.assertThat((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size () > 1)") < drl.indexOf("b: Bar() eval(myObject.size() < 3)") ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"myObject.setIsValid(\"19-Jul-1992\")"});
    }

    @Test
    public void testDeclaresXLS() {
        String drl = this.converter.compile("DeclaresWorkbook.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"declare Smurf name : String end"});
    }

    @Test
    public void testDeclaresCSV() {
        String drl = this.converter.compile("DeclaresWorkbook.drl.csv", InputType.CSV);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"declare Smurf name : String end"});
    }

    @Test
    public void testAttributesXLS() {
        String drl = this.converter.compile("Attributes.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"rule \"N1\""});
        drl = drl.substring(drl.indexOf("rule \"N1\""));
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"no-loop true"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"duration 100"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"salience 1"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"ruleflow-group \"RFG1\""});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"agenda-group \"AG1\""});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"timer (T1)"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"lock-on-active true"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"activation-group \"g1\""});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"auto-focus true"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"calendars \"CAL1\""});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"date-effective \"01-Jan-2007\""});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"date-expires \"31-Dec-2007\""});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"rule \"N2\""});
        drl = drl.substring(drl.indexOf("rule \"N2\""));
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"no-loop false"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"duration 200"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"salience 2"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"ruleflow-group \"RFG2\""});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"agenda-group \"AG2\""});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"timer (T2)"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"lock-on-active false"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"activation-group \"g2\""});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"auto-focus false"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"calendars \"CAL2\""});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"date-effective \"01-Jan-2012\""});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"date-expires \"31-Dec-2015\""});
    }

    @Test
    public void testPropertiesXLS() {
        ArrayList<DefaultRuleSheetListener> listeners = new ArrayList<DefaultRuleSheetListener>();
        DefaultRuleSheetListener listener = new DefaultRuleSheetListener();
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("Properties.drl.xls");
        parser.parseFile(is);
        listener.getProperties();
        String rulesetName = listener.getProperties().getSingleProperty("RuleSet");
        ((AbstractStringAssert)Assertions.assertThat((String)rulesetName).isNotNull()).isEqualTo("Properties");
        List importList = RuleSheetParserUtil.getImportList((List)listener.getProperties().getProperty("Import"));
        ((ListAssert)Assertions.assertThat((List)importList).isNotNull()).hasSize(1);
        Assertions.assertThat((String)((Import)importList.get(0)).getClassName()).isEqualTo("java.util.List");
        List variableList = RuleSheetParserUtil.getVariableList((List)listener.getProperties().getProperty("Variables"));
        ((ListAssert)Assertions.assertThat((List)variableList).isNotNull()).hasSize(1);
        Assertions.assertThat((String)((Global)variableList.get(0)).getClassName()).isEqualTo("java.util.List");
        Assertions.assertThat((String)((Global)variableList.get(0)).getIdentifier()).isEqualTo("list");
        List functions = listener.getProperties().getProperty("Functions");
        ((ListAssert)((ListAssert)Assertions.assertThat((List)functions).isNotNull()).hasSize(1)).containsExactly((Object[])new String[]{"A function"});
        List queries = listener.getProperties().getProperty("Queries");
        ((ListAssert)((ListAssert)Assertions.assertThat((List)queries).isNotNull()).hasSize(1)).containsExactly((Object[])new String[]{"A query"});
        List declarations = listener.getProperties().getProperty("Declare");
        ((ListAssert)((ListAssert)Assertions.assertThat((List)declarations).isNotNull()).hasSize(1)).containsExactly((Object[])new String[]{"A declared type"});
        String sequentialFlag = listener.getProperties().getSingleProperty("Sequential");
        ((AbstractStringAssert)Assertions.assertThat((String)sequentialFlag).isNotNull()).isEqualTo("false");
        String escapeQuotesFlag = listener.getProperties().getSingleProperty("EscapeQuotes");
        ((AbstractStringAssert)Assertions.assertThat((String)escapeQuotesFlag).isNotNull()).isEqualTo("false");
    }

    @Test
    public void testPropertiesWithWhiteSpaceXLS() {
        ArrayList<DefaultRuleSheetListener> listeners = new ArrayList<DefaultRuleSheetListener>();
        DefaultRuleSheetListener listener = new DefaultRuleSheetListener();
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("PropertiesWithWhiteSpace.drl.xls");
        parser.parseFile(is);
        listener.getProperties();
        String rulesetName = listener.getProperties().getSingleProperty("RuleSet");
        ((AbstractStringAssert)Assertions.assertThat((String)rulesetName).isNotNull()).isEqualTo("Properties");
        List importList = RuleSheetParserUtil.getImportList((List)listener.getProperties().getProperty("Import"));
        ((ListAssert)Assertions.assertThat((List)importList).isNotNull()).hasSize(1);
        Assertions.assertThat((String)((Import)importList.get(0)).getClassName()).isEqualTo("java.util.List");
        List variableList = RuleSheetParserUtil.getVariableList((List)listener.getProperties().getProperty("Variables"));
        ((ListAssert)Assertions.assertThat((List)variableList).isNotNull()).hasSize(1);
        Assertions.assertThat((String)((Global)variableList.get(0)).getClassName()).isEqualTo("java.util.List");
        Assertions.assertThat((String)((Global)variableList.get(0)).getIdentifier()).isEqualTo("list");
        List functions = listener.getProperties().getProperty("Functions");
        ((ListAssert)((ListAssert)Assertions.assertThat((List)functions).isNotNull()).hasSize(1)).containsExactly((Object[])new String[]{"A function"});
        List queries = listener.getProperties().getProperty("Queries");
        ((ListAssert)((ListAssert)Assertions.assertThat((List)queries).isNotNull()).hasSize(1)).containsExactly((Object[])new String[]{"A query"});
        List declarations = listener.getProperties().getProperty("Declare");
        ((ListAssert)((ListAssert)Assertions.assertThat((List)declarations).isNotNull()).hasSize(1)).containsExactly((Object[])new String[]{"A declared type"});
        String sequentialFlag = listener.getProperties().getSingleProperty("Sequential");
        ((AbstractStringAssert)Assertions.assertThat((String)sequentialFlag).isNotNull()).isEqualTo("false");
        String escapeQuotesFlag = listener.getProperties().getSingleProperty("EscapeQuotes");
        ((AbstractStringAssert)Assertions.assertThat((String)escapeQuotesFlag).isNotNull()).isEqualTo("false");
    }

    @Test
    public void testProcessSheetForExtremeLowNumbers() {
        InputStream stream = this.getClass().getResourceAsStream("/data/BasicWorkbook_with_low_values.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        System.out.println(drl);
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"myObject.size() < 0"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"myObject.size() < 8.0E-11"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"myObject.size() < 9.0E-7"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"myObject.size() < 3.0E-4"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegativeNumbers() throws Exception {
        KieBase kbase = this.readKnowledgeBase("/data/DT_WithNegativeNumbers.drl.xls");
        KieSession ksession = kbase.newKieSession();
        try {
            IntHolder i1 = new IntHolder(1);
            IntHolder i2 = new IntHolder(-1);
            ksession.insert((Object)i1);
            ksession.insert((Object)i2);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testOOXMLParseCellValue() {
        String drl = this.converter.compile("/data/BZ963584.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
    }

    @Test
    public void testNoConstraintsEmptyCells() {
        String drl = this.converter.compile("/data/NoConstraintsEmptyCells.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        String expected = "package data;\n//generated from Decision Table\nimport org.drools.decisiontable.Person;\n// rule values at C10, header at C5\nrule \"Cheese fans_10\"\n  when\n    Person(age == \"55\")\n  then\nend\n// rule values at C11, header at C5\nrule \"Cheese fans_11\"\n  when\n    Person(name == \"Fred\")\n  then\nend\n// rule values at C12, header at C5\nrule \"Cheese fans_12\"\n  when\n    Person(name == \"Fred\", age == \"55\")\n  then\nend";
        Assertions.assertThat((String)"package data;\n//generated from Decision Table\nimport org.drools.decisiontable.Person;\n// rule values at C10, header at C5\nrule \"Cheese fans_10\"\n  when\n    Person(age == \"55\")\n  then\nend\n// rule values at C11, header at C5\nrule \"Cheese fans_11\"\n  when\n    Person(name == \"Fred\")\n  then\nend\n// rule values at C12, header at C5\nrule \"Cheese fans_12\"\n  when\n    Person(name == \"Fred\", age == \"55\")\n  then\nend").isEqualToIgnoringWhitespace((CharSequence)drl);
    }

    @Test
    public void testNoConstraintsSpacesInCells() {
        String drl = this.converter.compile("/data/NoConstraintsSpacesInCells.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        String expected = "package data;\n//generated from Decision Table\nimport org.drools.decisiontable.Person;\n// rule values at C10, header at C5\nrule \"Cheese fans_10\"\n  when\n    Person(age == \"55\")\n  then\nend\n// rule values at C11, header at C5\nrule \"Cheese fans_11\"\n  when\n    Person(name == \"Fred\")\n  then\nend\n// rule values at C12, header at C5\nrule \"Cheese fans_12\"\n  when\n    Person(name == \"Fred\", age == \"55\")\n  then\nend";
        Assertions.assertThat((String)"package data;\n//generated from Decision Table\nimport org.drools.decisiontable.Person;\n// rule values at C10, header at C5\nrule \"Cheese fans_10\"\n  when\n    Person(age == \"55\")\n  then\nend\n// rule values at C11, header at C5\nrule \"Cheese fans_11\"\n  when\n    Person(name == \"Fred\")\n  then\nend\n// rule values at C12, header at C5\nrule \"Cheese fans_12\"\n  when\n    Person(name == \"Fred\", age == \"55\")\n  then\nend").isEqualToIgnoringWhitespace((CharSequence)drl);
    }

    @Test
    public void testNoConstraintsDelimitedSpacesInCells() {
        String drl = this.converter.compile("/data/NoConstraintsDelimitedSpacesInCells.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        String expected = "package data;\n//generated from Decision Table\nimport org.drools.decisiontable.Person;\n// rule values at C10, header at C5\nrule \"Cheese fans_10\"\n  when\n    Person(name == \"     \", age == \"55\")\n  then\nend\n// rule values at C11, header at C5\nrule \"Cheese fans_11\"\n  when\n    Person(name == \"Fred\", age == \"\")\n  then\nend\n// rule values at C12, header at C5\nrule \"Cheese fans_12\"\n  when\n    Person(name == \"Fred\", age == \"55\")\n  then\nend\n// rule values at C13, header at C5\nrule \"Cheese fans_13\"\n  when\n    Person(name == \"     \", age == \"\")\n  then\nend\n// rule values at C14, header at C5\nrule \"Cheese fans_14\"\n  when\n    Person(name == \"\", age == \"55\")\n  then\nend\n// rule values at C15, header at C5\nrule \"Cheese fans_15\"\n  when\n    Person(name == \"Fred\", age == \"\")\n  then\nend";
        Assertions.assertThat((String)"package data;\n//generated from Decision Table\nimport org.drools.decisiontable.Person;\n// rule values at C10, header at C5\nrule \"Cheese fans_10\"\n  when\n    Person(name == \"     \", age == \"55\")\n  then\nend\n// rule values at C11, header at C5\nrule \"Cheese fans_11\"\n  when\n    Person(name == \"Fred\", age == \"\")\n  then\nend\n// rule values at C12, header at C5\nrule \"Cheese fans_12\"\n  when\n    Person(name == \"Fred\", age == \"55\")\n  then\nend\n// rule values at C13, header at C5\nrule \"Cheese fans_13\"\n  when\n    Person(name == \"     \", age == \"\")\n  then\nend\n// rule values at C14, header at C5\nrule \"Cheese fans_14\"\n  when\n    Person(name == \"\", age == \"55\")\n  then\nend\n// rule values at C15, header at C5\nrule \"Cheese fans_15\"\n  when\n    Person(name == \"Fred\", age == \"\")\n  then\nend").isEqualToIgnoringWhitespace((CharSequence)drl);
    }

    @Test
    public void testForAllConstraintQuoteRemoval() {
        String drl = this.converter.compile("/data/ForAllConstraintQuoteRemoval.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        String expected = "package data;\n//generated from Decision Table\nimport com.brms.dto.fact.*;\ndialect \"mvel\";\n// rule values at C21, header at C16\nrule \"enrichment_21\"\n  when\n    p:Payment(fileFormat == \"TOTO\")\n  then\n    System.out.println(true);\nend\n// rule values at C22, header at C16\nrule \"enrichment_22\"\n  when\n    p:Payment(fileFormat == \"TOTO\")\n  then\n    System.out.println(true);\nend\n// rule values at C23, header at C16\nrule \"enrichment_23\"\n  when\n    p:Payment(fileFormat == \"TOTO\" || fileFormat == \"TITI\" || fileFormat == \"TOR\")\n  then\n    System.out.println(true);\nend\n// rule values at C24, header at C16\nrule \"enrichment_24\"\n  when\n    p:Payment(fileFormat == \"TOTO\" || fileFormat == \"TOR\")\n  then\n    System.out.println(true);\nend\n// rule values at C25, header at C16\nrule \"enrichment_25\"\n  when\n    p:Payment(fileFormat == \"TITI\", isConsistencyCheckEnabled == \"true\")\n  then\n    System.out.println(true);\nend\n// rule values at C26, header at C16\nrule \"enrichment_26\"\n  when\n  then\n    System.out.println(false);\nend\n";
        Assertions.assertThat((String)"package data;\n//generated from Decision Table\nimport com.brms.dto.fact.*;\ndialect \"mvel\";\n// rule values at C21, header at C16\nrule \"enrichment_21\"\n  when\n    p:Payment(fileFormat == \"TOTO\")\n  then\n    System.out.println(true);\nend\n// rule values at C22, header at C16\nrule \"enrichment_22\"\n  when\n    p:Payment(fileFormat == \"TOTO\")\n  then\n    System.out.println(true);\nend\n// rule values at C23, header at C16\nrule \"enrichment_23\"\n  when\n    p:Payment(fileFormat == \"TOTO\" || fileFormat == \"TITI\" || fileFormat == \"TOR\")\n  then\n    System.out.println(true);\nend\n// rule values at C24, header at C16\nrule \"enrichment_24\"\n  when\n    p:Payment(fileFormat == \"TOTO\" || fileFormat == \"TOR\")\n  then\n    System.out.println(true);\nend\n// rule values at C25, header at C16\nrule \"enrichment_25\"\n  when\n    p:Payment(fileFormat == \"TITI\", isConsistencyCheckEnabled == \"true\")\n  then\n    System.out.println(true);\nend\n// rule values at C26, header at C16\nrule \"enrichment_26\"\n  when\n  then\n    System.out.println(false);\nend\n").isEqualToIgnoringWhitespace((CharSequence)drl);
    }

    private KieBase readKnowledgeBase(String resource) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        DecisionTableConfiguration config = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        config.setInputType(DecisionTableInputType.XLS);
        kbuilder.add(ResourceFactory.newClassPathResource((String)resource, this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)config);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Test
    public void testFunctionCellMerged() {
        String drl = this.converter.compile("/data/FunctionCellMerged.drl.xls", InputType.XLS);
        ((AbstractStringAssert)Assertions.assertThat((String)drl).isNotNull()).contains(new CharSequence[]{"function void test(){"});
    }

    @Test
    public void testMoreThan9InputParamSubstitution() throws Exception {
        String EXPECTED_CONDITION = "eval ($objects: Object (id == a ||  == b ||  == c ||  == d ||  == e ||  == f ||  == g ||  == h ||  == i  ||  == j  ) )";
        String EXPECTED_ACTION = "System.out.println(\u201ctest\u201d + a  + b   + c  + d  + e  + f  + g + h  + i + j);";
        String drl = this.converter.compile("/data/DROOLS-836.drl.xls", InputType.XLS);
        ((AbstractStringAssert)Assertions.assertThat((String)drl).isNotNull()).contains(new CharSequence[]{"eval ($objects: Object (id == a ||  == b ||  == c ||  == d ||  == e ||  == f ||  == g ||  == h ||  == i  ||  == j  ) )", "System.out.println(\u201ctest\u201d + a  + b   + c  + d  + e  + f  + g + h  + i + j);"});
    }

    @Test
    public void testDtableUsingExcelFunction() throws Exception {
        String drl = this.converter.compile("/data/RuleNameUsingExcelFunction.drl.xls", InputType.XLS);
        String EXPECTED_RULE_NAME = "rule \"RULE_500\"";
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"rule \"RULE_500\""});
    }

    @Test
    public void checkLhsBuilderFixValue() {
        String drl = this.converter.compile("/data/DROOLS-1279.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).isNotNull();
        String expected = "package data;\n//generated from Decision Table\nimport com.sample.DecisionTableTest.Message;\ndialect \"mvel\"\n// rule values at C12, header at C7\nrule \"HelloWorld_12\"\n  when\n    m:Message(checktest in(\"AAA\"), status == \"Message.HELLO\")\n  then\n    System.out.println(m.getMessage());\n    m.setMessage(\"Goodbye cruel world\");update(m);\n    m.setChecktest(\"BBB\");update(m);\nend\n// rule values at C13, header at C7\nrule \"HelloWorld_13\"\n  when\n    m:Message(checktest in(\"BBB\", \"CCC\"), status == \"Message.GOODBYE\")\n  then\n    System.out.println(m.getMessage());\nend\n";
        Assertions.assertThat((String)"package data;\n//generated from Decision Table\nimport com.sample.DecisionTableTest.Message;\ndialect \"mvel\"\n// rule values at C12, header at C7\nrule \"HelloWorld_12\"\n  when\n    m:Message(checktest in(\"AAA\"), status == \"Message.HELLO\")\n  then\n    System.out.println(m.getMessage());\n    m.setMessage(\"Goodbye cruel world\");update(m);\n    m.setChecktest(\"BBB\");update(m);\nend\n// rule values at C13, header at C7\nrule \"HelloWorld_13\"\n  when\n    m:Message(checktest in(\"BBB\", \"CCC\"), status == \"Message.GOODBYE\")\n  then\n    System.out.println(m.getMessage());\nend\n").isEqualToIgnoringWhitespace((CharSequence)drl);
    }

    @Test
    public void testLhsOrder() {
        String drl = this.converter.compile("/data/LhsOrder.drl.xls", InputType.XLS);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])Stream.of(drl.split("\n")).map(String::trim).toArray()).as("Lhs order is wrong", new Object[0])).containsSequence(new Object[]{"accumulate(Person(name == \"John\", $a : age); $max:max($a))", "$p:Person(name == \"John\", age == $max)"});
    }

    @Test
    public void testNewLineInConstraint() {
        String drl = this.converter.compile("/data/NewLineInConstraint.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"map[\"Key2\"] == var2"});
    }

    @Test
    public void testNoUnit() {
        InputStream stream = this.getClass().getResourceAsStream("/data/CanDrink.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"$p: Person(age < 18)"});
    }

    @Test
    public void testNoLhsParam() {
        InputStream stream = this.getClass().getResourceAsStream("/data/CanDrinkNoParam.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"$p : Person( age < 18 )\n"});
    }

    @Test
    public void testChecksOnLhs() {
        InputStream stream = this.getClass().getResourceAsStream("/data/CanDrinkCheckOnLhs.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"$p : Person(age < 18, name == \"Matteo\")\n"});
    }

    @Test
    public void testRuleUnit() {
        InputStream stream = this.getClass().getResourceAsStream("/data/CanDrinkUnit.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"unit CanDrinkUnit;"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"query Results $r: /results end"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"$p: /persons[age < 18]"});
    }

    @Test
    public void testUseWatchAnnotation() {
        InputStream stream = this.getClass().getResourceAsStream("/data/CanDrinkUsingWatch.drl.xls");
        String drl = this.converter.compile(stream, InputType.XLS);
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"$p: Person(age < 18) @watch(name)"});
    }

    @Test
    public void testZipBomb() {
        System.setProperty("drools.excelParser.minInflateRatio", "0.001");
        try {
            InputStream stream = this.getClass().getResourceAsStream("/data/Sample2.drl.xlsx");
            String drl = this.converter.compile(stream, InputType.XLS);
            Assertions.assertThat((String)drl).contains(new CharSequence[]{"m:Message(status == Message.HELLO)"});
        }
        finally {
            System.clearProperty("drools.excelParser.minInflateRatio");
        }
    }

    @Test
    public void testForAll() {
        String drl = this.converter.compile("/data/Hal1.drl.xls", InputType.XLS);
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"m : Message(number >5 && number <=10)"});
    }

    public static class IntHolder {
        private int value;

        public IntHolder(int i) {
            this.value = i;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "IntHolder [value=" + this.value + "]";
        }
    }
}

