/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.accessor.Accumulator;
import org.drools.base.rule.accessor.CompiledInvoker;
import org.drools.base.rule.accessor.Invoker;
import org.drools.base.rule.accessor.ReturnValueExpression;
import org.drools.base.rule.accessor.Wireable;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.api.runtime.rule.FactHandle;

public class JavaAccumulatorFunctionExecutor
implements Accumulator,
Externalizable,
Wireable {
    private static final long serialVersionUID = 510L;
    private ReturnValueExpression expression;
    private AccumulateFunction function;

    public JavaAccumulatorFunctionExecutor() {
    }

    public JavaAccumulatorFunctionExecutor(AccumulateFunction function) {
        this.function = function;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expression = (ReturnValueExpression)in.readObject();
        this.function = (AccumulateFunction)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (CompiledInvoker.isCompiledInvoker((Invoker)this.expression)) {
            out.writeObject(null);
        } else {
            out.writeObject(this.expression);
        }
        out.writeObject(this.function);
    }

    public Object createContext() {
        return this.function.createContext();
    }

    public Object init(Object workingMemoryContext, Object context, BaseTuple leftTuple, Declaration[] declarations, ValueResolver valueResolver) {
        return this.function.initContext((Serializable)context);
    }

    public Object accumulate(Object workingMemoryContext, Object context, BaseTuple leftTuple, FactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, ValueResolver valueResolver) {
        try {
            Object value = this.expression.evaluate(handle, leftTuple, declarations, innerDeclarations, valueResolver, workingMemoryContext).getValue();
            return this.function.accumulateValue((Serializable)context, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean tryReverse(Object workingMemoryContext, Object context, BaseTuple leftTuple, FactHandle handle, Object value, Declaration[] declarations, Declaration[] innerDeclarations, ValueResolver valueResolver) {
        return this.function.tryReverse((Serializable)context, value);
    }

    public Object getResult(Object workingMemoryContext, Object context, BaseTuple leftTuple, Declaration[] declarations, ValueResolver valueResolver) {
        try {
            return this.function.getResult((Serializable)context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean supportsReverse() {
        return this.function.supportsReverse();
    }

    public ReturnValueExpression getExpression() {
        return this.expression;
    }

    public void wire(Object object) {
        this.setExpression((ReturnValueExpression)object);
    }

    public void setExpression(ReturnValueExpression expression) {
        this.expression = expression;
    }

    public Object createWorkingMemoryContext() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaAccumulatorFunctionExecutor that = (JavaAccumulatorFunctionExecutor)o;
        return this.expression.equals(that.expression) && this.function.equals(that.function);
    }

    public int hashCode() {
        int result = this.expression.hashCode();
        result = 31 * result + this.function.hashCode();
        return result;
    }
}

