/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.io;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceType
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceType.class);
    private static final long serialVersionUID = 1613735834228581906L;
    private final String name;
    private final String description;
    private final String defaultExtension;
    private final String[] otherExtensions;
    private final String defaultPath;
    private final boolean fullyCoveredByExecModel;
    private static final Map<String, ResourceType> CACHE = Collections.synchronizedMap(new HashMap());
    public static final ResourceType DRL = ResourceType.addResourceTypeToRegistry("DRL", "Drools Rule Language", "src/main/resources", "drl", new String[0]);
    public static final ResourceType DRLX = ResourceType.addResourceTypeToRegistry("DRLX", "Drools Extended Rule Language (experimental)", "src/main/resources", "drlx", new String[0]);
    public static final ResourceType GDRL = ResourceType.addResourceTypeToRegistry("GDRL", "Drools Rule Language", "src/main/resources", "gdrl", new String[0]);
    public static final ResourceType RDRL = ResourceType.addResourceTypeToRegistry("RDRL", "Drools Rule Language", "src/main/resources", "rdrl", new String[0]);
    public static final ResourceType DSL = ResourceType.addResourceTypeToRegistry("DSL", "Drools DSL", "src/main/resources", "dsl", new String[0]);
    public static final ResourceType DSLR = ResourceType.addResourceTypeToRegistry("DSLR", "Drools DSL Rule", "src/main/resources", "dslr", new String[0]);
    public static final ResourceType RDSLR = ResourceType.addResourceTypeToRegistry("RDSLR", "Drools DSL Rule", "src/main/resources", "rdslr", new String[0]);
    public static final ResourceType DRF = ResourceType.addResourceTypeToRegistry("DRF", "Drools Rule Flow Language", "src/main/resources", "rf", new String[0]);
    public static final ResourceType BPMN2 = ResourceType.addResourceTypeToRegistry("BPMN2", "jBPM BPMN2 Language", "src/main/resources", "bpmn", "bpmn2", "bpmn-cm");
    public static final ResourceType CMMN = ResourceType.addResourceTypeToRegistry("CMMN", "jBPM CMMN Language", "src/main/resources", "cmmn", new String[0]);
    public static final ResourceType DTABLE = ResourceType.addResourceTypeToRegistry("DTABLE", "Decision Table", "src/main/resources", "drl.xls", "drl.xlsx", "drl.csv");
    public static final ResourceType XSD = ResourceType.addResourceTypeToRegistry("XSD", "XSD", "src/main/resources", "xsd", new String[0]);
    public static final ResourceType PMML = ResourceType.addResourceTypeToRegistry("PMML", false, "Predictive Model Markup Language", "src/main/resources", "pmml", new String[0]);
    public static final ResourceType DESCR = ResourceType.addResourceTypeToRegistry("DESCR", "Knowledge Descriptor", "src/main/resources", "descr", new String[0]);
    public static final ResourceType JAVA = ResourceType.addResourceTypeToRegistry("JAVA", "Java class", "src/main/java", "java", new String[0]);
    public static final ResourceType PROPERTIES = ResourceType.addResourceTypeToRegistry("PROPERTIES", "Properties file", "src/main/resources", "properties", new String[0]);
    public static final ResourceType SCARD = ResourceType.addResourceTypeToRegistry("SCARD", "Score Crd", "src/main/resources", "sxls", new String[0]);
    public static final ResourceType BAYES = ResourceType.addResourceTypeToRegistry("Bayes", "Bayesian Belief Network", "src/main/resources", "xmlbif", "bif");
    public static final ResourceType TDRL = ResourceType.addResourceTypeToRegistry("TDRL", "Drools Rule Language", "src/main/resources", "tdrl", new String[0]);
    public static final ResourceType TEMPLATE = ResourceType.addResourceTypeToRegistry("TEMPLATE", "Drools Rule Template", "src/main/resources", "drl.template", new String[0]);
    @Deprecated
    public static final ResourceType DRT = ResourceType.addResourceTypeToRegistry("DRT", "Drools Rule Template", "src/main/resources", "drt", new String[0]);
    public static final ResourceType GDST = ResourceType.addResourceTypeToRegistry("GDST", "Guided Decision Table", "src/main/resources", "gdst", new String[0]);
    public static final ResourceType SCGD = ResourceType.addResourceTypeToRegistry("SCGD", "Guided Score Card", "src/main/resources", "scgd", new String[0]);
    public static final ResourceType SOLVER = ResourceType.addResourceTypeToRegistry("SOLVER", "OptaPlanner Solver Configuration", "src/main/resources", "solver", new String[0]);
    public static final ResourceType DMN = ResourceType.addResourceTypeToRegistry("DMN", false, "Decision Model and Notation", "src/main/resources", "dmn", new String[0]);
    public static final ResourceType FEEL = ResourceType.addResourceTypeToRegistry("FEEL", false, "Friendly Enough Expression Language", "src/main/resources", "feel", new String[0]);
    public static final ResourceType NOOP = ResourceType.addResourceTypeToRegistry("NOOP", false, "No-operation type", "src/main/resources", "no_op", new String[0]);
    public static final ResourceType YAML = ResourceType.addResourceTypeToRegistry("YAML", "YAML format DRL", "src/main/resources", "drl.yaml", "drl.yml");

    public ResourceType(String name, boolean fullyCoveredByExecModel, String description, String defaultPath, String defaultExtension, String ... otherExtensions) {
        this.name = name;
        this.fullyCoveredByExecModel = fullyCoveredByExecModel;
        this.description = description;
        this.defaultPath = defaultPath;
        this.defaultExtension = defaultExtension;
        this.otherExtensions = otherExtensions;
    }

    public static ResourceType addResourceTypeToRegistry(String resourceType, String description, String defaultPath, String defaultExtension, String ... otherExtensions) {
        return ResourceType.addResourceTypeToRegistry(resourceType, true, description, defaultPath, defaultExtension, otherExtensions);
    }

    public static ResourceType addResourceTypeToRegistry(String resourceType, boolean isNative, String description, String defaultPath, String defaultExtension, String ... otherExtensions) {
        ResourceType resource = new ResourceType(resourceType, isNative, description, defaultPath, defaultExtension, otherExtensions);
        CACHE.put(resourceType, resource);
        for (String ext : resource.getAllExtensions()) {
            CACHE.put("." + ext, resource);
        }
        return resource;
    }

    public static ResourceType determineResourceType(String resourceName) {
        for (Map.Entry<String, ResourceType> entry : CACHE.entrySet()) {
            if (!resourceName.endsWith(entry.getKey())) continue;
            if (entry.getValue().equals(DRT)) {
                LOG.warn("DRT (Drools Rule Template) is deprecated. Please consider drools-decisiontables or third party templating features.");
            }
            return entry.getValue();
        }
        return null;
    }

    public boolean matchesExtension(String resourceName) {
        if (resourceName != null) {
            if (resourceName.endsWith("." + this.defaultExtension)) {
                return true;
            }
            for (String extension : this.otherExtensions) {
                if (!resourceName.endsWith("." + extension)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFullyCoveredByExecModel() {
        return this.fullyCoveredByExecModel;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public List<String> getAllExtensions() {
        LinkedList<String> extensions = new LinkedList<String>();
        extensions.add(this.defaultExtension);
        extensions.addAll(Arrays.asList(this.otherExtensions));
        return Collections.unmodifiableList(extensions);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ResourceType = '" + this.description + "'";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceType other = (ResourceType)obj;
        return this.name.equals(other.name);
    }
}

