/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import org.drools.base.beliefsystem.Mode;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.ClassAwareObjectStore;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.util.LinkedList;
import org.drools.tms.BeliefSystemFactory;
import org.drools.tms.LogicalDependency;
import org.drools.tms.SimpleMode;
import org.drools.tms.TruthMaintenanceSystemEqualityKey;
import org.drools.tms.agenda.TruthMaintenanceSystemInternalMatch;
import org.drools.tms.beliefsystem.BeliefSet;
import org.drools.tms.beliefsystem.BeliefSystem;
import org.drools.tms.beliefsystem.BeliefSystemMode;
import org.drools.tms.beliefsystem.ModedAssertion;
import org.drools.tms.beliefsystem.jtms.JTMSBeliefSetImpl;
import org.drools.tms.util.CustomKeyTransformerHashMap;
import org.kie.api.runtime.rule.FactHandle;

public class TruthMaintenanceSystemImpl
implements TruthMaintenanceSystem {
    private final InternalWorkingMemoryEntryPoint ep;
    private final ObjectTypeConfigurationRegistry typeConfReg;
    private final Map<EqualityKey, EqualityKey> equalityKeyMap;
    private final BeliefSystem defaultBeliefSystem;
    private final RuleBaseConfiguration.AssertBehaviour assertBehaviour;

    public TruthMaintenanceSystemImpl(InternalWorkingMemoryEntryPoint ep) {
        this.ep = ep;
        this.assertBehaviour = ep.getKnowledgeBase().getRuleBaseConfiguration().getAssertBehaviour();
        this.typeConfReg = ep.getObjectTypeConfigurationRegistry();
        this.equalityKeyMap = new CustomKeyTransformerHashMap<EqualityKey, EqualityKey>(EqualityKeyPlaceholder::transformEqualityKey);
        this.defaultBeliefSystem = BeliefSystemFactory.createBeliefSystem(ep.getReteEvaluator().getRuleSessionConfiguration().getBeliefSystemType(), ep, this);
    }

    public int getEqualityKeysSize() {
        return this.equalityKeyMap.size();
    }

    public Collection<EqualityKey> getEqualityKeys() {
        return this.equalityKeyMap.values();
    }

    public void put(EqualityKey key) {
        this.equalityKeyMap.put(key, key);
    }

    public InternalFactHandle insertPositive(Object object, InternalMatch internalMatch) {
        return this.insert(object, JTMSBeliefSetImpl.MODE.POSITIVE.getId(), internalMatch);
    }

    public InternalFactHandle insert(Object object, Object tmsValue, InternalMatch internalMatch) {
        InternalFactHandle fh;
        EqualityKey key;
        ObjectTypeConf typeConf = this.typeConfReg.getOrCreateObjectTypeConf(this.ep.getEntryPoint(), object);
        if (!typeConf.isTMSEnabled()) {
            this.enableTMS(object, typeConf);
        }
        if ((key = this.get(object)) == null) {
            fh = this.ep.getHandleFactory().newFactHandle(object, typeConf, this.ep.getReteEvaluator(), (WorkingMemoryEntryPoint)this.ep);
            key = new TruthMaintenanceSystemEqualityKey(fh, 2);
            fh.setEqualityKey(key);
            this.put(key);
        } else {
            fh = key.getLogicalFactHandle();
            if (fh == null) {
                fh = this.ep.getHandleFactory().newFactHandle(object, typeConf, this.ep.getReteEvaluator(), (WorkingMemoryEntryPoint)this.ep);
                key.setLogicalFactHandle(fh);
                fh.setEqualityKey(key);
            }
        }
        return this.addLogicalDependency(fh, object, tmsValue, (TruthMaintenanceSystemInternalMatch)internalMatch, typeConf, false);
    }

    public void delete(FactHandle fh) {
        if (fh == null) {
            return;
        }
        InternalFactHandle ifh = (InternalFactHandle)fh;
        EqualityKey key = ifh.getEqualityKey();
        if (key.getLogicalFactHandle() != fh) {
            throw new IllegalArgumentException("The FactHandle did not originate from TMS : " + fh);
        }
        PropagationContext propagationContext = this.ep.getPctxFactory().createPropagationContext(this.ep.getReteEvaluator().getNextPropagationIdCounter(), PropagationContext.Type.DELETION, null, null, ifh, this.ep.getEntryPoint());
        BeliefSet beliefSet = ((TruthMaintenanceSystemEqualityKey)key).getBeliefSet();
        if (beliefSet != null && !beliefSet.isEmpty()) {
            beliefSet.cancel(propagationContext);
        }
    }

    public EqualityKey get(Object object) {
        InternalFactHandle fh;
        EqualityKey key = this.equalityKeyMap.get(object);
        if (key == null && this.assertBehaviour == RuleBaseConfiguration.AssertBehaviour.EQUALITY && (fh = this.ep.getObjectStore().getHandleForObject(object)) != null && (key = fh.getEqualityKey()) == null) {
            ObjectTypeConf typeC = this.typeConfReg.getOrCreateObjectTypeConf(this.ep.getEntryPoint(), fh.getObject());
            this.enableTMS(fh.getObject(), typeC);
            key = fh.getEqualityKey();
        }
        return key;
    }

    public void remove(EqualityKey key) {
        this.equalityKeyMap.remove(key);
    }

    public void readLogicalDependency(InternalFactHandle handle, Object object, Object value, InternalMatch internalMatch, ObjectTypeConf typeConf) {
        this.addLogicalDependency(handle, object, value, (TruthMaintenanceSystemInternalMatch)internalMatch, typeConf, true);
    }

    private InternalFactHandle addLogicalDependency(InternalFactHandle handle, Object object, Object tmsValue, TruthMaintenanceSystemInternalMatch activation, ObjectTypeConf typeConf, boolean read) {
        BeliefSet beliefSet;
        BeliefSystem beliefSystem = this.defaultBeliefSystem;
        if (tmsValue instanceof Mode & !(tmsValue instanceof SimpleMode)) {
            BeliefSystemMode mode = (BeliefSystemMode)tmsValue;
            beliefSystem = mode.getBeliefSystem();
        }
        if ((beliefSet = ((TruthMaintenanceSystemEqualityKey)handle.getEqualityKey()).getBeliefSet()) == null) {
            beliefSet = beliefSystem.newBeliefSet(handle);
            ((TruthMaintenanceSystemEqualityKey)handle.getEqualityKey()).setBeliefSet(beliefSet);
        }
        LogicalDependency node = beliefSystem.newLogicalDependency(activation, beliefSet, object, tmsValue);
        activation.getRule().setHasLogicalDependency(true);
        activation.addLogicalDependency(node);
        if (read) {
            beliefSystem.read(node, beliefSet, activation.getPropagationContext(), typeConf);
        } else {
            beliefSet = beliefSystem.insert(node, beliefSet, activation.getPropagationContext(), typeConf);
        }
        return beliefSet.getFactHandle();
    }

    public void clear() {
        this.equalityKeyMap.clear();
    }

    public BeliefSystem getBeliefSystem() {
        return this.defaultBeliefSystem;
    }

    private void enableTMS(Object object, ObjectTypeConf conf) {
        Iterator it = this.ep.getObjectStore().iterateFactHandles(ClassAwareObjectStore.getActualClass((Object)object));
        while (it.hasNext()) {
            InternalFactHandle handle = (InternalFactHandle)it.next();
            if (handle == null || handle.getEqualityKey() != null) continue;
            TruthMaintenanceSystemEqualityKey key = new TruthMaintenanceSystemEqualityKey(handle);
            handle.setEqualityKey((EqualityKey)key);
            key.setStatus(1);
            this.put(key);
        }
        conf.enableTMS();
    }

    public InternalFactHandle insertOnTms(Object object, ObjectTypeConf typeConf, PropagationContext propagationContext, InternalFactHandle handle, BiFunction<Object, ObjectTypeConf, InternalFactHandle> fhFactory) {
        EqualityKey key = this.get(object);
        if (handle != null && key != null && key.getStatus() == 2) {
            BeliefSet bs = ((TruthMaintenanceSystemEqualityKey)handle.getEqualityKey()).getBeliefSet();
            bs.getBeliefSystem().stage(propagationContext, bs);
        }
        handle = fhFactory.apply(object, typeConf);
        if (key == null) {
            key = new TruthMaintenanceSystemEqualityKey(handle, 1);
            this.put(key);
        } else {
            key.addFactHandle(handle);
        }
        handle.setEqualityKey(key);
        return handle;
    }

    public void updateOnTms(InternalFactHandle handle, Object object, InternalMatch internalMatch) {
        EqualityKey newKey = this.get(object);
        EqualityKey oldKey = handle.getEqualityKey();
        if ((oldKey.getStatus() == 2 || ((TruthMaintenanceSystemEqualityKey)oldKey).getBeliefSet() != null) && newKey != oldKey) {
            throw new IllegalStateException("Currently we cannot modify something that has mixed stated and justified equal objects. Rule " + (internalMatch == null ? "" : internalMatch.getRule().getName()) + " attempted an illegal operation");
        }
        if (newKey == null) {
            oldKey.removeFactHandle(handle);
            newKey = new TruthMaintenanceSystemEqualityKey(handle, 1);
            handle.setEqualityKey(newKey);
            this.put(newKey);
        } else if (newKey != oldKey) {
            oldKey.removeFactHandle(handle);
            handle.setEqualityKey(newKey);
            newKey.addFactHandle(handle);
        }
        if (oldKey.isEmpty() && oldKey.getLogicalFactHandle() == null) {
            this.remove(oldKey);
        }
    }

    public void deleteFromTms(InternalFactHandle handle, EqualityKey key, PropagationContext propagationContext) {
        key.removeFactHandle(handle);
        handle.setEqualityKey(null);
        if (key.isEmpty() && key.getLogicalFactHandle() == null) {
            this.remove(key);
        } else if (key.getLogicalFactHandle() != null) {
            InternalFactHandle justifiedHandle = key.getLogicalFactHandle();
            BeliefSet bs = ((TruthMaintenanceSystemEqualityKey)justifiedHandle.getEqualityKey()).getBeliefSet();
            bs.getBeliefSystem().unstage(propagationContext, bs);
        }
    }

    public static <M extends ModedAssertion<M>> void removeLogicalDependencies(TruthMaintenanceSystemInternalMatch<M> activation) {
        LinkedList<LogicalDependency<M>> list = activation.getLogicalDependencies();
        if (list == null || list.isEmpty()) {
            return;
        }
        PropagationContext context = ((Tuple)activation).findMostRecentPropagationContext();
        for (LogicalDependency node = (LogicalDependency)list.getFirst(); node != null; node = (LogicalDependency)node.getNext()) {
            TruthMaintenanceSystemImpl.removeLogicalDependency(node, context);
        }
        activation.setLogicalDependencies(null);
    }

    public static <M extends ModedAssertion<M>> void removeLogicalDependency(LogicalDependency<M> node, PropagationContext context) {
        BeliefSet beliefSet = (BeliefSet)node.getJustified();
        beliefSet.getBeliefSystem().delete(node, beliefSet, context);
    }

    private static class EqualityKeyPlaceholder {
        private final Object object;

        private EqualityKeyPlaceholder(Object object) {
            this.object = object;
        }

        private static Object transformEqualityKey(Object o) {
            return o instanceof EqualityKey ? o : new EqualityKeyPlaceholder(o);
        }

        public int hashCode() {
            return this.object.hashCode();
        }

        public boolean equals(Object other) {
            return this == other || other.equals(this.object);
        }
    }
}

