/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModuleProvider;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.io.InternalResource;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.KieScannerFactoryService;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.ReleaseIdComparator;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.event.kiescanner.KieScannerEventListener;
import org.kie.api.internal.utils.KieService;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.util.maven.support.PomModel;
import org.kie.util.maven.support.ReleaseIdImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieRepositoryImpl
implements KieRepository {
    private static final Logger log = LoggerFactory.getLogger(KieRepositoryImpl.class);
    private static final String DEFAULT_VERSION = "1.0.0";
    private static final String DEFAULT_ARTIFACT = "artifact";
    private static final String DEFAULT_GROUP = "org.default";
    private final AtomicReference<ReleaseId> defaultGAV = new AtomicReference<ReleaseIdImpl>(new ReleaseIdImpl("org.default", "artifact", "1.0.0"));
    public static final KieRepository INSTANCE = new KieRepositoryImpl();
    private final KieModuleRepo kieModuleRepo;
    private final ReentrantLock lock = new ReentrantLock();
    private static final Object PRESENT = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInternalKieScanner(InternalKieScanner scanner) {
        Class<KieScannerHolder> clazz = KieScannerHolder.class;
        synchronized (KieScannerHolder.class) {
            KieScannerHolder.kieScanner = scanner;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public KieRepositoryImpl() {
        this.kieModuleRepo = new KieModuleRepo(this.lock);
    }

    public void setDefaultGAV(ReleaseId releaseId) {
        this.defaultGAV.set(releaseId);
    }

    public ReleaseId getDefaultReleaseId() {
        return this.defaultGAV.get();
    }

    public void addKieModule(KieModule kieModule) {
        this.kieModuleRepo.store(kieModule);
        log.debug("KieModule was added: " + kieModule);
    }

    public KieModule getKieModule(ReleaseId releaseId) {
        return this.getKieModule(releaseId, null);
    }

    public KieModule removeKieModule(ReleaseId releaseId) {
        return this.kieModuleRepo.remove(releaseId);
    }

    KieModule getOldKieModule(ReleaseId releaseId) {
        KieModule kieModule = this.kieModuleRepo.loadOldAndRemove(releaseId);
        return kieModule != null ? kieModule : this.getKieModule(releaseId);
    }

    public KieModule getKieModule(ReleaseId releaseId, PomModel pomModel) {
        KieModule kieModule = this.kieModuleRepo.load(KieScannerHolder.kieScanner, releaseId);
        if (kieModule == null) {
            log.debug("KieModule Lookup. ReleaseId {} was not in cache, checking classpath", (Object)releaseId.toExternalForm());
            kieModule = this.checkClasspathForKieModule(releaseId);
        }
        if (kieModule == null) {
            log.debug("KieModule Lookup. ReleaseId {} was not in cache, checking maven repository", (Object)releaseId.toExternalForm());
            kieModule = this.loadKieModuleFromMavenRepo(releaseId, pomModel);
        }
        return kieModule;
    }

    private KieModule checkClasspathForKieModule(ReleaseId releaseId) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URL kmoduleUrl = contextClassLoader.getResource(KieModuleModelImpl.KMODULE_JAR_PATH.asString());
        if (kmoduleUrl == null) {
            return null;
        }
        String pomPropertiesPath = ReleaseIdImpl.getPomPropertiesPath((ReleaseId)releaseId);
        URL pomPropertiesUrl = contextClassLoader.getResource(pomPropertiesPath);
        if (pomPropertiesUrl == null) {
            return null;
        }
        ReleaseId pomReleaseId = ReleaseIdImpl.fromPropertiesStream((InputStream)contextClassLoader.getResourceAsStream(pomPropertiesPath), (String)pomPropertiesUrl.getPath());
        if (pomReleaseId.equals(releaseId)) {
            URL pathToKmodule;
            String path = pomPropertiesUrl.getPath();
            String pathToJar = path.substring(0, path.indexOf(".jar!") + 4);
            try {
                pathToKmodule = new URL(pomPropertiesUrl.getProtocol(), pomPropertiesUrl.getHost(), pomPropertiesUrl.getPort(), pathToJar + "!/" + KieModuleModelImpl.KMODULE_JAR_PATH.asString());
                if (pathToKmodule.openConnection().getContentLength() <= 0) {
                    return null;
                }
            }
            catch (MalformedURLException e) {
                log.error("Unable to reconstruct path to kmodule for " + releaseId);
                return null;
            }
            catch (IOException e) {
                log.error("Unable to read from path to kmodule for " + releaseId);
                return null;
            }
            log.info("Adding KieModule from classpath: " + pathToJar);
            return ClasspathKieProject.fetchKModule(pathToKmodule);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KieModule loadKieModuleFromMavenRepo(ReleaseId releaseId, PomModel pomModel) {
        try {
            this.lock.lock();
            KieModule kieModule = KieScannerHolder.kieScanner.loadArtifact(releaseId, pomModel);
            return kieModule;
        }
        finally {
            this.lock.unlock();
        }
    }

    public KieModule addKieModule(Resource resource, Resource ... dependencies) {
        log.info("Adding KieModule from resource: " + resource);
        KieModule kModule = this.getKieModule(resource);
        if (dependencies != null && dependencies.length > 0) {
            for (Resource depRes : dependencies) {
                InternalKieModule depKModule = (InternalKieModule)this.getKieModule(depRes);
                ((InternalKieModule)kModule).addKieDependency(depKModule);
                log.debug("Adding KieModule dependency from resource: " + resource);
            }
        }
        this.addKieModule(kModule);
        return kModule;
    }

    public KieModule getKieModule(Resource resource) {
        InternalResource res = (InternalResource)resource;
        try {
            InternalKieModule kModule;
            if (res.hasURL()) {
                Object urlPath = res.getURL().toExternalForm();
                if (res.isDirectory()) {
                    if (!((String)urlPath).endsWith("/")) {
                        urlPath = (String)urlPath + "/";
                    }
                    urlPath = (String)urlPath + KieModuleModelImpl.KMODULE_JAR_PATH.asString();
                } else {
                    urlPath = "jar:" + (String)urlPath + "!/" + KieModuleModelImpl.KMODULE_JAR_PATH.asString();
                }
                kModule = ClasspathKieProject.fetchKModule(new URL((String)urlPath));
                log.debug("Fetched KieModule from resource: " + resource);
            } else {
                MemoryFileSystem mfs = MemoryFileSystem.readFromJar(res.getInputStream());
                byte[] bytes = mfs.getBytes(KieModuleModelImpl.KMODULE_JAR_PATH);
                KieModuleModel kieProject = KieModuleModelImpl.fromXML(new ByteArrayInputStream(bytes));
                KieBuilderImpl.setDefaultsforEmptyKieModule(kieProject);
                String pomProperties = mfs.findPomProperties();
                ReleaseIdImpl releaseId = ReleaseIdImpl.fromPropertiesString((String)pomProperties);
                kModule = InternalKieModuleProvider.get((ReleaseId)releaseId, kieProject, mfs);
            }
            return kModule;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to fetch module from resource: " + res, e);
        }
    }

    private static class KieScannerHolder {
        private static volatile InternalKieScanner kieScanner = KieScannerHolder.getInternalKieScanner();

        private KieScannerHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static InternalKieScanner getInternalKieScanner() {
            Class<KieScannerHolder> clazz = KieScannerHolder.class;
            synchronized (KieScannerHolder.class) {
                if (kieScanner != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return kieScanner;
                }
                try {
                    KieScannerFactoryService scannerFactoryService = (KieScannerFactoryService)KieService.load(KieScannerFactoryService.class);
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return (InternalKieScanner)scannerFactoryService.newKieScanner();
                }
                catch (Exception e) {
                    log.debug("Cannot load a KieRepositoryScanner, using the DummyKieScanner");
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return new DummyKieScanner();
                }
            }
        }
    }

    public static class KieModuleRepo {
        public static final String CACHE_GA_MAX_PROPERTY = "kie.repository.project.cache.size";
        public static int MAX_SIZE_GA_CACHE = Integer.parseInt(System.getProperty("kie.repository.project.cache.size", "100"));
        public static final String CACHE_VERSIONS_MAX_PROPERTY = "kie.repository.project.versions.cache.size";
        public static int MAX_SIZE_GA_VERSIONS_CACHE = Integer.parseInt(System.getProperty("kie.repository.project.versions.cache.size", "10"));
        private final ReentrantLock lock;
        public final Map<String, NavigableMap<ReleaseIdComparator.ComparableVersion, KieModule>> kieModules = new LinkedHashMap<String, NavigableMap<ReleaseIdComparator.ComparableVersion, KieModule>>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, NavigableMap<ReleaseIdComparator.ComparableVersion, KieModule>> eldest) {
                return this.size() > MAX_SIZE_GA_CACHE;
            }
        };
        public final LinkedHashMap<ReleaseId, KieModule> oldKieModules = new LinkedHashMap<ReleaseId, KieModule>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<ReleaseId, KieModule> eldest) {
                return this.size() > MAX_SIZE_GA_CACHE * MAX_SIZE_GA_VERSIONS_CACHE;
            }
        };

        public KieModuleRepo(ReentrantLock lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KieModule remove(ReleaseId releaseId) {
            try {
                this.lock.lock();
                KieModule removedKieModule = null;
                String ga = releaseId.getGroupId() + ":" + releaseId.getArtifactId();
                ReleaseIdComparator.ComparableVersion comparableVersion = new ReleaseIdComparator.ComparableVersion(releaseId.getVersion());
                NavigableMap<ReleaseIdComparator.ComparableVersion, KieModule> artifactMap = this.kieModules.get(ga);
                if (artifactMap != null) {
                    removedKieModule = (KieModule)artifactMap.remove(comparableVersion);
                    if (artifactMap.isEmpty()) {
                        this.kieModules.remove(ga);
                    }
                    this.oldKieModules.remove(releaseId);
                }
                KieModule kieModule = removedKieModule;
                return kieModule;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void store(KieModule kieModule) {
            try {
                KieModule oldKieModule;
                KieModule oldReleaseIdKieModule;
                this.lock.lock();
                ReleaseId releaseId = kieModule.getReleaseId();
                String ga = releaseId.getGroupId() + ":" + releaseId.getArtifactId();
                ReleaseIdComparator.ComparableVersion comparableVersion = new ReleaseIdComparator.ComparableVersion(releaseId.getVersion());
                NavigableMap<ReleaseIdComparator.ComparableVersion, KieModule> artifactMap = this.kieModules.get(ga);
                if (artifactMap == null) {
                    artifactMap = this.createNewArtifactMap();
                    this.kieModules.put(ga, artifactMap);
                }
                if ((oldReleaseIdKieModule = this.oldKieModules.get(releaseId)) == null && (oldKieModule = (KieModule)artifactMap.get(comparableVersion)) != null) {
                    this.oldKieModules.put(releaseId, oldKieModule);
                }
                artifactMap.put(comparableVersion, kieModule);
            }
            finally {
                this.lock.unlock();
            }
        }

        private NavigableMap<ReleaseIdComparator.ComparableVersion, KieModule> createNewArtifactMap() {
            TreeMap<ReleaseIdComparator.ComparableVersion, KieModule> newArtifactMap = new TreeMap<ReleaseIdComparator.ComparableVersion, KieModule>(){
                private final Map<ReleaseIdComparator.ComparableVersion, KieModule> artifactMap = this;
                LinkedHashMap<ReleaseIdComparator.ComparableVersion, Object> backingLRUMap = new LinkedHashMap<ReleaseIdComparator.ComparableVersion, Object>(16, 0.75f, true){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<ReleaseIdComparator.ComparableVersion, Object> eldest) {
                        boolean remove;
                        boolean bl = remove = this.size() > MAX_SIZE_GA_VERSIONS_CACHE;
                        if (remove) {
                            artifactMap.remove(eldest.getKey());
                        }
                        return remove;
                    }
                };

                @Override
                public KieModule put(ReleaseIdComparator.ComparableVersion key, KieModule value) {
                    this.backingLRUMap.put(key, PRESENT);
                    return super.put(key, value);
                }
            };
            return newArtifactMap;
        }

        KieModule loadOldAndRemove(ReleaseId releaseId) {
            try {
                this.lock.lock();
                KieModule kieModule = (KieModule)this.oldKieModules.remove(releaseId);
                return kieModule;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        KieModule load(InternalKieScanner kieScanner, ReleaseId releaseId) {
            try {
                this.lock.lock();
                KieModule kieModule = this.load(kieScanner, releaseId, new VersionRange(releaseId.getVersion()));
                return kieModule;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        KieModule load(InternalKieScanner kieScanner, ReleaseId releaseId, VersionRange versionRange) {
            try {
                Map.Entry<ReleaseIdComparator.ComparableVersion, KieModule> entry;
                this.lock.lock();
                String ga = releaseId.getGroupId() + ":" + releaseId.getArtifactId();
                NavigableMap<ReleaseIdComparator.ComparableVersion, KieModule> artifactMap = this.kieModules.get(ga);
                if (artifactMap == null || artifactMap.isEmpty()) {
                    KieModule kieModule = null;
                    return kieModule;
                }
                KieModule kieModule = (KieModule)artifactMap.get(new ReleaseIdComparator.ComparableVersion(releaseId.getVersion()));
                if (versionRange.fixed) {
                    String currentSnapshotVersion;
                    Object oldSnapshotVersion;
                    if (kieModule != null && releaseId.isSnapshot() && (oldSnapshotVersion = ((ReleaseIdImpl)kieModule.getReleaseId()).getSnapshotVersion()) != null && (currentSnapshotVersion = kieScanner.getArtifactVersion(releaseId)) != null && new ReleaseIdComparator.ComparableVersion(currentSnapshotVersion).compareTo(new ReleaseIdComparator.ComparableVersion((String)oldSnapshotVersion)) > 0) {
                        KieModule kieModule2 = null;
                        return kieModule2;
                    }
                    oldSnapshotVersion = kieModule;
                    return oldSnapshotVersion;
                }
                Map.Entry<ReleaseIdComparator.ComparableVersion, KieModule> entry2 = versionRange.upperBound == null ? artifactMap.lastEntry() : (entry = versionRange.upperInclusive ? artifactMap.floorEntry(new ReleaseIdComparator.ComparableVersion(versionRange.upperBound)) : artifactMap.lowerEntry(new ReleaseIdComparator.ComparableVersion(versionRange.upperBound)));
                if (entry == null) {
                    KieModule currentSnapshotVersion = null;
                    return currentSnapshotVersion;
                }
                if (versionRange.lowerBound == null) {
                    KieModule currentSnapshotVersion = entry.getValue();
                    return currentSnapshotVersion;
                }
                int comparison = entry.getKey().compareTo(new ReleaseIdComparator.ComparableVersion(versionRange.lowerBound));
                KieModule kieModule3 = comparison > 0 || comparison == 0 && versionRange.lowerInclusive ? entry.getValue() : null;
                return kieModule3;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class VersionRange {
        private String lowerBound;
        private String upperBound;
        private boolean lowerInclusive;
        private boolean upperInclusive;
        private boolean fixed;

        private VersionRange(String version) {
            this.parse(version);
        }

        private void parse(String version) {
            if ("LATEST".equals(version) || "RELEASE".equals(version)) {
                this.fixed = false;
                this.lowerBound = "1.0";
                this.upperBound = null;
                this.lowerInclusive = true;
                this.upperInclusive = false;
                return;
            }
            if (version.charAt(0) != '(' && version.charAt(0) != '[') {
                this.fixed = true;
                this.lowerBound = version;
                this.upperBound = version;
                this.lowerInclusive = true;
                this.upperInclusive = true;
                return;
            }
            this.lowerInclusive = version.charAt(0) == '[';
            this.upperInclusive = version.charAt(version.length() - 1) == ']';
            int commaPos = version.indexOf(44);
            if (commaPos < 0) {
                this.fixed = true;
                this.upperBound = this.lowerBound = version.substring(1, version.length() - 1);
            } else {
                if (commaPos > 1) {
                    this.lowerBound = version.substring(1, commaPos);
                }
                if (commaPos < version.length() - 2) {
                    this.upperBound = version.substring(commaPos + 1, version.length() - 1);
                }
            }
        }
    }

    private static class DummyKieScanner
    implements InternalKieScanner {
        private DummyKieScanner() {
        }

        public void start(long pollingInterval) {
        }

        public void stop() {
        }

        public void shutdown() {
        }

        public void scanNow() {
        }

        @Override
        public void setKieContainer(KieContainer kieContainer) {
        }

        @Override
        public KieModule loadArtifact(ReleaseId releaseId) {
            this.logArtifactNotFetched(releaseId);
            return null;
        }

        @Override
        public KieModule loadArtifact(ReleaseId releaseId, InputStream pomXML) {
            this.logArtifactNotFetched(releaseId);
            return null;
        }

        @Override
        public KieModule loadArtifact(ReleaseId releaseId, PomModel pomModel) {
            this.logArtifactNotFetched(releaseId);
            return null;
        }

        @Override
        public String getArtifactVersion(ReleaseId releaseId) {
            this.logArtifactNotFetched(releaseId);
            return null;
        }

        private void logArtifactNotFetched(ReleaseId releaseId) {
            log.info("Artifact not fetched from maven: " + releaseId + ". To enable the KieScanner you need kie-ci on the classpath");
        }

        @Override
        public ReleaseId getScannerReleaseId() {
            return null;
        }

        @Override
        public ReleaseId getCurrentReleaseId() {
            return null;
        }

        @Override
        public KieScanner.Status getStatus() {
            return KieScanner.Status.STOPPED;
        }

        @Override
        public long getPollingInterval() {
            return 0L;
        }

        public void addListener(KieScannerEventListener listener) {
        }

        public void removeListener(KieScannerEventListener listener) {
        }

        public Collection<KieScannerEventListener> getListeners() {
            return Collections.emptyList();
        }
    }
}

