/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kproject.models;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.compiler.kproject.models.RuleTemplateModelImpl;
import org.drools.util.IoUtils;
import org.kie.api.KieServices;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.model.RuleTemplateModel;
import org.kie.api.conf.BetaRangeIndexOption;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.conf.PrototypesOption;
import org.kie.api.conf.SequentialOption;
import org.kie.api.conf.SessionsPoolOption;
import org.kie.api.io.ResourceType;

public class KieBaseModelImpl
implements KieBaseModel {
    private String name;
    private Set<String> includes = new HashSet<String>();
    private List<String> packages;
    private EqualityBehaviorOption equalsBehavior = EqualityBehaviorOption.IDENTITY;
    private PrototypesOption prototypes = PrototypesOption.DISABLED;
    private KieBaseMutabilityOption mutability = KieBaseMutabilityOption.ALLOWED;
    private EventProcessingOption eventProcessingMode = EventProcessingOption.CLOUD;
    private DeclarativeAgendaOption declarativeAgenda = DeclarativeAgendaOption.DISABLED;
    private SequentialOption sequential = SequentialOption.NO;
    private SessionsPoolOption sessionsPool = SessionsPoolOption.NO;
    private BetaRangeIndexOption betaRangeIndexOption = BetaRangeIndexOption.DISABLED;
    private Map<String, KieSessionModel> kSessions = new HashMap<String, KieSessionModel>();
    private KieModuleModel kModule;
    private String scope = "jakarta.enterprise.context.ApplicationScoped";
    private List<RuleTemplateModel> ruleTemplates = new ArrayList<RuleTemplateModel>();
    private boolean isDefault = false;

    public KieBaseModelImpl() {
    }

    public KieBaseModelImpl(String name) {
        this(null, name);
    }

    public KieBaseModelImpl(KieModuleModel kModule, String name) {
        this.kModule = kModule;
        this.includes = new HashSet<String>();
        this.name = name;
        this.kSessions = Collections.emptyMap();
    }

    public static KieBaseModel defaultKieBaseModel() {
        return KieServices.get().newKieModuleModel().newKieBaseModel("defaultKieBase").addPackage("*").setDefault(true);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public KieBaseModel setDefault(boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public List<String> getPackages() {
        return this.packages != null ? this.packages : Collections.emptyList();
    }

    public KieBaseModel addPackage(String pkg) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>();
        }
        this.packages.add(pkg);
        return this;
    }

    public KieBaseModel removePackage(String pkg) {
        if (this.packages != null) {
            this.packages.remove(pkg);
        }
        return this;
    }

    public KieModuleModel getKModule() {
        return this.kModule;
    }

    public void setKModule(KieModuleModel kieProject) {
        this.kModule = kieProject;
    }

    public Map<String, KieSessionModel> getKieSessionModels() {
        return Collections.unmodifiableMap(this.kSessions);
    }

    public Map<String, KieSessionModel> getRawKieSessionModels() {
        return this.kSessions;
    }

    private void setKSessions(Map<String, KieSessionModel> kSessions) {
        this.kSessions = kSessions;
    }

    public KieSessionModel newKieSessionModel(String name) {
        KieSessionModelImpl kieSessionModel = new KieSessionModelImpl(this, name);
        HashMap<String, KieSessionModel> newMap = new HashMap<String, KieSessionModel>();
        newMap.putAll(this.kSessions);
        newMap.put(kieSessionModel.getName(), kieSessionModel);
        this.setKSessions(newMap);
        return kieSessionModel;
    }

    public KieBaseModel removeKieSessionModel(String qName) {
        HashMap<String, KieSessionModel> newMap = new HashMap<String, KieSessionModel>();
        newMap.putAll(this.kSessions);
        newMap.remove(qName);
        this.setKSessions(newMap);
        return this;
    }

    public List<RuleTemplateModel> getRuleTemplates() {
        return Collections.unmodifiableList(this.ruleTemplates);
    }

    public List<RuleTemplateModel> getRawRuleTemplates() {
        return this.ruleTemplates;
    }

    public KieBaseModel addRuleTemplate(String dtable, String template, int row, int col) {
        this.ruleTemplates.add(new RuleTemplateModelImpl(this, dtable, template, row, col));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public KieBaseModel setNameForUnmarshalling(String name) {
        this.name = name;
        return this;
    }

    void changeKSessionName(KieSessionModel kieSession, String oldName, String newName) {
        this.kSessions.remove(oldName);
        this.kSessions.put(newName, kieSession);
    }

    public Set<String> getIncludes() {
        return Collections.unmodifiableSet(this.includes);
    }

    public KieBaseModel addInclude(String kBaseQName) {
        this.includes.add(kBaseQName);
        return this;
    }

    public KieBaseModel removeInclude(String kBaseQName) {
        this.includes.remove(kBaseQName);
        return this;
    }

    public SessionsPoolOption getSessionsPool() {
        return this.sessionsPool;
    }

    public KieBaseModel setSessionsPool(SessionsPoolOption sessionsPool) {
        this.sessionsPool = sessionsPool;
        return this;
    }

    public EqualityBehaviorOption getEqualsBehavior() {
        return this.equalsBehavior;
    }

    public KieBaseModel setEqualsBehavior(EqualityBehaviorOption equalsBehaviour) {
        this.equalsBehavior = equalsBehaviour;
        return this;
    }

    public PrototypesOption getPrototypes() {
        return this.prototypes;
    }

    public KieBaseModel setPrototypes(PrototypesOption prototypes) {
        this.prototypes = prototypes;
        return this;
    }

    public KieBaseMutabilityOption getMutability() {
        return this.mutability;
    }

    public KieBaseModel setMutability(KieBaseMutabilityOption mutability) {
        this.mutability = mutability;
        return this;
    }

    public EventProcessingOption getEventProcessingMode() {
        return this.eventProcessingMode;
    }

    public KieBaseModel setEventProcessingMode(EventProcessingOption eventProcessingMode) {
        this.eventProcessingMode = eventProcessingMode;
        return this;
    }

    public DeclarativeAgendaOption getDeclarativeAgenda() {
        return this.declarativeAgenda;
    }

    public KieBaseModel setDeclarativeAgenda(DeclarativeAgendaOption declarativeAgenda) {
        this.declarativeAgenda = declarativeAgenda;
        return this;
    }

    public BetaRangeIndexOption getBetaRangeIndexOption() {
        return this.betaRangeIndexOption;
    }

    public KieBaseModel setBetaRangeIndexOption(BetaRangeIndexOption betaRangeIndexOption) {
        this.betaRangeIndexOption = betaRangeIndexOption;
        return this;
    }

    public SequentialOption getSequential() {
        return this.sequential;
    }

    public KieBaseModel setSequential(SequentialOption sequential) {
        this.sequential = sequential;
        return this;
    }

    public KieBaseModel setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public static List<String> getFiles(String kBaseName, ZipFile zipFile) {
        ArrayList<String> files = new ArrayList<String>();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String fileName = zipEntry.getName();
            if (!KieBaseModelImpl.filterFileInKBase(kBaseName.replace('.', '/'), fileName)) continue;
            files.add(fileName);
        }
        return files;
    }

    public static List<String> getFiles(File rootFolder) {
        return IoUtils.recursiveListFile((File)rootFolder, (String)"", file -> {
            String fileName = file.getName();
            return fileName.endsWith(ResourceType.DRL.getDefaultExtension()) || fileName.endsWith(ResourceType.GDRL.getDefaultExtension()) || fileName.endsWith(ResourceType.RDRL.getDefaultExtension()) || fileName.endsWith(ResourceType.BPMN2.getDefaultExtension()) || fileName.endsWith(ResourceType.TDRL.getDefaultExtension());
        });
    }

    private static boolean filterFileInKBase(String rootPath, String fileName) {
        return fileName.startsWith(rootPath) && (fileName.endsWith(ResourceType.DRL.getDefaultExtension()) || fileName.endsWith(ResourceType.GDRL.getDefaultExtension()) || fileName.endsWith(ResourceType.RDRL.getDefaultExtension()) || fileName.endsWith(ResourceType.BPMN2.getDefaultExtension()) || fileName.endsWith(ResourceType.TDRL.getDefaultExtension()));
    }

    public String toString() {
        return "KieBaseModelImpl [name=" + this.name + ", includes=" + this.includes + ", packages=" + this.getPackages() + ", equalsBehavior=" + this.equalsBehavior + ", prototypes=" + this.prototypes + ", mutability=" + this.mutability + ", eventProcessingMode=" + this.eventProcessingMode + ", kSessions=" + this.kSessions + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KieBaseModelImpl that = (KieBaseModelImpl)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

