/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.drools.base.time.TimeUtils;

public class TimeIntervalParser {
    private TimeIntervalParser() {
    }

    public static long[] parse(String paramText) {
        if (paramText == null || paramText.trim().length() == 0) {
            return new long[0];
        }
        String[] params = paramText.split(",");
        long[] result = new long[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = TimeIntervalParser.parseSingle(params[i]);
        }
        return result;
    }

    public static long parseSingle(String param) {
        if ((param = param.trim()).length() > 0) {
            return TimeUtils.parseTimeString(param);
        }
        throw new RuntimeException("Empty parameters not allowed in: [" + param + "]");
    }

    public static long getTimestampFromDate(Object obj) {
        if (obj instanceof Long) {
            Long l = (Long)obj;
            return l;
        }
        if (obj instanceof Date) {
            Date d = (Date)obj;
            return d.getTime();
        }
        try {
            if (obj instanceof LocalDate) {
                LocalDate ld = (LocalDate)obj;
                return ld.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            }
            if (obj instanceof LocalDateTime) {
                LocalDateTime ldt = (LocalDateTime)obj;
                return ldt.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            }
            if (obj instanceof ZonedDateTime) {
                ZonedDateTime zdt = (ZonedDateTime)obj;
                return zdt.toInstant().toEpochMilli();
            }
            if (obj instanceof Instant) {
                Instant i = (Instant)obj;
                return i.toEpochMilli();
            }
        }
        catch (ArithmeticException ae) {
            throw new RuntimeException("Cannot convert " + obj.getClass().getSimpleName() + " '" + obj + "' into a long value");
        }
        throw new RuntimeException("Cannot extract timestamp from " + obj);
    }
}

