/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.factmodel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.base.factmodel.traits.TraitFieldTMS;
import org.drools.base.factmodel.traits.TraitType;
import org.drools.base.reteoo.PropertySpecificUtil;
import org.drools.base.util.PropertyReactivityUtil;
import org.drools.core.WorkingMemory;
import org.drools.mvel.MVELSafeHelper;
import org.drools.traits.core.factmodel.TraitFieldImpl;
import org.drools.traits.core.factmodel.TypeCache;
import org.drools.traits.core.factmodel.TypeWrapper;
import org.drools.util.bitmask.BitMask;

public class TraitFieldTMSImpl
implements TraitFieldTMS,
Externalizable {
    private Map<String, TraitFieldImpl> fieldTMS = new LinkedHashMap<String, TraitFieldImpl>();
    private transient WorkingMemory workingMemory;
    private TypeCache typeCache = new TypeCache();
    private BitMask modificationMask = PropertySpecificUtil.onlyTraitBitSetMask();

    public void init(Object wm) {
        this.workingMemory = (WorkingMemory)wm;
        if (this.getTypeCache().needsInit()) {
            this.getTypeCache().init(this.workingMemory);
        }
    }

    public void registerField(Class domainKlass, String name) {
        this.registerField(domainKlass, name, Object.class, null, null);
    }

    public void registerField(Class domainKlass, String name, Class rangeKlass, Object value, String initial) {
        short pos = (short)PropertyReactivityUtil.getAccessibleProperties((Class)domainKlass).indexOf(name);
        TraitFieldImpl fld = new TraitFieldImpl(this.getKlass(rangeKlass), value, initial != null ? MVELSafeHelper.getEvaluator().eval(initial, rangeKlass) : null, pos);
        this.fieldTMS.put(name, fld);
    }

    public Object set(String name, Object value, Class klass) {
        return this.fieldTMS.get(name).set(value, this.getKlass(klass), this.workingMemory);
    }

    public Object get(String name, Class klass) {
        return this.fieldTMS.get(name).get(this.getKlass(klass));
    }

    public boolean isManagingField(String name) {
        return this.fieldTMS.containsKey(name);
    }

    public Object donField(String name, TraitType trait, String defaultValue, Class klass, boolean logical) {
        TraitFieldImpl fld = this.fieldTMS.get(name);
        this.modificationMask = PropertySpecificUtil.setPropertyOnMask((BitMask)this.modificationMask, (int)fld.getPosition());
        return fld.don(trait, defaultValue != null ? MVELSafeHelper.getEvaluator().eval(defaultValue, klass) : null, this.getKlass(klass), logical, this.workingMemory);
    }

    public Object shedField(String name, TraitType trait, Class rangeKlass, Class asKlass) {
        TraitFieldImpl fld = this.fieldTMS.get(name);
        this.modificationMask = PropertySpecificUtil.setPropertyOnMask((BitMask)this.modificationMask, (int)fld.getPosition());
        return fld.shed(trait, this.getKlass(rangeKlass), this.getKlass(asKlass), this.workingMemory);
    }

    private TypeWrapper getKlass(Class klass) {
        TypeWrapper wrapper = this.getTypeCache().get(klass.getName());
        if (wrapper == null) {
            wrapper = new TypeWrapper(klass);
            this.getTypeCache().put(wrapper.getName(), wrapper);
        }
        return wrapper;
    }

    public boolean needsInit() {
        return this.workingMemory == null;
    }

    public BitMask getModificationMask() {
        return this.modificationMask;
    }

    public void resetModificationMask() {
        this.modificationMask = PropertySpecificUtil.onlyTraitBitSetMask();
    }

    public TraitFieldImpl getRegisteredTraitField(String name) {
        return this.fieldTMS.get(name);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.fieldTMS.size());
        ArrayList<String> keys = new ArrayList<String>(this.fieldTMS.keySet());
        Collections.sort(keys);
        for (String k : keys) {
            out.writeObject(k);
            out.writeObject(this.fieldTMS.get(k));
        }
        out.writeObject(this.typeCache);
        out.writeObject(this.modificationMask);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fieldTMS = new HashMap<String, TraitFieldImpl>();
        int n = in.readInt();
        for (int j = 0; j < n; ++j) {
            String k = (String)in.readObject();
            TraitFieldImpl tf = (TraitFieldImpl)in.readObject();
            this.fieldTMS.put(k, tf);
        }
        this.typeCache = (TypeCache)in.readObject();
        this.modificationMask = (BitMask)in.readObject();
    }

    public TypeCache getTypeCache() {
        if (this.typeCache == null) {
            this.typeCache = new TypeCache();
        }
        return this.typeCache;
    }

    public String toString() {
        return "TraitFieldTMSImpl{}";
    }
}

