/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.rule.accessor.Evaluator;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.time.Interval;
import org.drools.base.util.TimeIntervalParser;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.core.common.DefaultEventHandle;
import org.drools.drl.parser.impl.Operator;
import org.drools.mvel.evaluators.BaseEvaluator;
import org.drools.mvel.evaluators.VariableRestriction;
import org.kie.api.runtime.rule.FactHandle;

public class MetByEvaluatorDefinition
implements EvaluatorDefinition {
    protected static final String metByOp = Operator.BuiltInOperator.MET_BY.getSymbol();
    public static Operator MET_BY = Operator.determineOperator((String)metByOp, (boolean)false);
    public static Operator NOT_MET_BY = Operator.determineOperator((String)metByOp, (boolean)true);
    private static String[] SUPPORTED_IDS = new String[]{metByOp};
    private Map<String, MetByEvaluator> cache = Collections.emptyMap();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        MetByEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, MetByEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            long[] params = TimeIntervalParser.parse((String)parameterText);
            eval = new MetByEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class MetByEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long finalRange;
        private String paramText;

        public MetByEvaluator() {
        }

        public MetByEvaluator(ValueType type, boolean isNegated, long[] parameters, String paramText) {
            super(type, isNegated ? NOT_MET_BY : MET_BY);
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.finalRange = in.readLong();
            this.paramText = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.finalRange);
            out.writeObject(this.paramText);
        }

        @Override
        public boolean isTemporal() {
            return true;
        }

        @Override
        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(Long.MIN_VALUE, 0L);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor, FactHandle object1, FieldValue object2) {
            throw new RuntimeException("The 'metby' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        @Override
        public boolean evaluateCachedRight(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle left) {
            if (context.rightNull || context.declaration.getExtractor().isNullValue(valueResolver, left.getObject())) {
                return false;
            }
            long rightStartTS = ((VariableRestriction.LeftEndRightStartContextEntry)context).timestamp;
            long dist = Math.abs(rightStartTS - ((DefaultEventHandle)left).getEndTimestamp());
            return this.getOperator().isNegated() ^ dist <= this.finalRange;
        }

        @Override
        public boolean evaluateCachedLeft(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle right) {
            if (context.leftNull || context.extractor.isNullValue(valueResolver, right.getObject())) {
                return false;
            }
            long rightStartTS = ((DefaultEventHandle)right).getStartTimestamp();
            long dist = Math.abs(rightStartTS - ((VariableRestriction.LeftEndRightStartContextEntry)context).timestamp);
            return this.getOperator().isNegated() ^ dist <= this.finalRange;
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor1, FactHandle handle1, ReadAccessor extractor2, FactHandle handle2) {
            if (extractor1.isNullValue(valueResolver, handle1.getObject()) || extractor2.isNullValue(valueResolver, handle2.getObject())) {
                return false;
            }
            long obj1StartTS = ((DefaultEventHandle)handle1).getStartTimestamp();
            long dist = Math.abs(obj1StartTS - ((DefaultEventHandle)handle2).getEndTimestamp());
            return this.getOperator().isNegated() ^ dist <= this.finalRange;
        }

        @Override
        public String toString() {
            return "metby[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        @Override
        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.finalRange ^ this.finalRange >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MetByEvaluator other = (MetByEvaluator)obj;
            return this.finalRange == other.finalRange;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setParameters(long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.finalRange = 0L;
                return;
            } else {
                if (parameters.length != 1) throw new RuntimeException("[MetBy Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
                if (parameters[0] < 0L) throw new RuntimeException("[MetBy Evaluator]: Not possible to use negative parameter: '" + this.paramText + "'");
                this.finalRange = parameters[0];
            }
        }
    }
}

