/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.expr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Map;
import org.drools.base.base.ValueResolver;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.reteoo.SortDeclarations;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.accessor.Salience;
import org.drools.base.time.TimeUtils;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.drools.mvel.expr.MVELCompileable;
import org.drools.mvel.expr.MvelEvaluator;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.Match;
import org.mvel2.integration.VariableResolverFactory;

public class MVELSalienceExpression
implements Salience,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private MVELCompilationUnit unit;
    private String id;
    private MvelEvaluator<Object> evaluator;

    public MVELSalienceExpression() {
    }

    public MVELSalienceExpression(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.unit = (MVELCompilationUnit)in.readObject();
        this.id = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.unit);
        out.writeUTF(this.id);
    }

    public MVELCompilationUnit getMVELCompilationUnit() {
        return this.unit;
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        this.evaluator = MvelEvaluator.createMvelEvaluator(this.unit.getCompiledExpression(runtimeData));
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData, RuleImpl rule) {
        this.evaluator = MvelEvaluator.createMvelEvaluator(this.unit.getCompiledExpression(runtimeData, (Object)rule.toRuleNameAndPathString()));
    }

    public int getValue(Match match, Rule rule, ValueResolver valueResolver) {
        Object value;
        InternalMatch internalMatch = (InternalMatch)match;
        VariableResolverFactory factory = this.unit.getFactory(valueResolver, valueResolver != null ? internalMatch.getTerminalNode().getSalienceDeclarations() : null, rule, null, (BaseTuple)(valueResolver != null ? internalMatch.getTuple() : null), null, valueResolver, valueResolver.getGlobalResolver());
        InternalKnowledgePackage pkg = ((InternalKnowledgeBase)valueResolver.getRuleBase()).getPackage("MAIN");
        if (pkg != null) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(this.id);
            factory.setNextFactory((VariableResolverFactory)data.getFunctionFactory());
        }
        if ((value = this.evaluator.evaluate(factory)) instanceof String) {
            value = TimeUtils.parseTimeString((String)((String)value));
        }
        return ((Number)value).intValue();
    }

    public Declaration[] findDeclarations(Map<String, Declaration> decls) {
        Declaration[] declrs = this.unit.getPreviousDeclarations();
        Declaration[] salienceDeclarations = new Declaration[declrs.length];
        int i = 0;
        for (Declaration declr : declrs) {
            salienceDeclarations[i++] = decls.get(declr.getIdentifier());
        }
        Arrays.sort(salienceDeclarations, SortDeclarations.instance);
        return salienceDeclarations;
    }

    public boolean isDefault() {
        return false;
    }

    public int getValue() {
        throw new UnsupportedOperationException();
    }

    public boolean isDynamic() {
        return true;
    }

    public String toString() {
        return this.unit.getExpression();
    }
}

