/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.common;

import org.drools.base.factmodel.traits.CoreWrapper;
import org.drools.base.factmodel.traits.TraitTypeEnum;
import org.drools.base.factmodel.traits.Traitable;
import org.drools.base.factmodel.traits.TraitableBean;
import org.drools.base.rule.TypeDeclaration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.traits.core.base.TraitHelperImpl;
import org.drools.traits.core.factmodel.TraitProxyImpl;

public class TraitDefaultFactHandle
extends DefaultFactHandle {
    protected TraitTypeEnum traitType = TraitTypeEnum.NON_TRAIT;

    public TraitDefaultFactHandle(long id, Object object, long recency, WorkingMemoryEntryPoint wmEntryPoint) {
        this(id, TraitDefaultFactHandle.determineIdentityHashCode((Object)object), object, recency, wmEntryPoint);
    }

    public TraitDefaultFactHandle(long id, int identityHashCode, Object object, long recency, WorkingMemoryEntryPoint wmEntryPoint) {
        this.id = id;
        this.entryPointId = wmEntryPoint == null ? null : wmEntryPoint.getEntryPoint();
        this.wmEntryPoint = wmEntryPoint;
        this.recency = recency;
        this.traitType = this.determineTraitType(object);
        this.setObject(object);
        this.identityHashCode = identityHashCode;
        if (wmEntryPoint != null) {
            this.setLinkedTuples(wmEntryPoint.getKnowledgeBase());
            this.wmEntryPoint = wmEntryPoint;
        } else {
            this.linkedTuples = new DefaultFactHandle.SingleLinkedTuples();
        }
    }

    public Object as(Class klass) throws ClassCastException {
        if (klass.isAssignableFrom(this.object.getClass())) {
            return this.object;
        }
        if (this.isTraitOrTraitable()) {
            TraitHelperImpl traitHelper = new TraitHelperImpl();
            Object k = traitHelper.extractTrait((InternalFactHandle)this, klass);
            if (k != null) {
                return k;
            }
            throw new RuntimeException(String.format("Cannot trait to %s", klass));
        }
        throw new ClassCastException("The Handle's Object can't be cast to " + klass);
    }

    private TraitTypeEnum determineTraitType(Object object) {
        if (object == null) {
            return TraitTypeEnum.NON_TRAIT;
        }
        if (object instanceof TraitProxyImpl) {
            return TraitTypeEnum.TRAIT;
        }
        if (object instanceof CoreWrapper) {
            return TraitTypeEnum.WRAPPED_TRAITABLE;
        }
        if (object instanceof TraitableBean) {
            return TraitTypeEnum.TRAITABLE;
        }
        if (object.getClass().getAnnotation(Traitable.class) != null) {
            return TraitTypeEnum.LEGACY_TRAITABLE;
        }
        TypeDeclaration typeDeclaration = this.wmEntryPoint.getKnowledgeBase().getTypeDeclaration(object.getClass());
        if (typeDeclaration != null && typeDeclaration.getTypeClassDef().getAnnotation(Traitable.class) != null) {
            return TraitTypeEnum.LEGACY_TRAITABLE;
        }
        return TraitTypeEnum.NON_TRAIT;
    }

    public TraitTypeEnum getTraitType() {
        return this.traitType;
    }

    protected void setTraitType(TraitTypeEnum traitType) {
        this.traitType = traitType;
    }

    public boolean isTraitOrTraitable() {
        return this.traitType != TraitTypeEnum.NON_TRAIT;
    }

    public boolean isTraitable() {
        return this.traitType == TraitTypeEnum.TRAITABLE || this.traitType == TraitTypeEnum.WRAPPED_TRAITABLE;
    }

    public boolean isTraiting() {
        return this.traitType == TraitTypeEnum.TRAIT;
    }

    public void setObject(Object object) {
        this.object = object;
        this.objectClassName = null;
        this.objectHashCode = 0;
        if (this.isTraitOrTraitable()) {
            TraitTypeEnum newType = this.determineTraitType(object);
            if (this.traitType != TraitTypeEnum.LEGACY_TRAITABLE || newType == TraitTypeEnum.LEGACY_TRAITABLE) {
                this.identityHashCode = TraitDefaultFactHandle.determineIdentityHashCode((Object)object);
            }
            this.traitType = newType;
        } else {
            this.identityHashCode = 0;
        }
    }
}

