/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.drools.base.RuleBase;
import org.drools.base.base.AcceptsClassObjectType;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.factmodel.AnnotationDefinition;
import org.drools.base.reteoo.PropertySpecificUtil;
import org.drools.base.rule.Behavior;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.From;
import org.drools.base.rule.MutableTypeConstraint;
import org.drools.base.rule.PatternSource;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.XpathBackReference;
import org.drools.base.rule.accessor.PatternExtractor;
import org.drools.base.rule.constraint.Constraint;
import org.drools.base.rule.constraint.XpathConstraint;
import org.drools.util.bitmask.BitMask;
import org.drools.wiring.api.util.ClassUtils;
import org.kie.internal.ruleunit.RuleUnitUtil;

public class Pattern
implements RuleConditionElement,
AcceptsClassObjectType,
Externalizable {
    private static final long serialVersionUID = 510L;
    private ObjectType objectType;
    private List<Constraint> constraints = Collections.EMPTY_LIST;
    private Declaration declaration;
    private Map<String, Declaration> declarations = Collections.EMPTY_MAP;
    private int patternId;
    private PatternSource source;
    private List<Behavior> behaviors;
    private Collection<String> listenedProperties = new HashSet<String>();
    private boolean hasNegativeConstraint;
    private transient XpathBackReference backRefDeclarations;
    private Map<String, AnnotationDefinition> annotations;
    private int tupleIndex;
    private int objectIndex;
    private boolean passive;
    private XpathConstraint xPath;
    private BitMask positiveWatchMask;
    private BitMask negativeWatchMask;

    public Pattern() {
        this(0, null);
    }

    public Pattern(int patternId, ObjectType objectType) {
        this(patternId, 0, 0, objectType, null);
    }

    public Pattern(int patternId, ObjectType objectType, String identifier) {
        this(patternId, 0, 0, objectType, identifier);
    }

    public Pattern(int patternId, int tupleIndex, int objectIndex, ObjectType objectType, String identifier) {
        this(patternId, tupleIndex, objectIndex, objectType, identifier, false);
    }

    public Pattern(int patternId, int tupleIndex, int objectIndex, ObjectType objectType, String identifier, boolean isInternalFact) {
        this.patternId = patternId;
        this.tupleIndex = tupleIndex;
        this.objectIndex = objectIndex;
        this.objectType = objectType;
        if (identifier != null && !identifier.equals("")) {
            this.declaration = new Declaration(identifier, new PatternExtractor(objectType), this, isInternalFact);
            this.declarations = new HashMap<String, Declaration>();
            this.declarations.put(this.declaration.getIdentifier(), this.declaration);
        } else {
            this.declaration = null;
        }
    }

    public boolean hasNegativeConstraint() {
        return this.hasNegativeConstraint;
    }

    public void setHasNegativeConstraint(boolean negative) {
        this.hasNegativeConstraint = negative;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.objectType = (ObjectType)in.readObject();
        this.constraints = (List)in.readObject();
        this.declaration = (Declaration)in.readObject();
        this.declarations = (Map)in.readObject();
        this.behaviors = (List)in.readObject();
        this.patternId = in.readInt();
        this.source = (PatternSource)in.readObject();
        this.tupleIndex = in.readInt();
        this.objectIndex = in.readInt();
        this.listenedProperties = (Collection)in.readObject();
        PatternSource patternSource = this.source;
        if (patternSource instanceof From) {
            From from = (From)patternSource;
            from.setResultPattern(this);
        }
        this.annotations = (Map)in.readObject();
        this.passive = in.readBoolean();
        this.hasNegativeConstraint = in.readBoolean();
        this.xPath = (XpathConstraint)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.objectType);
        out.writeObject(this.constraints);
        out.writeObject(this.declaration);
        out.writeObject(this.declarations);
        out.writeObject(this.behaviors);
        out.writeInt(this.patternId);
        out.writeObject(this.source);
        out.writeInt(this.tupleIndex);
        out.writeInt(this.objectIndex);
        out.writeObject(this.getListenedProperties());
        out.writeObject(this.annotations);
        out.writeBoolean(this.passive);
        out.writeBoolean(this.hasNegativeConstraint);
        out.writeObject(this.xPath);
    }

    @Override
    public void setClassObjectType(ClassObjectType objectType) {
        this.objectType = objectType;
    }

    public Declaration[] getRequiredDeclarations() {
        HashSet decl = new HashSet();
        for (Constraint constr : this.constraints) {
            Collections.addAll(decl, constr.getRequiredDeclarations());
        }
        return decl.toArray(new Declaration[decl.size()]);
    }

    @Override
    public Pattern clone() {
        String identifier = this.declaration != null ? this.declaration.getIdentifier() : null;
        Pattern clone = new Pattern(this.patternId, this.tupleIndex, this.objectIndex, this.objectType, identifier, this.declaration != null && this.declaration.isInternalFact());
        clone.listenedProperties = this.listenedProperties;
        if (this.getSource() != null) {
            clone.setSource((PatternSource)this.getSource().clone());
            if (this.source instanceof From) {
                ((From)clone.getSource()).setResultPattern(clone);
            }
        }
        for (Declaration decl : this.declarations.values()) {
            Declaration addedDeclaration = clone.addDeclaration(decl.getIdentifier());
            addedDeclaration.setReadAccessor(decl.getExtractor());
            addedDeclaration.setBindingName(decl.getBindingName());
            addedDeclaration.setxPathOffset(decl.getxPathOffset());
        }
        for (Constraint oldConstr : this.constraints) {
            Constraint clonedConstr = oldConstr.clone();
            Declaration[] oldDecl = oldConstr.getRequiredDeclarations();
            Declaration[] newDecl = clonedConstr.getRequiredDeclarations();
            for (int i = 0; i < newDecl.length; ++i) {
                if (newDecl[i].getPattern() != this) continue;
                newDecl[i].setPattern(clone);
                clonedConstr.replaceDeclaration(oldDecl[i], newDecl[i]);
            }
            clone.addConstraint(clonedConstr);
        }
        if (this.behaviors != null) {
            for (Behavior behavior : this.behaviors) {
                clone.addBehavior(behavior);
            }
        }
        return clone;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public PatternSource getSource() {
        return this.source;
    }

    public void setSource(PatternSource source) {
        this.source = source;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public void addConstraint(int index, Constraint constraint) {
        if (this.constraints == Collections.EMPTY_LIST) {
            this.constraints = new ArrayList<Constraint>(1);
        }
        if (constraint.getType().equals((Object)Constraint.ConstraintType.UNKNOWN)) {
            this.setConstraintType((MutableTypeConstraint)constraint);
        } else if (constraint.getType().equals((Object)Constraint.ConstraintType.XPATH)) {
            this.xPath = (XpathConstraint)constraint;
        }
        this.constraints.add(index, constraint);
    }

    public void addConstraints(Collection<Constraint> constraints) {
        if (this.constraints == Collections.EMPTY_LIST) {
            this.constraints = new ArrayList<Constraint>(constraints.size());
        }
        for (Constraint constraint : constraints) {
            if (constraint.getType().equals((Object)Constraint.ConstraintType.UNKNOWN)) {
                this.setConstraintType((MutableTypeConstraint)constraint);
            } else if (constraint.getType().equals((Object)Constraint.ConstraintType.XPATH)) {
                this.xPath = (XpathConstraint)constraint;
            }
            this.constraints.add(constraint);
        }
    }

    public void addConstraint(Constraint constraint) {
        if (this.constraints == Collections.EMPTY_LIST) {
            this.constraints = new ArrayList<Constraint>(1);
        }
        if (constraint.getType().equals((Object)Constraint.ConstraintType.UNKNOWN)) {
            this.setConstraintType((MutableTypeConstraint)constraint);
        }
        this.constraints.add(constraint);
    }

    public boolean hasXPath() {
        return this.xPath != null;
    }

    public XpathConstraint getXpathConstraint() {
        return this.xPath;
    }

    public Declaration getXPathDeclaration() {
        return this.xPath != null ? this.xPath.getDeclaration() : null;
    }

    public Declaration addDeclaration(String identifier) {
        Declaration declaration = this.resolveDeclaration(identifier);
        if (declaration == null) {
            declaration = new Declaration(identifier, null, this, true);
            this.addDeclaration(declaration);
        }
        return declaration;
    }

    public void addDeclaration(Declaration decl) {
        if (this.declarations == Collections.EMPTY_MAP) {
            this.declarations = new HashMap<String, Declaration>();
        }
        this.declarations.put(decl.getIdentifier(), decl);
    }

    public void resetDeclarations() {
        this.declarations = Collections.EMPTY_MAP;
    }

    public boolean isBound() {
        return this.declaration != null;
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public int getPatternId() {
        return this.patternId;
    }

    public int getObjectIndex() {
        return this.objectIndex;
    }

    public void setObjectIndex(int objectIndex) {
        this.objectIndex = objectIndex;
    }

    public int getTupleIndex() {
        return this.tupleIndex;
    }

    public void setTupleIndex(int tupleIndex) {
        this.tupleIndex = tupleIndex;
    }

    public Map<String, Declaration> getDeclarations() {
        return this.declarations;
    }

    @Override
    public Map<String, Declaration> getInnerDeclarations() {
        return this.backRefDeclarations != null ? this.backRefDeclarations.getDeclarationMap() : this.declarations;
    }

    @Override
    public Map<String, Declaration> getOuterDeclarations() {
        return this.getInnerDeclarations();
    }

    @Override
    public Declaration resolveDeclaration(String identifier) {
        return this.backRefDeclarations != null ? this.backRefDeclarations.getDeclarationMap().get(identifier) : this.declarations.get(identifier);
    }

    public String toString() {
        return "Pattern type='" + (this.objectType == null ? "null" : this.objectType.toString()) + "', patternId='" + this.patternId + "', objectIndex='" + this.getObjectIndex() + "', identifer='" + (this.declaration == null ? "" : this.declaration.toString()) + "'";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.constraints.hashCode();
        result = 31 * result + (this.declaration == null ? 0 : this.declaration.hashCode());
        result = 31 * result + this.patternId;
        result = 31 * result + (this.objectType == null ? 0 : this.objectType.hashCode());
        result = 31 * result + (this.behaviors == null ? 0 : this.behaviors.hashCode());
        result = 31 * result + this.tupleIndex;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Pattern other = (Pattern)object;
        if (!this.constraints.equals(other.constraints)) {
            return false;
        }
        if (this.behaviors != other.behaviors || this.behaviors != null && !this.behaviors.equals(other.behaviors)) {
            return false;
        }
        if (this.declaration == null ? other.declaration != null : !this.declaration.equals(other.declaration)) {
            return false;
        }
        if (this.patternId != other.patternId) {
            return false;
        }
        if (!this.objectType.equals(other.objectType)) {
            return false;
        }
        if (this.tupleIndex != other.tupleIndex) {
            return false;
        }
        return Objects.equals(this.source, other.source);
    }

    public List<RuleConditionElement> getNestedElements() {
        return this.source != null ? Collections.singletonList(this.source) : Collections.EMPTY_LIST;
    }

    @Override
    public boolean isPatternScopeDelimiter() {
        return true;
    }

    private void setConstraintType(MutableTypeConstraint constraint) {
        Declaration[] declarations = constraint.getRequiredDeclarations();
        boolean isAlphaConstraint = true;
        for (int i = 0; isAlphaConstraint && i < declarations.length; ++i) {
            if (declarations[i].isGlobal() || declarations[i].getPattern() == this) continue;
            isAlphaConstraint = false;
        }
        Constraint.ConstraintType type = isAlphaConstraint ? Constraint.ConstraintType.ALPHA : Constraint.ConstraintType.BETA;
        constraint.setType(type);
    }

    public List<Behavior> getBehaviors() {
        if (this.behaviors == null) {
            return Collections.emptyList();
        }
        return this.behaviors;
    }

    public void setBehaviors(List<Behavior> behaviors) {
        this.behaviors = behaviors;
    }

    public void addBehavior(Behavior behavior) {
        if (this.behaviors == null) {
            this.behaviors = new ArrayList<Behavior>();
        }
        this.behaviors.add(behavior);
    }

    public Collection<String> getListenedProperties() {
        return this.listenedProperties;
    }

    public void addBoundProperty(String boundProperty) {
        if (!this.listenedProperties.contains("!*")) {
            this.listenedProperties.add(boundProperty);
        }
    }

    public void addWatchedProperty(String watchedProperty) {
        this.listenedProperties.add(watchedProperty);
    }

    public void addWatchedProperties(Collection<String> watchedProperties) {
        this.listenedProperties.addAll(watchedProperties);
    }

    public List<String> getAccessibleProperties(RuleBase ruleBase) {
        return PropertySpecificUtil.getAccessibleProperties(ruleBase, this.objectType);
    }

    public BitMask getPositiveWatchMask(List<String> accessibleProperties) {
        if (this.positiveWatchMask == null) {
            this.positiveWatchMask = PropertySpecificUtil.calculatePositiveMask(this.objectType, this.listenedProperties, accessibleProperties);
        }
        return this.positiveWatchMask;
    }

    public void setPositiveWatchMask(BitMask positiveWatchMask) {
        this.positiveWatchMask = positiveWatchMask;
    }

    public BitMask getNegativeWatchMask(List<String> accessibleProperties) {
        if (this.negativeWatchMask == null) {
            this.negativeWatchMask = PropertySpecificUtil.calculateNegativeMask(this.objectType, this.listenedProperties, accessibleProperties);
        }
        return this.negativeWatchMask;
    }

    public void setNegativeWatchMask(BitMask negativeWatchMask) {
        this.negativeWatchMask = negativeWatchMask;
    }

    public Map<String, AnnotationDefinition> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, AnnotationDefinition>();
        }
        return this.annotations;
    }

    public XpathBackReference getBackRefDeclarations() {
        return this.backRefDeclarations;
    }

    public void setBackRefDeclarations(XpathBackReference backRefDeclarations) {
        this.backRefDeclarations = backRefDeclarations;
    }

    public List<Class<?>> getXpathBackReferenceClasses() {
        return this.backRefDeclarations != null ? this.backRefDeclarations.getBackReferenceClasses() : Collections.EMPTY_LIST;
    }

    public boolean isCompatibleWithAccumulateReturnType(Class<?> returnType) {
        return Pattern.isCompatibleWithAccumulateReturnType(this.getPatternType(), returnType);
    }

    public boolean isCompatibleWithFromReturnType(Class<?> returnType) {
        return Pattern.isCompatibleWithFromReturnType(this.getPatternType(), returnType);
    }

    public static boolean isCompatibleWithAccumulateReturnType(Class<?> patternType, Class<?> returnType) {
        return returnType == null || returnType == Object.class || returnType == Number.class && patternType != null && Number.class.isAssignableFrom(patternType) || patternType != null && patternType.isAssignableFrom(ClassUtils.convertFromPrimitiveType(returnType));
    }

    public static boolean isCompatibleWithFromReturnType(Class<?> patternType, Class<?> returnType) {
        return Pattern.isCompatibleWithAccumulateReturnType(patternType, returnType) || Pattern.isIterable(returnType) || RuleUnitUtil.isDataSource(returnType) || patternType != null && (returnType.isAssignableFrom(patternType) || !ClassUtils.isFinal(returnType) && ClassUtils.isInterface(patternType));
    }

    private Class<?> getPatternType() {
        Class<?> clazz;
        ObjectType objectType = this.objectType;
        if (objectType instanceof ClassObjectType) {
            ClassObjectType cot = (ClassObjectType)objectType;
            clazz = cot.getClassType();
        } else {
            clazz = null;
        }
        return clazz;
    }

    private static boolean isIterable(Class<?> clazz) {
        return Iterable.class.isAssignableFrom(clazz) || clazz.isArray();
    }
}

