/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa;

import jakarta.persistence.OptimisticLockException;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.commands.impl.AbstractInterceptor;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimisticLockRetryInterceptor
extends AbstractInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(OptimisticLockRetryInterceptor.class);
    private int retries = Integer.getInteger("org.kie.optlock.retries", 3);
    private long delay = Long.getLong("org.kie.optlock.delay", 50L);
    private long delayFactor = Long.getLong("org.kie.optlock.delayFactor", 4L);
    protected Class<?> targetExceptionClass;
    protected Class<?> targetConstraintViolationExceptionClass;
    private static final ThreadLocal<AtomicInteger> invocationsCounter = new ThreadLocal();

    public OptimisticLockRetryInterceptor() {
        String clazz = System.getProperty("org.kie.optlock.exclass", "org.apache.openjpa.persistence.OptimisticLockException");
        try {
            this.targetExceptionClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            logger.error("Optimistic locking exception class not found {}", (Object)clazz, (Object)e);
        }
        clazz = System.getProperty("org.kie.constraint.exclass", "org.apache.openjpa.util.InvalidStateException");
        try {
            this.targetConstraintViolationExceptionClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Constraint violation exception class not found {}", (Object)clazz, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RequestContext execute(Executable executable, RequestContext ctx) {
        AtomicInteger counter = invocationsCounter.get();
        if (counter == null) {
            counter = new AtomicInteger(0);
            invocationsCounter.set(counter);
        }
        counter.incrementAndGet();
        try {
            RequestContext requestContext = this.internalExecute(executable, ctx);
            return requestContext;
        }
        finally {
            if (counter.decrementAndGet() == 0) {
                invocationsCounter.remove();
            }
        }
    }

    protected RequestContext internalExecute(Executable executable, RequestContext ctx) {
        int attempt = 0;
        long sleepTime = this.delay;
        RuntimeException originException = null;
        while (true) {
            if (attempt > 1) {
                logger.trace("retrying (attempt {})...", (Object)attempt);
            }
            try {
                this.executeNext(executable, (Context)ctx);
                return ctx;
            }
            catch (RuntimeException ex) {
                if (this.hasInterceptorInStack()) {
                    throw ex;
                }
                logger.trace(ex.getClass().getSimpleName() + " caught in " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + ex.getMessage());
                if (!this.isCausedByOptimisticLockingFailure(ex) && !this.isCausedByConstraintViolationFailure(ex)) {
                    throw ex;
                }
                ++attempt;
                if (originException == null) {
                    originException = ex;
                }
                if (attempt <= this.retries) {
                    logger.trace("Command failed due to optimistic locking {} waiting {} millis before retry", (Object)ex, (Object)sleepTime);
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e1) {
                        logger.trace("retry sleeping got interrupted");
                    }
                    sleepTime *= this.delayFactor;
                    continue;
                }
                logger.warn("Retry failed after {} attempts", (Object)attempt);
                throw originException;
            }
            break;
        }
    }

    protected boolean isCausedByOptimisticLockingFailure(Throwable throwable) {
        if (this.targetExceptionClass == null) {
            logger.warn("targetExceptionClass not configured, the retry interceptor is disabled.");
            return false;
        }
        while (throwable != null) {
            if (this.targetExceptionClass.isAssignableFrom(throwable.getClass()) || OptimisticLockException.class.isAssignableFrom(throwable.getClass())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    protected boolean isCausedByConstraintViolationFailure(Throwable throwable) {
        if (this.targetConstraintViolationExceptionClass == null) {
            return false;
        }
        while (throwable != null) {
            if (this.targetConstraintViolationExceptionClass.isAssignableFrom(throwable.getClass())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelayFactor() {
        return this.delayFactor;
    }

    public void setDelayFactor(long delayFactor) {
        this.delayFactor = delayFactor;
    }

    public Class<?> getTargetExceptionClass() {
        return this.targetExceptionClass;
    }

    public void setTargetExceptionClass(Class<?> targetExceptionClass) {
        this.targetExceptionClass = targetExceptionClass;
    }

    protected boolean hasInterceptorInStack() {
        return invocationsCounter.get().get() > 1;
    }
}

