/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.UserTransaction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionSynchronization;
import org.drools.persistence.api.TransactionSynchronizationRegistryHelper;
import org.drools.persistence.jta.JtaTransactionSynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransactionManager
implements TransactionManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    public static final String[] FALLBACK_TRANSACTION_MANAGER_NAMES = new String[]{"java:comp/TransactionManager", "java:appserver/TransactionManager", "java:pm/TransactionManager", "java:/TransactionManager", System.getProperty("jbpm.tm.jndi.lookup")};
    public static final String DEFAULT_TRANSACTION_SYNCHRONIZATION_REGISTRY_NAME = "java:comp/TransactionSynchronizationRegistry";
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_CLASS_NAME = "jakarta.transaction.TransactionSynchronizationRegistry";
    private static Class<?> transactionSynchronizationRegistryClass;
    private static final ThreadLocal<Map<Object, Object>> transactionResources;
    UserTransaction ut;
    Object tsr;
    jakarta.transaction.TransactionManager tm;

    public JtaTransactionManager(Object ut, Object tsr, Object tm) {
        this.ut = ut instanceof UserTransaction ? (UserTransaction)ut : (UserTransaction)(ut != null ? ut : this.findUserTransaction());
        this.tm = tm instanceof jakarta.transaction.TransactionManager ? (jakarta.transaction.TransactionManager)tm : (jakarta.transaction.TransactionManager)(tm != null ? tm : this.findTransactionManager(this.ut));
        this.tsr = tsr != null ? tsr : this.findTransactionSynchronizationRegistry(this.ut, this.tm);
    }

    protected jakarta.transaction.TransactionManager findTransactionManager(UserTransaction ut) {
        InitialContext context;
        if (ut instanceof jakarta.transaction.TransactionManager) {
            this.logger.debug("JTA UserTransaction object [{}] implements TransactionManager", (Object)ut);
            return (jakarta.transaction.TransactionManager)ut;
        }
        try {
            context = new InitialContext();
        }
        catch (NamingException ex) {
            this.logger.debug("Could not initialise JNDI InitialContext", (Throwable)ex);
            return null;
        }
        for (String jndiName : FALLBACK_TRANSACTION_MANAGER_NAMES) {
            if (jndiName == null) continue;
            try {
                jakarta.transaction.TransactionManager tm = (jakarta.transaction.TransactionManager)context.lookup(jndiName);
                this.logger.debug("JTA TransactionManager found at fallback JNDI location [{}]", (Object)jndiName);
                return tm;
            }
            catch (NamingException ex) {
                this.logger.debug("No JTA TransactionManager found at fallback JNDI location [{}]", (Object)jndiName, (Object)ex);
            }
        }
        return null;
    }

    protected UserTransaction findUserTransaction() {
        try {
            InitialContext context = new InitialContext();
            return (UserTransaction)context.lookup(DEFAULT_USER_TRANSACTION_NAME);
        }
        catch (NamingException ex) {
            this.logger.debug("No UserTransaction found at JNDI location [{}]", (Object)DEFAULT_USER_TRANSACTION_NAME, (Object)ex);
            try {
                return (UserTransaction)InitialContext.doLookup(System.getProperty("jbpm.ut.jndi.lookup", "java:jboss/UserTransaction"));
            }
            catch (Exception e1) {
                this.logger.debug("Unable to find transaction: {}. Might be running in CMT environment" + e1.getMessage(), (Throwable)e1);
                return null;
            }
        }
    }

    protected Object findTransactionSynchronizationRegistry(UserTransaction ut, jakarta.transaction.TransactionManager tm) {
        if (transactionSynchronizationRegistryClass == null) {
            this.logger.debug("JTA 1.1 [{}] API not available", (Object)TRANSACTION_SYNCHRONIZATION_REGISTRY_CLASS_NAME);
            return null;
        }
        String jndiName = DEFAULT_TRANSACTION_SYNCHRONIZATION_REGISTRY_NAME;
        try {
            InitialContext context = new InitialContext();
            Object tsrObject = context.lookup(jndiName);
            this.logger.debug("JTA TransactionSynchronizationRegistry found at default JNDI location [{}]", (Object)jndiName);
            return tsrObject;
        }
        catch (NamingException ex) {
            this.logger.debug("No JTA TransactionSynchronizationRegistry found at default JNDI location [{}]", (Object)jndiName, (Object)ex);
            String customJndiLocation = System.getProperty("jbpm.tsr.jndi.lookup", "java:jboss/TransactionSynchronizationRegistry");
            try {
                Object tsrObject = InitialContext.doLookup(customJndiLocation);
                this.logger.debug("JTA TransactionSynchronizationRegistry found at default JNDI location [{}]", (Object)customJndiLocation);
                return tsrObject;
            }
            catch (Exception e1) {
                this.logger.debug("No JTA TransactionSynchronizationRegistry found at default JNDI location [{}]", (Object)customJndiLocation, (Object)e1);
                if (transactionSynchronizationRegistryClass.isInstance(ut)) {
                    return ut;
                }
                if (transactionSynchronizationRegistryClass.isInstance(tm)) {
                    return tm;
                }
                return null;
            }
        }
    }

    protected UserTransaction getUt() {
        if (this.ut == null) {
            this.ut = this.findUserTransaction();
        }
        return this.ut;
    }

    @Override
    public boolean begin() {
        int status = this.getStatus();
        if (status == 1) {
            this.logger.debug("Cleanup of transaction that has been rolled back previously");
            this.rollback(true);
            status = this.getStatus();
        }
        if (status == 3) {
            try {
                this.getUt().begin();
                return true;
            }
            catch (Exception e) {
                if (e.getClass().getName().equals("jakarta.ejb.EJBException")) {
                    this.ut = this.findUserTransaction();
                    this.tm = this.findTransactionManager(this.ut);
                    this.tsr = this.findTransactionSynchronizationRegistry(this.ut, this.tm);
                    try {
                        this.ut.begin();
                        return true;
                    }
                    catch (Exception ex) {
                        this.logger.warn("Unable to begin transaction", (Throwable)e);
                        throw new RuntimeException("Unable to begin transaction", e);
                    }
                }
                this.logger.warn("Unable to begin transaction", (Throwable)e);
                throw new RuntimeException("Unable to begin transaction", e);
            }
        }
        return false;
    }

    @Override
    public void commit(boolean transactionOwner) {
        if (transactionOwner) {
            try {
                this.ut.commit();
            }
            catch (Exception e) {
                this.logger.warn("Unable to commit transaction", (Throwable)e);
                throw new RuntimeException("Unable to commit transaction", e);
            }
            finally {
                transactionResources.get().clear();
            }
        }
    }

    @Override
    public void rollback(boolean transactionOwner) {
        try {
            if (transactionOwner) {
                if (this.ut.getStatus() != 6) {
                    this.ut.rollback();
                }
            } else if (this.tsr != null) {
                try {
                    ((TransactionSynchronizationRegistry)this.tsr).setRollbackOnly();
                }
                catch (IllegalStateException e) {
                    this.getUt().setRollbackOnly();
                }
            } else {
                this.getUt().setRollbackOnly();
            }
        }
        catch (Exception e) {
            this.logger.warn("Unable to rollback transaction", (Throwable)e);
            throw new RuntimeException("Unable to rollback transaction", e);
        }
        transactionResources.get().clear();
    }

    @Override
    public int getStatus() {
        int s;
        try {
            s = this.tsr != null ? ((TransactionSynchronizationRegistry)this.tsr).getTransactionStatus() : this.ut.getStatus();
        }
        catch (SystemException e) {
            throw new RuntimeException("Unable to get status for transaction", e);
        }
        switch (s) {
            case 3: {
                return 0;
            }
            case 1: 
            case 4: {
                return 1;
            }
            case 6: {
                return 3;
            }
        }
        return 2;
    }

    @Override
    public void registerTransactionSynchronization(TransactionSynchronization ts) {
        if (this.tsr != null) {
            TransactionSynchronizationRegistryHelper.registerTransactionSynchronization(this.tsr, ts);
        } else if (this.tm != null) {
            try {
                this.tm.getTransaction().registerSynchronization((Synchronization)new JtaTransactionSynchronizationAdapter(ts));
            }
            catch (Exception e) {
                this.logger.warn("Participating in existing JTA transaction, but no JTA TransactionManager or TransactionSychronizationRegistry available: ", (Throwable)e);
            }
        } else {
            this.logger.warn("Participating in existing JTA transaction, but no JTA TransactionManager or TransactionSychronizationRegistry available: ");
        }
    }

    @Override
    public void putResource(Object key, Object resource) {
        if (this.tsr != null) {
            TransactionSynchronizationRegistryHelper.putResource(this.tsr, key, resource);
        } else {
            transactionResources.get().put(key, resource);
        }
    }

    @Override
    public Object getResource(Object key) {
        if (this.tsr != null) {
            return TransactionSynchronizationRegistryHelper.getResource(this.tsr, key);
        }
        return transactionResources.get().get(key);
    }

    static {
        transactionResources = new ThreadLocal<Map<Object, Object>>(){

            @Override
            protected Map<Object, Object> initialValue() {
                return Collections.synchronizedMap(new HashMap());
            }
        };
        ClassLoader cl = JtaTransactionManager.class.getClassLoader();
        try {
            transactionSynchronizationRegistryClass = cl.loadClass(TRANSACTION_SYNCHRONIZATION_REGISTRY_CLASS_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

