/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.petstore;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class PetStoreExample {
    public static void main(String[] args) {
        KieServices ks = KieServices.Factory.get();
        KieContainer kc = ks.getKieClasspathContainer();
        new PetStoreExample().init(kc, true);
    }

    public void init(KieContainer kc, boolean exitOnClose) {
        ArrayList<Product> stock = new ArrayList<Product>();
        stock.add(new Product("Gold Fish", 5.0));
        stock.add(new Product("Fish Tank", 25.0));
        stock.add(new Product("Fish Food", 2.0));
        PetStoreUI ui = new PetStoreUI(stock, new CheckoutCallback(kc));
        ui.createAndShowGUI(exitOnClose);
    }

    public static class Product {
        private String name;
        private double price;

        public Product(String name, double cost) {
            this.name = name;
            this.price = cost;
        }

        public String getName() {
            return this.name;
        }

        public double getPrice() {
            return this.price;
        }

        public String toString() {
            return this.name + " " + this.price;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            long temp = Double.doubleToLongBits(this.price);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Product other = (Product)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return Double.doubleToLongBits(this.price) == Double.doubleToLongBits(other.price);
        }
    }

    public static class PetStoreUI
    extends JPanel {
        private static final long serialVersionUID = 510L;
        private JTextArea output;
        private TableModel tableModel;
        private CheckoutCallback callback;

        public PetStoreUI(List<Product> items, CheckoutCallback callback) {
            super(new BorderLayout());
            this.callback = callback;
            JSplitPane splitPane = new JSplitPane(0);
            this.add((Component)splitPane, "Center");
            JPanel topHalf = new JPanel();
            topHalf.setLayout(new BoxLayout(topHalf, 0));
            topHalf.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
            topHalf.setMinimumSize(new Dimension(400, 50));
            topHalf.setPreferredSize(new Dimension(450, 250));
            splitPane.add(topHalf);
            JPanel bottomHalf = new JPanel(new BorderLayout());
            bottomHalf.setMinimumSize(new Dimension(400, 50));
            bottomHalf.setPreferredSize(new Dimension(450, 300));
            splitPane.add(bottomHalf);
            JPanel listContainer = new JPanel(new GridLayout(1, 1));
            listContainer.setBorder(BorderFactory.createTitledBorder("List"));
            topHalf.add(listContainer);
            JList<Object> list = new JList<Object>(items.toArray());
            ListSelectionModel listSelectionModel = list.getSelectionModel();
            listSelectionModel.setSelectionMode(0);
            list.addMouseListener(new ListSelectionHandler());
            JScrollPane listPane = new JScrollPane(list);
            listContainer.add(listPane);
            JPanel tableContainer = new JPanel(new GridLayout(1, 1));
            tableContainer.setBorder(BorderFactory.createTitledBorder("Table"));
            topHalf.add(tableContainer);
            this.tableModel = new TableModel();
            JTable table = new JTable(this.tableModel);
            table.addMouseListener(new TableSelectionHandler());
            ListSelectionModel tableSelectionModel = table.getSelectionModel();
            tableSelectionModel.setSelectionMode(0);
            TableColumnModel tableColumnModel = table.getColumnModel();
            tableColumnModel.getColumn(0).setCellRenderer(new NameRenderer());
            tableColumnModel.getColumn(1).setCellRenderer(new PriceRenderer());
            tableColumnModel.getColumn(1).setMaxWidth(50);
            JScrollPane tablePane = new JScrollPane(table);
            tablePane.setPreferredSize(new Dimension(150, 100));
            tableContainer.add(tablePane);
            JPanel checkoutPane = new JPanel();
            JButton button = new JButton("Checkout");
            button.setVerticalTextPosition(0);
            button.setHorizontalTextPosition(10);
            button.addMouseListener(new CheckoutButtonHandler());
            button.setActionCommand("checkout");
            checkoutPane.add(button);
            bottomHalf.add((Component)checkoutPane, "North");
            button = new JButton("Reset");
            button.setVerticalTextPosition(0);
            button.setHorizontalTextPosition(11);
            button.addMouseListener(new ResetButtonHandler());
            button.setActionCommand("reset");
            checkoutPane.add(button);
            bottomHalf.add((Component)checkoutPane, "North");
            this.output = new JTextArea(1, 10);
            this.output.setEditable(false);
            JScrollPane outputPane = new JScrollPane(this.output, 22, 30);
            bottomHalf.add((Component)outputPane, "Center");
            this.callback.setOutput(this.output);
        }

        public void createAndShowGUI(boolean exitOnClose) {
            JFrame frame = new JFrame("Pet Store Demo");
            frame.setDefaultCloseOperation(exitOnClose ? 3 : 2);
            this.setOpaque(true);
            frame.setContentPane(this);
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        }

        private class ListSelectionHandler
        extends MouseAdapter {
            private ListSelectionHandler() {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JList jlist = (JList)e.getSource();
                PetStoreUI.this.tableModel.addItem((Product)jlist.getSelectedValue());
            }
        }

        private class TableSelectionHandler
        extends MouseAdapter {
            private TableSelectionHandler() {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JTable jtable = (JTable)e.getSource();
                TableModel tableModel = (TableModel)jtable.getModel();
                tableModel.removeItem(jtable.getSelectedRow());
            }
        }

        private class NameRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 510L;

            @Override
            public void setValue(Object object) {
                Product item = (Product)object;
                this.setText(item.getName());
            }
        }

        private class PriceRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 510L;

            @Override
            public void setValue(Object object) {
                Product item = (Product)object;
                this.setText(Double.toString(item.getPrice()));
            }
        }

        private class CheckoutButtonHandler
        extends MouseAdapter {
            private CheckoutButtonHandler() {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JButton button = (JButton)e.getComponent();
                PetStoreUI.this.callback.checkout((JFrame)button.getTopLevelAncestor(), PetStoreUI.this.tableModel.getItems());
            }
        }

        private class ResetButtonHandler
        extends MouseAdapter {
            private ResetButtonHandler() {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PetStoreUI.this.output.setText(null);
                PetStoreUI.this.tableModel.clear();
                System.out.println("------ Reset ------");
            }
        }
    }

    public static class CheckoutCallback {
        KieContainer kcontainer;
        JTextArea output;

        public CheckoutCallback(KieContainer kcontainer) {
            this.kcontainer = kcontainer;
        }

        public void setOutput(JTextArea output) {
            this.output = output;
        }

        public String checkout(JFrame frame, List<Product> items) {
            Order order = new Order();
            for (Product p : items) {
                order.addItem(new Purchase(order, p));
            }
            KieSession ksession = this.kcontainer.newKieSession("PetStoreKS");
            ksession.setGlobal("frame", (Object)frame);
            ksession.setGlobal("textArea", (Object)this.output);
            ksession.insert((Object)new Product("Gold Fish", 5.0));
            ksession.insert((Object)new Product("Fish Tank", 25.0));
            ksession.insert((Object)new Product("Fish Food", 2.0));
            ksession.insert((Object)new Product("Fish Food Sample", 0.0));
            ksession.insert((Object)order);
            ksession.fireAllRules();
            return order.toString();
        }
    }

    public static class Purchase {
        private Order order;
        private Product product;

        public Purchase(Order order, Product product) {
            this.order = order;
            this.product = product;
        }

        public Order getOrder() {
            return this.order;
        }

        public Product getProduct() {
            return this.product;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.order == null ? 0 : this.order.hashCode());
            result = 31 * result + (this.product == null ? 0 : this.product.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Purchase other = (Purchase)obj;
            if (this.order == null ? other.order != null : !this.order.equals(other.order)) {
                return false;
            }
            return !(this.product == null ? other.product != null : !this.product.equals(other.product));
        }
    }

    public static class Order {
        private List<Purchase> items = new ArrayList<Purchase>();
        private double grossTotal = -1.0;
        private double discountedTotal = -1.0;
        private static String newline = System.getProperty("line.separator");

        public void addItem(Purchase item) {
            this.items.add(item);
        }

        public List<Purchase> getItems() {
            return this.items;
        }

        public void setGrossTotal(double grossCost) {
            this.grossTotal = grossCost;
        }

        public double getGrossTotal() {
            return this.grossTotal;
        }

        public void setDiscountedTotal(double discountedCost) {
            this.discountedTotal = discountedCost;
        }

        public double getDiscountedTotal() {
            return this.discountedTotal;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("ShoppingCart:" + newline);
            Iterator<Purchase> itemIter = this.getItems().iterator();
            while (itemIter.hasNext()) {
                buf.append("\t" + itemIter.next() + newline);
            }
            return buf.toString();
        }
    }

    private static class TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 510L;
        private String[] columnNames = new String[]{"Name", "Price"};
        private ArrayList<Product> items = new ArrayList();

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.items.get(row);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return Product.class;
        }

        public void addItem(Product item) {
            this.items.add(item);
            this.fireTableRowsInserted(this.items.size(), this.items.size());
        }

        public void removeItem(int row) {
            this.items.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public List<Product> getItems() {
            return this.items;
        }

        public void clear() {
            int lastRow = this.items.size();
            this.items.clear();
            this.fireTableRowsDeleted(0, lastRow);
        }
    }
}

