/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;
import org.drools.util.bitmask.OpenBitSet;

public class EliminationCandidate
implements Comparable<EliminationCandidate> {
    private Graph<BayesVariable> g;
    private boolean[][] adjMatrix;
    private GraphNode<BayesVariable> v;
    private int newEdgesRequired;
    private int weightRequired;
    private OpenBitSet cliqueBitSet;

    public EliminationCandidate(Graph g, boolean[][] adjMatrix, GraphNode v) {
        this.g = g;
        this.adjMatrix = adjMatrix;
        this.v = v;
        this.update();
    }

    public GraphNode getV() {
        return this.v;
    }

    public void update() {
        this.weightRequired = Math.abs(this.v.getContent().getOutcomes().length);
        this.newEdgesRequired = 0;
        this.cliqueBitSet = new OpenBitSet((long)this.adjMatrix.length);
        this.cliqueBitSet.set(this.v.getId());
        boolean[] adjList = this.adjMatrix[this.v.getId()];
        for (int i = 0; i < adjList.length; ++i) {
            if (!adjList[i]) continue;
            GraphNode<BayesVariable> relV = this.g.getNode(i);
            this.weightRequired *= Math.abs(relV.getContent().getOutcomes().length);
            this.cliqueBitSet.set(i);
            for (int j = i + 1; j < adjList.length; ++j) {
                if (!adjList[j] || this.adjMatrix[i][j]) continue;
                ++this.newEdgesRequired;
            }
        }
    }

    public OpenBitSet getCliqueBitSit() {
        return this.cliqueBitSet;
    }

    public int getWeightRequired() {
        return this.weightRequired;
    }

    public int getNewEdgesRequired() {
        return this.newEdgesRequired;
    }

    @Override
    public int compareTo(EliminationCandidate o) {
        if (this.newEdgesRequired != o.newEdgesRequired) {
            return this.newEdgesRequired - o.newEdgesRequired;
        }
        if (this.weightRequired != o.weightRequired) {
            return this.weightRequired - o.weightRequired;
        }
        return this.v.getId() - o.v.getId();
    }

    public String toString() {
        return "EliminationCandidateVertex{v=" + this.v.getId() + ", newEdgesRequired=" + this.newEdgesRequired + ", weightRequired=" + this.weightRequired + ", cliqueBitSet=" + this.cliqueBitSet + "}";
    }
}

