/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.CliqueState;
import org.drools.beliefs.bayes.JunctionTreeSeparator;
import org.drools.beliefs.bayes.PotentialMultiplier;
import org.drools.beliefs.graph.Graph;
import org.drools.util.bitmask.OpenBitSet;

public class JunctionTreeClique {
    private int id;
    private OpenBitSet bitSet;
    private List<BayesVariable> values;
    private JunctionTreeSeparator parentSeparator;
    private List<JunctionTreeSeparator> children;
    private double[] potentials;
    private List<BayesVariable> family;

    public JunctionTreeClique(int id, Graph<BayesVariable> graph, OpenBitSet bitSet) {
        this.id = id;
        this.bitSet = bitSet;
        this.children = new ArrayList<JunctionTreeSeparator>();
        this.values = new ArrayList<BayesVariable>((int)bitSet.cardinality());
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            this.values.add(graph.getNode(i).getContent());
            i = bitSet.nextSetBit(i + 1);
        }
        int numberOfStates = PotentialMultiplier.createNumberOfStates(this.values);
        this.potentials = new double[numberOfStates];
        Arrays.fill(this.potentials, 1.0);
        this.family = new ArrayList<BayesVariable>();
    }

    public void addToFamily(BayesVariable var) {
        this.family.add(var);
    }

    public int getId() {
        return this.id;
    }

    public OpenBitSet getBitSet() {
        return this.bitSet;
    }

    public List<BayesVariable> getValues() {
        return this.values;
    }

    public List<BayesVariable> getFamily() {
        return this.family;
    }

    public double[] getPotentials() {
        return this.potentials;
    }

    public JunctionTreeSeparator getParentSeparator() {
        return this.parentSeparator;
    }

    public void setParentSeparator(JunctionTreeSeparator parentSeparator) {
        this.parentSeparator = parentSeparator;
    }

    public List<JunctionTreeSeparator> getChildren() {
        return this.children;
    }

    public CliqueState createState() {
        return new CliqueState(this, Arrays.copyOf(this.potentials, this.potentials.length));
    }

    public void resetState(CliqueState cliqueState) {
        cliqueState.setPotentials(Arrays.copyOf(this.potentials, this.potentials.length));
    }

    public String toString() {
        StringBuilder seps = new StringBuilder();
        for (JunctionTreeSeparator sep : this.children) {
            seps.append("children[node1.id=");
            seps.append(sep.getParent().getId());
            seps.append(", node2.id=");
            seps.append(sep.getChild().getId());
            seps.append(", bitSet=");
            seps.append(sep.getBitSet());
        }
        return "JunctionTreeNode{id=" + this.id + ", bitSet=" + this.bitSet + ", values=" + this.values + ", children=" + seps + "}";
    }
}

