/*
 * Decompiled with CFR 0.152.
 */
package org.drools.wiring.dynamic;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Map;
import org.drools.wiring.api.ComponentsSupplier;
import org.drools.wiring.api.ResourceProvider;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.drools.wiring.api.util.ByteArrayClassLoader;
import org.drools.wiring.api.util.ClassUtils;
import org.drools.wiring.dynamic.DynamicProjectClassLoader;
import org.drools.wiring.dynamic.PackageClassLoader;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.internal.builder.KnowledgeBuilder;

public class DynamicComponentsSupplier
implements ComponentsSupplier {
    public int servicePriority() {
        return 1;
    }

    public ProjectClassLoader createProjectClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
        return DynamicProjectClassLoader.create(parent, resourceProvider);
    }

    public ByteArrayClassLoader createByteArrayClassLoader(ClassLoader parent) {
        return ClassUtils.isAndroid() ? (ByteArrayClassLoader)ClassUtils.instantiateObject((String)"org.drools.android.MultiDexClassLoader", null, (Object[])new Object[]{parent}) : new DefaultByteArrayClassLoader(parent);
    }

    public ClassLoader createPackageClassLoader(Map<String, byte[]> store, ClassLoader rootClassLoader) {
        return ClassUtils.isAndroid() ? (ClassLoader)ClassUtils.instantiateObject((String)"org.drools.android.DexPackageClassLoader", null, (Object[])new Object[]{this, rootClassLoader}) : new PackageClassLoader(store, rootClassLoader);
    }

    public Object createConsequenceExceptionHandler(String className, ClassLoader classLoader) {
        return ClassUtils.instantiateObject((String)className, (ClassLoader)classLoader);
    }

    public void addPackageFromXSD(KnowledgeBuilder kBuilder, Resource resource, ResourceConfiguration configuration) throws IOException {
        try {
            if (JaxbMethodHolder.jaxbMethod != null) {
                JaxbMethodHolder.jaxbMethod.invoke(null, kBuilder, resource, configuration);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public static class DefaultByteArrayClassLoader
    extends ClassLoader
    implements ByteArrayClassLoader {
        public DefaultByteArrayClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> defineClass(String name, byte[] bytes, ProtectionDomain domain) {
            return this.defineClass(name, bytes, 0, bytes.length, domain);
        }
    }

    private static class JaxbMethodHolder {
        private static final Method jaxbMethod = JaxbMethodHolder.findJaxbMethod();

        private JaxbMethodHolder() {
        }

        private static Method findJaxbMethod() {
            String jaxbClassName = "org.drools.compiler.runtime.pipeline.impl.DroolsJaxbHelperProviderImpl";
            try {
                Class<?> jaxbClass = Class.forName(jaxbClassName);
                return jaxbClass.getMethod("addPackageFromXSD", KnowledgeBuilder.class, Resource.class, ResourceConfiguration.class);
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

