/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.compiler.builder.impl.KnowledgeBuilderFactoryServiceImpl;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.util.KieJarChangeSet;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.drl.ast.descr.TypeFieldDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.io.ByteArrayResource;
import org.drools.util.ClassUtils;
import org.drools.util.StringUtils;
import org.drools.util.TypeResolver;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;
import org.kie.internal.builder.conf.DefaultPackageNameOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ChangeSetBuilder.class);
    private static String defaultPackageName;
    private static final RuleDescrNameConverter RULE_CONVERTER;
    private static final FuncDescrNameConverter FUNC_CONVERTER;
    private static final GlobalDescrNameConverter GLOBAL_CONVERTER;
    private static final RuleHierarchyComparator RULE_HIERARCHY_COMPARATOR;

    private ChangeSetBuilder() {
    }

    public static KieJarChangeSet build(InternalKieModule original, InternalKieModule currentJar) {
        KieJarChangeSet result = new KieJarChangeSet();
        Collection<String> originalFiles = original.getFileNames();
        Collection<String> currentFiles = currentJar.getFileNames();
        ArrayList<String> removedFiles = new ArrayList<String>(originalFiles);
        removedFiles.removeAll(currentFiles);
        if (!removedFiles.isEmpty()) {
            for (String file : removedFiles) {
                result.removeFile(file);
            }
        }
        ArrayList<TypeDeclarationDescr> typeDeclarations = new ArrayList<TypeDeclarationDescr>();
        HashMap<String, String> changedClasses = new HashMap<String, String>();
        for (String file : currentFiles) {
            if (originalFiles.contains(file)) {
                byte[] cb;
                byte[] ob = original.getBytes(file);
                if (Arrays.equals(ob, cb = currentJar.getBytes(file))) continue;
                if (file.endsWith(".class")) {
                    changedClasses.put(ClassUtils.convertResourceToClassName((String)file), file);
                    continue;
                }
                if (ResourceType.DRL.matchesExtension(file) && StringUtils.codeAwareEqualsIgnoreSpaces((String)new String(ob), (String)new String(cb))) continue;
                result.registerChanges(file, ChangeSetBuilder.diffResource(file, ob, cb, typeDeclarations));
                continue;
            }
            result.addFile(file);
        }
        block4: for (TypeDeclarationDescr typeDeclaration : typeDeclarations) {
            InternalKnowledgePackage pkg;
            String fqn = typeDeclaration.getFullTypeName();
            if (changedClasses.containsKey(fqn) || (pkg = original.getPackage(typeDeclaration.getNamespace())) == null) continue;
            TypeResolver resolver = pkg.getTypeResolver();
            for (TypeFieldDescr field : typeDeclaration.getFields().values()) {
                String fieldType;
                try {
                    fieldType = resolver.resolveType(field.getPattern().getObjectType()).getCanonicalName();
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                if (!changedClasses.containsKey(fieldType)) continue;
                changedClasses.put(fqn, ClassUtils.convertClassToResourcePath((String)fqn));
                continue block4;
            }
        }
        for (String changedClass : changedClasses.values()) {
            result.registerChanges(changedClass, new ResourceChangeSet(changedClass, ChangeType.UPDATED));
        }
        if (original.getKieModuleModel() != null) {
            for (String kieBaseName : original.getKieModuleModel().getKieBaseModels().keySet()) {
                KnowledgeBuilder originalKbuilder = original.getKnowledgeBuilderForKieBase(kieBaseName);
                if (originalKbuilder == null || currentJar.getKnowledgeBuilderForKieBase(kieBaseName) != null) continue;
                currentJar.cacheKnowledgeBuilderForKieBase(kieBaseName, originalKbuilder);
            }
        }
        return result;
    }

    private static ResourceChangeSet diffResource(String file, byte[] originalBytes, byte[] currentBytes, List<TypeDeclarationDescr> typeDeclarations) {
        ResourceChangeSet pkgcs = new ResourceChangeSet(file, ChangeType.UPDATED);
        ResourceType type = ResourceType.determineResourceType((String)file);
        if (ResourceType.DRL.equals((Object)type) || ResourceType.GDRL.equals((Object)type) || ResourceType.RDRL.equals((Object)type) || ResourceType.TDRL.equals((Object)type)) {
            try {
                String oldPkgName;
                PackageDescr originalPkg = new DrlParser().parse((Resource)new ByteArrayResource(originalBytes));
                PackageDescr currentPkg = new DrlParser().parse((Resource)new ByteArrayResource(currentBytes));
                String pkgName = StringUtils.isEmpty((CharSequence)currentPkg.getName()) ? ChangeSetBuilder.getDefaultPackageName() : currentPkg.getName();
                String string = oldPkgName = StringUtils.isEmpty((CharSequence)originalPkg.getName()) ? ChangeSetBuilder.getDefaultPackageName() : originalPkg.getName();
                if (!oldPkgName.equals(pkgName)) {
                    return pkgcs;
                }
                pkgcs.setPackageName(pkgName);
                for (RuleDescr crd : currentPkg.getRules()) {
                    pkgcs.getLoadOrder().add(new ResourceChangeSet.RuleLoadOrder(pkgName, crd.getName(), crd.getLoadOrder()));
                }
                ArrayList orules = new ArrayList(originalPkg.getRules());
                ChangeSetBuilder.diffDescrs(originalBytes, currentBytes, pkgcs, orules, currentPkg.getRules(), ResourceChange.Type.RULE, RULE_CONVERTER);
                ArrayList ofuncs = new ArrayList(originalPkg.getFunctions());
                ChangeSetBuilder.diffDescrs(originalBytes, currentBytes, pkgcs, ofuncs, currentPkg.getFunctions(), ResourceChange.Type.FUNCTION, FUNC_CONVERTER);
                ArrayList oglobals = new ArrayList(originalPkg.getGlobals());
                ChangeSetBuilder.diffDescrs(originalBytes, currentBytes, pkgcs, oglobals, currentPkg.getGlobals(), ResourceChange.Type.GLOBAL, GLOBAL_CONVERTER);
                for (TypeDeclarationDescr typeDeclaration : currentPkg.getTypeDeclarations()) {
                    if (StringUtils.isEmpty((CharSequence)typeDeclaration.getNamespace())) {
                        typeDeclaration.setNamespace(StringUtils.isEmpty((CharSequence)currentPkg.getNamespace()) ? "defaultpkg" : currentPkg.getNamespace());
                    }
                    typeDeclarations.add(typeDeclaration);
                }
            }
            catch (Exception e) {
                logger.error("Error analyzing the contents of " + file + ". Skipping.", (Throwable)e);
            }
        }
        pkgcs.getChanges().sort(Comparator.comparingInt(r -> r.getChangeType().ordinal()));
        return pkgcs;
    }

    private static <T extends BaseDescr> void diffDescrs(byte[] ob, byte[] cb, ResourceChangeSet pkgcs, List<T> odescrs, List<T> cdescrs, ResourceChange.Type type, DescrNameConverter<T> descrNameConverter) {
        HashSet<String> updatedRules = null;
        if (type == ResourceChange.Type.RULE) {
            updatedRules = new HashSet<String>();
            cdescrs.sort(RULE_HIERARCHY_COMPARATOR);
        }
        for (BaseDescr crd : cdescrs) {
            String cName = descrNameConverter.getName(crd);
            boolean found = false;
            Iterator<T> it = odescrs.iterator();
            while (it.hasNext()) {
                BaseDescr ord = (BaseDescr)it.next();
                if (!descrNameConverter.getName(ord).equals(cName)) continue;
                found = true;
                it.remove();
                if (StringUtils.codeAwareEqualsIgnoreSpaces((String)new String(Arrays.copyOfRange(ob, ord.getStartCharacter(), ord.getEndCharacter())), (String)new String(Arrays.copyOfRange(cb, crd.getStartCharacter(), crd.getEndCharacter()))) && (type != ResourceChange.Type.RULE || !updatedRules.contains(((RuleDescr)crd).getParentName()))) break;
                pkgcs.getChanges().add(new ResourceChange(ChangeType.UPDATED, type, cName));
                if (type != ResourceChange.Type.RULE) break;
                updatedRules.add(cName);
                break;
            }
            if (found) continue;
            pkgcs.getChanges().add(new ResourceChange(ChangeType.ADDED, type, cName));
        }
        for (BaseDescr ord : odescrs) {
            pkgcs.getChanges().add(new ResourceChange(ChangeType.REMOVED, type, descrNameConverter.getName(ord)));
        }
    }

    private static String getDefaultPackageName() {
        if (defaultPackageName == null) {
            KnowledgeBuilderConfiguration conf = new KnowledgeBuilderFactoryServiceImpl().newKnowledgeBuilderConfiguration();
            defaultPackageName = ((DefaultPackageNameOption)conf.getOption(DefaultPackageNameOption.KEY)).packageName();
        }
        return defaultPackageName;
    }

    static {
        RULE_CONVERTER = new RuleDescrNameConverter();
        FUNC_CONVERTER = new FuncDescrNameConverter();
        GLOBAL_CONVERTER = new GlobalDescrNameConverter();
        RULE_HIERARCHY_COMPARATOR = new RuleHierarchyComparator();
    }

    private static class RuleDescrNameConverter
    implements DescrNameConverter<RuleDescr> {
        private RuleDescrNameConverter() {
        }

        @Override
        public String getName(RuleDescr descr) {
            return descr.getName();
        }
    }

    private static interface DescrNameConverter<T extends BaseDescr> {
        public String getName(T var1);
    }

    private static class FuncDescrNameConverter
    implements DescrNameConverter<FunctionDescr> {
        private FuncDescrNameConverter() {
        }

        @Override
        public String getName(FunctionDescr descr) {
            return descr.getName();
        }
    }

    private static class GlobalDescrNameConverter
    implements DescrNameConverter<GlobalDescr> {
        private GlobalDescrNameConverter() {
        }

        @Override
        public String getName(GlobalDescr descr) {
            return descr.getIdentifier();
        }
    }

    private static class RuleHierarchyComparator
    implements Comparator<RuleDescr> {
        private RuleHierarchyComparator() {
        }

        @Override
        public int compare(RuleDescr r1, RuleDescr r2) {
            return r1.getName().equals(r2.getParentName()) ? -1 : (r2.getName().equals(r1.getParentName()) ? 1 : 0);
        }
    }
}

