/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands.runtime.rule;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.common.InternalFactHandle;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.RegistryContext;

@XmlAccessorType(value=XmlAccessType.NONE)
public class GetFactHandlesCommand
implements ExecutableCommand<Collection<FactHandle>> {
    private transient ObjectFilter filter = null;
    @XmlAttribute
    private boolean disconnected = false;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    public GetFactHandlesCommand() {
    }

    public GetFactHandlesCommand(ObjectFilter filter) {
        this.filter = filter;
    }

    public GetFactHandlesCommand(ObjectFilter filter, boolean disconnected) {
        this.filter = filter;
        this.disconnected = disconnected;
    }

    public GetFactHandlesCommand(boolean disconnected) {
        this.disconnected = disconnected;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public void setDisconnected(boolean disconnected) {
        this.disconnected = disconnected;
    }

    public Collection<FactHandle> execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        ArrayList<FactHandle> disconnectedFactHandles = new ArrayList<FactHandle>();
        if (this.filter != null) {
            Collection factHandles = ksession.getFactHandles(this.filter);
            if (factHandles != null && this.disconnected) {
                for (InternalFactHandle factHandle : factHandles) {
                    InternalFactHandle handle = factHandle.clone();
                    handle.disconnect();
                    disconnectedFactHandles.add((FactHandle)handle);
                }
                if (this.outIdentifier != null) {
                    ((ExecutionResults)((RegistryContext)context).lookup(ExecutionResults.class)).setResult(this.outIdentifier, disconnectedFactHandles);
                }
                return disconnectedFactHandles;
            }
            Collection ksessionFactHandles = ksession.getFactHandles(this.filter);
            if (this.outIdentifier != null) {
                ((ExecutionResults)((RegistryContext)context).lookup(ExecutionResults.class)).setResult(this.outIdentifier, new ArrayList(ksessionFactHandles));
            }
            return ksessionFactHandles;
        }
        Collection factHandles = ksession.getFactHandles();
        if (factHandles != null && this.disconnected) {
            for (InternalFactHandle factHandle : factHandles) {
                InternalFactHandle handle = factHandle.clone();
                handle.disconnect();
                disconnectedFactHandles.add((FactHandle)handle);
            }
            if (this.outIdentifier != null) {
                ((ExecutionResults)((RegistryContext)context).lookup(ExecutionResults.class)).setResult(this.outIdentifier, disconnectedFactHandles);
            }
            return disconnectedFactHandles;
        }
        Collection ksessionFactHandles = ksession.getFactHandles();
        if (this.outIdentifier != null) {
            ((ExecutionResults)((RegistryContext)context).lookup(ExecutionResults.class)).setResult(this.outIdentifier, new ArrayList(ksessionFactHandles));
        }
        return ksessionFactHandles;
    }

    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public String toString() {
        if (this.filter != null) {
            return "new ObjectStoreWrapper( reteooStatefulSession.getObjectStore(), null, ObjectStoreWrapper.FACT_HANDLE )";
        }
        return "new ObjectStoreWrapper( reteooStatefulSession.getObjectStore(), filter, ObjectStoreWrapper.FACT_HANDLE )";
    }
}

