/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands.runtime.rule;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.commands.IdentifiableResult;
import org.drools.core.ClassObjectSerializationFilter;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.command.RegistryContext;

@XmlAccessorType(value=XmlAccessType.NONE)
public class GetObjectsCommand
implements ExecutableCommand<Collection>,
IdentifiableResult {
    @XmlElement(name="class-object-filter", required=false)
    private ClassObjectSerializationFilter classObjectFilter = null;
    private transient ObjectFilter filter = null;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public GetObjectsCommand() {
    }

    public GetObjectsCommand(ObjectFilter filter) {
        this.setFilter(filter);
    }

    public GetObjectsCommand(ObjectFilter filter, String outIdentifier) {
        this.setFilter(filter);
        this.outIdentifier = outIdentifier;
    }

    public void setFilter(ObjectFilter filter) {
        this.filter = filter;
        if (filter instanceof ClassObjectFilter) {
            this.classObjectFilter = new ClassObjectSerializationFilter((ClassObjectFilter)filter);
        }
    }

    public ObjectFilter getFilter() {
        if (this.filter == null) {
            this.filter = this.classObjectFilter;
        }
        return this.filter;
    }

    public Collection execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        Collection col = this.getFilter() != null ? ksession.getObjects(this.filter) : ksession.getObjects();
        if (this.outIdentifier != null) {
            ArrayList objects = new ArrayList(col);
            ((ExecutionResults)((RegistryContext)context).lookup(ExecutionResults.class)).setResult(this.outIdentifier, objects);
        }
        return col;
    }

    public String toString() {
        if (this.getFilter() != null) {
            return "session.iterateObjects( " + this.filter + " );";
        }
        return "session.iterateObjects();";
    }
}

