/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import org.drools.core.time.TimerService;
import org.drools.core.time.impl.JDKTimerService;
import org.drools.core.time.impl.PseudoClockScheduler;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ClockType {
    REALTIME_CLOCK("realtime"){

        @Override
        public JDKTimerService createInstance() {
            return new JDKTimerService();
        }
    }
    ,
    PSEUDO_CLOCK("pseudo"){

        @Override
        public PseudoClockScheduler createInstance() {
            return new PseudoClockScheduler();
        }
    };

    private String string;

    public abstract TimerService createInstance();

    private ClockType(String string2) {
        this.string = string2;
    }

    public String toExternalForm() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    public String getId() {
        return this.string;
    }

    public static ClockType resolveClockType(String id) {
        if (PSEUDO_CLOCK.getId().equalsIgnoreCase(id)) {
            return PSEUDO_CLOCK;
        }
        if (REALTIME_CLOCK.getId().equalsIgnoreCase(id)) {
            return REALTIME_CLOCK;
        }
        throw new IllegalArgumentException("Illegal enum value '" + id + "' for ClockType");
    }
}

