/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.List;
import org.drools.base.common.NetworkNode;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.core.base.DroolsQueryImpl;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.Memory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.common.TupleSetsImpl;
import org.drools.core.phreak.BuildtimeSegmentUtilities;
import org.drools.core.phreak.PhreakAccumulateNode;
import org.drools.core.phreak.PhreakAsyncReceiveNode;
import org.drools.core.phreak.PhreakAsyncSendNode;
import org.drools.core.phreak.PhreakBranchNode;
import org.drools.core.phreak.PhreakEvalNode;
import org.drools.core.phreak.PhreakExistsNode;
import org.drools.core.phreak.PhreakFromNode;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.phreak.PhreakNetworkNodeFactory;
import org.drools.core.phreak.PhreakNotNode;
import org.drools.core.phreak.PhreakQueryNode;
import org.drools.core.phreak.PhreakQueryTerminalNode;
import org.drools.core.phreak.PhreakReactiveFromNode;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.RuntimeSegmentUtilities;
import org.drools.core.phreak.SegmentPropagator;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.AsyncSendNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.reteoo.TupleFactory;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleNetworkEvaluator {
    private static final Logger log = LoggerFactory.getLogger(RuleNetworkEvaluator.class);
    public static final RuleNetworkEvaluator INSTANCE = new RuleNetworkEvaluator();
    private static final PhreakJoinNode pJoinNode = PhreakNetworkNodeFactory.Factory.get().createPhreakJoinNode();
    private static final PhreakEvalNode pEvalNode = PhreakNetworkNodeFactory.Factory.get().createPhreakEvalNode();
    private static final PhreakFromNode pFromNode = PhreakNetworkNodeFactory.Factory.get().createPhreakFromNode();
    private static final PhreakReactiveFromNode pReactiveFromNode = PhreakNetworkNodeFactory.Factory.get().createPhreakReactiveFromNode();
    private static final PhreakNotNode pNotNode = PhreakNetworkNodeFactory.Factory.get().createPhreakNotNode();
    private static final PhreakExistsNode pExistsNode = PhreakNetworkNodeFactory.Factory.get().createPhreakExistsNode();
    private static final PhreakAccumulateNode pAccNode = PhreakNetworkNodeFactory.Factory.get().createPhreakAccumulateNode();
    private static final PhreakAccumulateNode pGroupByNode = PhreakNetworkNodeFactory.Factory.get().createPhreakGroupByNode();
    private static final PhreakBranchNode pBranchNode = PhreakNetworkNodeFactory.Factory.get().createPhreakBranchNode();
    private static final PhreakQueryNode pQueryNode = PhreakNetworkNodeFactory.Factory.get().createPhreakQueryNode();
    private static final PhreakTimerNode pTimerNode = PhreakNetworkNodeFactory.Factory.get().createPhreakTimerNode();
    private static final PhreakAsyncSendNode pSendNode = PhreakNetworkNodeFactory.Factory.get().createPhreakAsyncSendNode();
    private static final PhreakAsyncReceiveNode pReceiveNode = PhreakNetworkNodeFactory.Factory.get().createPhreakAsyncReceiveNode();
    private static final PhreakRuleTerminalNode pRtNode = PhreakNetworkNodeFactory.Factory.get().createPhreakRuleTerminalNode();
    private static final PhreakQueryTerminalNode pQtNode = PhreakNetworkNodeFactory.Factory.get().createPhreakQueryTerminalNode();
    private static int cycle = 0;

    private RuleNetworkEvaluator() {
    }

    public void evaluateNetwork(PathMemory pmem, RuleExecutor executor, ReteEvaluator reteEvaluator) {
        this.evaluateNetwork(pmem, executor, pmem.getActualActivationsManager(reteEvaluator));
    }

    public void evaluateNetwork(PathMemory pmem, RuleExecutor executor, ActivationsManager activationsManager) {
        Memory nodeMem;
        LeftTupleNode node;
        boolean firstSegmentIsOnlyLia;
        SegmentMemory[] smems = pmem.getSegmentMemories();
        SegmentMemory smem = smems[0];
        if (smem == null) {
            return;
        }
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)smem.getRootNode();
        LinkedList<StackEntry> stack = new LinkedList<StackEntry>();
        boolean bl = firstSegmentIsOnlyLia = liaNode == smem.getTipNode();
        if (firstSegmentIsOnlyLia) {
            smem = smems[1];
            node = smem.getRootNode();
            nodeMem = smem.getNodeMemories()[0];
        } else {
            node = liaNode.getSinkPropagator().getFirstLeftTupleSink();
            nodeMem = smem.getNodeMemories()[1];
        }
        TupleSets srcTuples = smem.getStagedLeftTuples();
        if (log.isTraceEnabled()) {
            log.trace("Rule[name={}] segments={} {}", new Object[]{((TerminalNode)pmem.getPathEndNode()).getRule().getName(), smems.length, srcTuples.toStringSizes()});
        }
        this.outerEval(pmem, node, firstSegmentIsOnlyLia ? 1L : 2L, nodeMem, smems, firstSegmentIsOnlyLia ? 1 : 0, srcTuples, activationsManager, stack, true, executor);
    }

    public static String indent(int size) {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sbuilder.append("  ");
        }
        return sbuilder.toString();
    }

    public static int getOffset(NetworkNode node) {
        LeftTupleSource lt;
        int offset = 1;
        if (NodeTypeEnums.isTerminalNode((NetworkNode)node)) {
            lt = ((TerminalNode)node).getLeftTupleSource();
            ++offset;
        } else {
            lt = node.getType() == 5244209 ? ((RightInputAdapterNode)node).getLeftTupleSource() : (LeftTupleSource)node;
        }
        while (!NodeTypeEnums.isLeftInputAdapterNode((NetworkNode)lt)) {
            ++offset;
            lt = lt.getLeftTupleSource();
        }
        return offset;
    }

    public void outerEval(PathMemory pmem, NetworkNode node, long bit, Memory nodeMem, SegmentMemory[] smems, int smemIndex, TupleSets trgTuples, ActivationsManager activationsManager, LinkedList<StackEntry> stack, boolean processRian, RuleExecutor executor) {
        this.innerEval(pmem, node, bit, nodeMem, smems, smemIndex, trgTuples, activationsManager, stack, processRian, executor);
        while (!stack.isEmpty()) {
            StackEntry entry = stack.removeLast();
            this.evalStackEntry(entry, stack, executor, activationsManager);
        }
    }

    public void evalStackEntry(StackEntry entry, LinkedList<StackEntry> stack, RuleExecutor executor, ActivationsManager activationsManager) {
        NetworkNode node = entry.getNode();
        Memory nodeMem = entry.getNodeMem();
        TupleSets trgTuples = entry.getTrgTuples();
        if (node.getType() == 9831476) {
            QueryElementNode.QueryElementNodeMemory qmem = (QueryElementNode.QueryElementNodeMemory)nodeMem;
            qmem.setNodeCleanWithoutNotify();
            qmem.getResultLeftTuples().addTo(trgTuples);
        }
        LeftTupleSinkNode sink = entry.getSink();
        PathMemory pmem = entry.getRmem();
        SegmentMemory[] smems = entry.getSmems();
        int smemIndex = entry.getSmemIndex();
        boolean processRian = entry.isProcessRian();
        long bit = entry.getBit();
        if (entry.isResumeFromNextNode()) {
            SegmentMemory smem = smems[smemIndex];
            if (node != smem.getTipNode()) {
                LeftTupleSinkNode nextSink = sink.getNextLeftTupleSinkNode();
                node = nextSink == null ? sink : nextSink;
                nodeMem = (Memory)nodeMem.getNext();
                bit = BuildtimeSegmentUtilities.nextNodePosMask(bit);
            } else {
                SegmentPropagator.propagate(smem, trgTuples, activationsManager.getReteEvaluator());
                smem = smems[++smemIndex];
                trgTuples = smem.getStagedLeftTuples().takeAll();
                node = smem.getRootNode();
                nodeMem = smem.getNodeMemories()[0];
                bit = 1L;
            }
        }
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(node);
            log.trace("{} Resume {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), node.toString(), trgTuples.toStringSizes()});
        }
        this.innerEval(pmem, node, bit, nodeMem, smems, smemIndex, trgTuples, activationsManager, stack, processRian, executor);
    }

    public void innerEval(PathMemory pmem, NetworkNode node, long bit, Memory nodeMem, SegmentMemory[] smems, int smemIndex, TupleSets trgTuples, ActivationsManager activationsManager, LinkedList<StackEntry> stack, boolean processRian, RuleExecutor executor) {
        SegmentMemory smem = smems[smemIndex];
        TupleSets stagedLeftTuples = null;
        while (true) {
            LeftTupleSinkNode sink;
            TupleSets srcTuples = trgTuples;
            if (log.isTraceEnabled()) {
                int offset = RuleNetworkEvaluator.getOffset(node);
                log.trace("{} {} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), ++cycle, node.toString(), srcTuples.toStringSizes()});
            }
            boolean emptySrcTuples = srcTuples.isEmpty();
            if (!NodeTypeEnums.isBetaNode((NetworkNode)node) || !node.isRightInputIsRiaNode()) {
                if (emptySrcTuples && smem.getDirtyNodeMask() == 0L) {
                    boolean foundDirty = false;
                    int length = smems.length;
                    for (int i = ++smemIndex; i < length; ++i) {
                        if (log.isTraceEnabled()) {
                            int offset = RuleNetworkEvaluator.getOffset(node);
                            log.trace("{} Skip Segment {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)(i - 1));
                        }
                        if (smem.isEmpty() && !NodeTypeEnums.isTerminalNode((NetworkNode)smem.getTipNode())) {
                            RuntimeSegmentUtilities.createChildSegments(activationsManager.getReteEvaluator(), smem, smem.getTipNode().getSinkPropagator());
                        }
                        smem = smems[i];
                        bit = 1L;
                        srcTuples = smem.getStagedLeftTuples().takeAll();
                        emptySrcTuples = srcTuples.isEmpty();
                        node = smem.getRootNode();
                        nodeMem = smem.getNodeMemories()[0];
                        if (emptySrcTuples && smem.getDirtyNodeMask() == 0L && (!NodeTypeEnums.isBetaNode((NetworkNode)node) || !((BetaNode)node).isRightInputIsRiaNode())) continue;
                        foundDirty = true;
                        smemIndex = i;
                        break;
                    }
                    if (!foundDirty) break;
                }
                if (log.isTraceEnabled()) {
                    int offset = RuleNetworkEvaluator.getOffset(node);
                    log.trace("{} Segment {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)smemIndex);
                    log.trace("{} {} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), cycle, node.toString(), srcTuples.toStringSizes()});
                }
            }
            long dirtyMask = smem.getDirtyNodeMask();
            if (emptySrcTuples) {
                while (!((dirtyMask & bit) != 0L || node == smem.getTipNode() || NodeTypeEnums.isBetaNode((NetworkNode)node) && ((BetaNode)node).isRightInputIsRiaNode())) {
                    if (log.isTraceEnabled()) {
                        int offset = RuleNetworkEvaluator.getOffset(node);
                        log.trace("{} Skip Node {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)node);
                    }
                    bit = BuildtimeSegmentUtilities.nextNodePosMask(bit);
                    node = ((LeftTupleSource)node).getSinkPropagator().getFirstLeftTupleSink();
                    nodeMem = (Memory)nodeMem.getNext();
                }
            }
            boolean terminalNode = true;
            switch (node.getType()) {
                case 5899696: {
                    pRtNode.doNode((AbstractTerminalNode)node, activationsManager, srcTuples, executor);
                    break;
                }
                case 6227376: {
                    pQtNode.doNode((QueryTerminalNode)node, activationsManager, srcTuples, stack);
                    break;
                }
                case 5244209: {
                    this.doRiaNode2(activationsManager.getReteEvaluator(), srcTuples, (RightInputAdapterNode)node);
                    break;
                }
                default: {
                    terminalNode = false;
                }
            }
            if (terminalNode || (trgTuples = this.evalNode(pmem, node, bit, nodeMem, smems, smemIndex, activationsManager, stack, processRian, executor, srcTuples, smem, stagedLeftTuples = RuleNetworkEvaluator.getTargetStagedLeftTuples(node, activationsManager.getReteEvaluator(), smem), sink = ((LeftTupleSource)node).getSinkPropagator().getFirstLeftTupleSink())) == null) break;
            if (node != smem.getTipNode()) {
                node = sink;
                nodeMem = (Memory)nodeMem.getNext();
                bit = BuildtimeSegmentUtilities.nextNodePosMask(bit);
            } else {
                ((SegmentMemory)smem.getFirst()).getStagedLeftTuples().addAll(stagedLeftTuples);
                SegmentPropagator.propagate(smem, trgTuples, activationsManager.getReteEvaluator());
                bit = 1L;
                smem = smems[++smemIndex];
                trgTuples = smem.getStagedLeftTuples().takeAll();
                if (log.isTraceEnabled()) {
                    int offset = RuleNetworkEvaluator.getOffset(node);
                    log.trace("{} Segment {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)smemIndex);
                }
                node = smem.getRootNode();
                nodeMem = smem.getNodeMemories()[0];
            }
            processRian = true;
        }
        if (stagedLeftTuples != null && !stagedLeftTuples.isEmpty()) {
            ((SegmentMemory)smem.getFirst()).getStagedLeftTuples().addAll(stagedLeftTuples);
        }
    }

    public TupleSets evalNode(PathMemory pmem, NetworkNode node, long bit, Memory nodeMem, SegmentMemory[] smems, int smemIndex, ActivationsManager activationsManager, LinkedList<StackEntry> stack, boolean processRian, RuleExecutor executor, TupleSets srcTuples, SegmentMemory smem, TupleSets stagedLeftTuples, LeftTupleSinkNode sink) {
        TupleSetsImpl trgTuples = new TupleSetsImpl();
        if (NodeTypeEnums.isBetaNode((NetworkNode)node)) {
            boolean exitInnerEval = this.evalBetaNode(pmem, node, nodeMem, smems, smemIndex, trgTuples, activationsManager, stack, processRian, executor, srcTuples, stagedLeftTuples, sink);
            if (exitInnerEval) {
                return null;
            }
        } else {
            boolean exitInnerEval = false;
            switch (node.getType()) {
                case 7537716: {
                    pEvalNode.doNode((EvalConditionNode)node, (EvalConditionNode.EvalMemory)nodeMem, sink, activationsManager.getReteEvaluator(), srcTuples, trgTuples, stagedLeftTuples);
                    break;
                }
                case 8848436: {
                    pFromNode.doNode((FromNode)node, (FromNode.FromMemory)nodeMem, sink, activationsManager.getReteEvaluator(), srcTuples, trgTuples, stagedLeftTuples);
                    break;
                }
                case 9176116: {
                    pReactiveFromNode.doNode((ReactiveFromNode)node, (ReactiveFromNode.ReactiveFromMemory)nodeMem, (LeftTupleSink)sink, activationsManager.getReteEvaluator(), srcTuples, (TupleSets)trgTuples, stagedLeftTuples);
                    break;
                }
                case 9831476: {
                    exitInnerEval = this.evalQueryNode(pmem, node, bit, nodeMem, smems, smemIndex, trgTuples, activationsManager.getReteEvaluator(), stack, srcTuples, sink, stagedLeftTuples);
                    break;
                }
                case 7865396: {
                    pTimerNode.doNode((TimerNode)node, (TimerNode.TimerNodeMemory)nodeMem, pmem, smem, sink, activationsManager, srcTuples, trgTuples, stagedLeftTuples);
                    break;
                }
                case 10159156: {
                    pBranchNode.doNode((ConditionalBranchNode)node, (ConditionalBranchNode.ConditionalBranchMemory)nodeMem, sink, activationsManager, srcTuples, trgTuples, stagedLeftTuples, executor);
                    break;
                }
                case 8193076: {
                    pSendNode.doNode((AsyncSendNode)node, (AsyncSendNode.AsyncSendMemory)nodeMem, activationsManager.getReteEvaluator(), srcTuples);
                    break;
                }
                case 8520756: {
                    pReceiveNode.doNode((AsyncReceiveNode)node, (AsyncReceiveNode.AsyncReceiveMemory)nodeMem, sink, activationsManager.getReteEvaluator(), srcTuples, trgTuples);
                }
            }
            if (exitInnerEval && trgTuples.isEmpty()) {
                return null;
            }
        }
        return trgTuples;
    }

    private static TupleSets getTargetStagedLeftTuples(NetworkNode node, ReteEvaluator reteEvaluator, SegmentMemory smem) {
        if (node == smem.getTipNode()) {
            if (smem.isEmpty()) {
                RuntimeSegmentUtilities.createChildSegments(reteEvaluator, smem, ((LeftTupleSource)node).getSinkPropagator());
            }
            return ((SegmentMemory)smem.getFirst()).getStagedLeftTuples().takeAll();
        }
        return null;
    }

    private boolean evalQueryNode(PathMemory pmem, NetworkNode node, long bit, Memory nodeMem, SegmentMemory[] smems, int smemIndex, TupleSets trgTuples, ReteEvaluator reteEvaluator, LinkedList<StackEntry> stack, TupleSets srcTuples, LeftTupleSinkNode sink, TupleSets stagedLeftTuples) {
        QueryElementNode.QueryElementNodeMemory qmem = (QueryElementNode.QueryElementNodeMemory)nodeMem;
        if (srcTuples.isEmpty() && qmem.getResultLeftTuples().isEmpty()) {
            return false;
        }
        QueryElementNode qnode = (QueryElementNode)node;
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(node);
            log.trace("{} query result tuples {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)qmem.getResultLeftTuples().toStringSizes());
        }
        qmem.getResultLeftTuples().addTo(trgTuples);
        qmem.setNodeCleanWithoutNotify();
        if (!srcTuples.isEmpty()) {
            StackEntry stackEntry = new StackEntry(node, bit, sink, pmem, nodeMem, smems, smemIndex, trgTuples, true, true);
            stack.add(stackEntry);
            pQueryNode.doNode(qnode, (QueryElementNode.QueryElementNodeMemory)nodeMem, stackEntry, reteEvaluator, srcTuples, trgTuples, stagedLeftTuples);
            SegmentMemory qsmem = ((QueryElementNode.QueryElementNodeMemory)nodeMem).getQuerySegmentMemory();
            List<PathMemory> qpmems = qsmem.getPathMemories();
            for (int i = 0; i < qpmems.size(); ++i) {
                PathMemory qpmem;
                pmem = qpmem = qpmems.get(i);
                smems = qpmem.getSegmentMemories();
                smemIndex = 0;
                SegmentMemory smem = smems[smemIndex];
                LeftTupleNode liaNode = qpmem.getPathEndNode().getPathNodes()[0];
                if (liaNode == smem.getTipNode()) {
                    smem = smems[++smemIndex];
                    node = smem.getRootNode();
                    nodeMem = smem.getNodeMemories()[0];
                    bit = 1L;
                } else {
                    node = liaNode.getSinkPropagator().getFirstLeftTupleSink();
                    nodeMem = smem.getNodeMemories()[1];
                    bit = 2L;
                }
                trgTuples = smem.getStagedLeftTuples().takeAll();
                stackEntry = new StackEntry(node, bit, null, pmem, nodeMem, smems, smemIndex, trgTuples, false, true);
                if (log.isTraceEnabled()) {
                    int offset = RuleNetworkEvaluator.getOffset(stackEntry.getNode());
                    log.trace("{} ORQueue branch={} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), i, stackEntry.getNode().toString(), trgTuples.toStringSizes()});
                }
                stack.add(stackEntry);
            }
            return true;
        }
        return false;
    }

    private boolean evalBetaNode(PathMemory pmem, NetworkNode node, Memory nodeMem, SegmentMemory[] smems, int smemIndex, TupleSets trgTuples, ActivationsManager activationsManager, LinkedList<StackEntry> stack, boolean processRian, RuleExecutor executor, TupleSets srcTuples, TupleSets stagedLeftTuples, LeftTupleSinkNode sink) {
        BetaMemory bm;
        BetaNode betaNode = (BetaNode)node;
        AccumulateNode.AccumulateMemory am = null;
        if (11798068 == node.getType()) {
            am = (AccumulateNode.AccumulateMemory)nodeMem;
            bm = am.getBetaMemory();
        } else {
            bm = (BetaMemory)nodeMem;
        }
        if (processRian && betaNode.isRightInputIsRiaNode()) {
            this.doRiaNode(activationsManager, pmem, srcTuples, betaNode, sink, smems, smemIndex, nodeMem, bm, stack, executor);
            return true;
        }
        this.switchOnDoBetaNode(node, trgTuples, activationsManager.getReteEvaluator(), srcTuples, stagedLeftTuples, sink, bm, am);
        return false;
    }

    private void switchOnDoBetaNode(NetworkNode node, TupleSets trgTuples, ReteEvaluator reteEvaluator, TupleSets srcTuples, TupleSets stagedLeftTuples, LeftTupleSinkNode sink, BetaMemory bm, AccumulateNode.AccumulateMemory am) {
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(node);
            log.trace("{} rightTuples {}", (Object)RuleNetworkEvaluator.indent(offset), (Object)bm.getStagedRightTuples().toStringSizes());
        }
        switch (node.getType()) {
            case 10815028: {
                pJoinNode.doNode((JoinNode)node, sink, bm, reteEvaluator, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
            case 11142708: {
                pNotNode.doNode((NotNode)node, sink, bm, reteEvaluator, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
            case 11470388: {
                pExistsNode.doNode((ExistsNode)node, sink, bm, reteEvaluator, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
            case 11798068: {
                AccumulateNode accumulateNode = (AccumulateNode)node;
                if (accumulateNode.getAccumulate().isGroupBy()) {
                    pGroupByNode.doNode(accumulateNode, sink, am, reteEvaluator, srcTuples, trgTuples, stagedLeftTuples);
                    break;
                }
                pAccNode.doNode(accumulateNode, sink, am, reteEvaluator, srcTuples, trgTuples, stagedLeftTuples);
                break;
            }
        }
    }

    private void doRiaNode(ActivationsManager activationsManager, PathMemory pmem, TupleSets srcTuples, BetaNode betaNode, LeftTupleSinkNode sink, SegmentMemory[] smems, int smemIndex, Memory nodeMem, BetaMemory bm, LinkedList<StackEntry> stack, RuleExecutor executor) {
        RightInputAdapterNode.RiaPathMemory pathMem = bm.getRiaRuleMemory();
        SegmentMemory[] subnetworkSmems = pathMem.getSegmentMemories();
        SegmentMemory subSmem = null;
        int i = 0;
        while (subSmem == null) {
            subSmem = subnetworkSmems[i];
            ++i;
        }
        StackEntry stackEntry = new StackEntry(betaNode, bm.getNodePosMaskBit(), sink, pmem, nodeMem, smems, smemIndex, srcTuples, false, false);
        stack.add(stackEntry);
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(betaNode);
            log.trace("{} RiaQueue {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), betaNode.toString(), srcTuples.toStringSizes()});
        }
        TupleSets subLts = subSmem.getStagedLeftTuples().takeAll();
        this.innerEval(pathMem, subSmem.getRootNode(), 1L, subSmem.getNodeMemories()[0], subnetworkSmems, subSmem.getPos(), subLts, activationsManager, stack, true, executor);
    }

    private void doRiaNode2(ReteEvaluator reteEvaluator, TupleSets srcTuples, RightInputAdapterNode riaNode) {
        int i;
        SubnetworkTuple next;
        ObjectSink[] sinks = riaNode.getObjectSinkPropagator().getSinks();
        BetaNode betaNode = (BetaNode)sinks[0];
        Object nodeMem = reteEvaluator.getNodeMemory(betaNode);
        BetaMemory bm = 11798068 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)nodeMem).getBetaMemory() : (BetaMemory)nodeMem;
        TupleSets rightTuples = bm.getStagedRightTuples();
        BetaNode[] bns = null;
        BetaMemory[] bms = null;
        int length = sinks.length;
        if (length > 1) {
            bns = new BetaNode[sinks.length - 1];
            bms = new BetaMemory[sinks.length - 1];
            for (int i2 = 1; i2 < length; ++i2) {
                bns[i2 - 1] = (BetaNode)sinks[i2];
                Object nodeMem2 = reteEvaluator.getNodeMemory(bns[i2 - 1]);
                bms[i2 - 1] = 11798068 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)nodeMem2).getBetaMemory() : (BetaMemory)nodeMem2;
            }
        }
        --length;
        SubnetworkTuple subnetworkTuple = (SubnetworkTuple)srcTuples.getInsertFirst();
        while (subnetworkTuple != null) {
            next = (SubnetworkTuple)subnetworkTuple.getStagedNext();
            if (bm.getStagedRightTuples().isEmpty()) {
                bm.setNodeDirtyWithoutNotify();
            }
            subnetworkTuple.prepareStagingOnRight();
            rightTuples.addInsert(subnetworkTuple);
            if (bns != null) {
                for (i = 0; i < length; ++i) {
                    if (bms[i].getStagedRightTuples().isEmpty()) {
                        bms[i].setNodeDirtyWithoutNotify();
                    }
                    subnetworkTuple = (SubnetworkTuple)TupleFactory.createPeer(riaNode, subnetworkTuple);
                    bms[i].getStagedRightTuples().addInsert(subnetworkTuple);
                }
            }
            subnetworkTuple = next;
        }
        subnetworkTuple = (SubnetworkTuple)srcTuples.getDeleteFirst();
        while (subnetworkTuple != null) {
            next = (SubnetworkTuple)subnetworkTuple.getStagedNext();
            if (rightTuples.isEmpty()) {
                bm.setNodeDirtyWithoutNotify();
            }
            switch (subnetworkTuple.getStagedTypeOnRight()) {
                case 1: {
                    rightTuples.removeInsert(subnetworkTuple.moveStagingFromLeftToRight());
                    break;
                }
                case 2: {
                    rightTuples.removeUpdate(subnetworkTuple.moveStagingFromLeftToRight());
                }
            }
            subnetworkTuple.prepareStagingOnRight();
            rightTuples.addDelete(subnetworkTuple);
            if (bns != null) {
                for (i = 0; i < length; ++i) {
                    subnetworkTuple = (SubnetworkTuple)subnetworkTuple.getPeer();
                    if (bms[i].getStagedRightTuples().isEmpty()) {
                        bms[i].setNodeDirtyWithoutNotify();
                    }
                    bms[i].getStagedRightTuples().addDelete(subnetworkTuple);
                    subnetworkTuple.setStagedOnRight();
                }
            }
            subnetworkTuple = next;
        }
        subnetworkTuple = (SubnetworkTuple)srcTuples.getUpdateFirst();
        while (subnetworkTuple != null) {
            next = (SubnetworkTuple)subnetworkTuple.getStagedNext();
            if (rightTuples.isEmpty()) {
                bm.setNodeDirtyWithoutNotify();
            }
            subnetworkTuple.prepareStagingOnRight();
            rightTuples.addUpdate(subnetworkTuple);
            if (bns != null) {
                for (i = 0; i < length; ++i) {
                    subnetworkTuple = (SubnetworkTuple)subnetworkTuple.getPeer();
                    if (bms[i].getStagedRightTuples().isEmpty()) {
                        bms[i].setNodeDirtyWithoutNotify();
                    }
                    bms[i].getStagedRightTuples().addUpdate(subnetworkTuple);
                    subnetworkTuple.setStagedOnRight();
                }
            }
            subnetworkTuple = next;
        }
        srcTuples.resetAll();
    }

    public static void findLeftTupleBlocker(BetaNode betaNode, TupleMemory rtm, Object contextEntry, BetaConstraints constraints, TupleImpl leftTuple, boolean useLeftMemory) {
        FastIterator<TupleImpl> it = betaNode.getRightIterator(rtm);
        RightTuple rightTuple = betaNode.getFirstRightTuple(leftTuple, rtm, it);
        while (rightTuple != null) {
            RightTuple nextRight = (RightTuple)it.next(rightTuple);
            if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandleForEvaluation())) {
                leftTuple.setBlocker(rightTuple);
                if (useLeftMemory) {
                    rightTuple.addBlocked((LeftTuple)leftTuple);
                    break;
                }
                if (!betaNode.isRightInputIsRiaNode()) break;
                rtm.remove(rightTuple);
            }
            rightTuple = nextRight;
        }
    }

    public static void unlinkAndDeleteChildLeftTuple(TupleImpl childLeftTuple, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        RuleNetworkEvaluator.deleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
    }

    public static void deleteChildLeftTuple(TupleImpl childLeftTuple, TupleSets trgLeftTuples, TupleSets stagedLeftTuples) {
        if (childLeftTuple.isStagedOnRight()) {
            ((SubnetworkTuple)childLeftTuple).moveStagingFromRightToLeft();
        } else {
            switch (childLeftTuple.getStagedType()) {
                case 1: {
                    stagedLeftTuples.removeInsert(childLeftTuple);
                    trgLeftTuples.addNormalizedDelete(childLeftTuple);
                    return;
                }
                case 2: {
                    stagedLeftTuples.removeUpdate(childLeftTuple);
                }
            }
        }
        trgLeftTuples.addDelete(childLeftTuple);
    }

    public static void doUpdatesReorderLeftMemory(BetaMemory bm, TupleSets srcLeftTuples) {
        TupleImpl leftTuple;
        TupleMemory ltm = bm.getLeftTupleMemory();
        for (leftTuple = srcLeftTuples.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            if (leftTuple.getMemory() == null) continue;
            ltm.remove(leftTuple);
        }
        for (leftTuple = srcLeftTuples.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            ltm.add(leftTuple);
            TupleImpl childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                TupleImpl childNext = childLeftTuple.getHandleNext();
                childLeftTuple.reAddRight();
                childLeftTuple = childNext;
            }
        }
    }

    public static void doUpdatesExistentialReorderLeftMemory(BetaMemory bm, TupleSets srcLeftTuples) {
        TupleImpl leftTuple;
        TupleMemory ltm = bm.getLeftTupleMemory();
        for (leftTuple = srcLeftTuples.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            if (leftTuple.getMemory() == null) continue;
            ltm.remove(leftTuple);
        }
        for (leftTuple = srcLeftTuples.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            RightTuple blocker = leftTuple.getBlocker();
            if (blocker == null) {
                ltm.add(leftTuple);
                TupleImpl childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    TupleImpl childNext = childLeftTuple.getHandleNext();
                    childLeftTuple.reAddRight();
                    childLeftTuple = childNext;
                }
                continue;
            }
            if (blocker.getStagedType() == 0) continue;
            blocker.removeBlocked((LeftTuple)leftTuple);
        }
    }

    public static void doUpdatesReorderRightMemory(BetaMemory bm, TupleSets srcRightTuples) {
        TupleMemory rtm = bm.getRightTupleMemory();
        for (TupleImpl rightTuple = srcRightTuples.getUpdateFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
            if (rightTuple.getMemory() == null) continue;
            rtm.removeAdd(rightTuple);
            RuleNetworkEvaluator.doUpdatesReorderChildLeftTuple(rightTuple);
        }
    }

    public static void doUpdatesReorderChildLeftTuple(TupleImpl rightTuple) {
        TupleImpl childLeftTuple = rightTuple.getFirstChild();
        while (childLeftTuple != null) {
            TupleImpl childNext = childLeftTuple.getRightParentNext();
            childLeftTuple.reAddLeft();
            childLeftTuple = childNext;
        }
    }

    public static void doUpdatesExistentialReorderRightMemory(BetaMemory bm, BetaNode betaNode, TupleSets srcRightTuples) {
        TupleImpl rightTuple;
        boolean resumeFromCurrent;
        TupleMemory rtm = bm.getRightTupleMemory();
        boolean bl = resumeFromCurrent = !betaNode.isIndexedUnificationJoin() && !rtm.getIndexType().isComparison();
        if (rtm.getIndexType() != TupleMemory.IndexType.NONE) {
            for (rightTuple = srcRightTuples.getDeleteFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
                rtm.remove(rightTuple);
            }
        }
        for (rightTuple = srcRightTuples.getUpdateFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
            RuleNetworkEvaluator.doRemoveExistentialRightMemoryForReorder(rtm, resumeFromCurrent, (RightTuple)rightTuple);
        }
        for (rightTuple = srcRightTuples.getUpdateFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
            RuleNetworkEvaluator.doAddExistentialRightMemoryForReorder(rtm, resumeFromCurrent, (RightTuple)rightTuple);
        }
        if (rtm.getIndexType() != TupleMemory.IndexType.NONE) {
            for (rightTuple = srcRightTuples.getDeleteFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
                rtm.add(rightTuple);
            }
        }
    }

    public static void doExistentialUpdatesReorderChildLeftTuple(ReteEvaluator reteEvaluator, NotNode notNode, RightTuple rightTuple) {
        BetaMemory bm = BetaNode.getBetaMemory(notNode, reteEvaluator);
        TupleMemory rtm = bm.getRightTupleMemory();
        boolean resumeFromCurrent = !notNode.isIndexedUnificationJoin() && !rtm.getIndexType().isComparison();
        RuleNetworkEvaluator.doRemoveExistentialRightMemoryForReorder(rtm, resumeFromCurrent, rightTuple);
        RuleNetworkEvaluator.doAddExistentialRightMemoryForReorder(rtm, resumeFromCurrent, rightTuple);
        PhreakNotNode.updateBlockersAndPropagate(notNode, rightTuple, reteEvaluator, rtm, bm.getContext(), notNode.getRawConstraints(), !resumeFromCurrent, null, null, null);
    }

    private static void doAddExistentialRightMemoryForReorder(TupleMemory rtm, boolean resumeFromCurrent, RightTuple rightTuple) {
        rtm.add(rightTuple);
        if (resumeFromCurrent && rightTuple.getBlocked() != null && rightTuple.getTempNextRightTuple() == null) {
            rightTuple.setTempNextRightTuple(rightTuple);
        }
        RuleNetworkEvaluator.doUpdatesReorderChildLeftTuple(rightTuple);
    }

    private static void doRemoveExistentialRightMemoryForReorder(TupleMemory rtm, boolean resumeFromCurrent, RightTuple rightTuple) {
        if (rightTuple.getMemory() != null) {
            if (resumeFromCurrent && rightTuple.getBlocked() != null) {
                RightTuple tempRightTuple;
                for (tempRightTuple = (RightTuple)rightTuple.getNext(); tempRightTuple != null && tempRightTuple.getStagedType() != 0; tempRightTuple = (RightTuple)tempRightTuple.getNext()) {
                }
                if (tempRightTuple == null) {
                    for (tempRightTuple = (RightTuple)rightTuple.getPrevious(); tempRightTuple != null && tempRightTuple.getStagedType() != 0; tempRightTuple = (RightTuple)tempRightTuple.getPrevious()) {
                    }
                }
                rightTuple.setTempNextRightTuple(tempRightTuple);
            }
            rightTuple.setTempBlocked(rightTuple.getBlocked());
            rightTuple.setBlocked(null);
            rtm.remove(rightTuple);
        }
    }

    public static boolean useLeftMemory(LeftTupleSource tupleSource, TupleImpl tuple) {
        Object object;
        boolean useLeftMemory = true;
        if (!(tupleSource.isLeftTupleMemoryEnabled() || (object = tuple.getRootTuple().getFactHandle().getObject()) instanceof DroolsQueryImpl && ((DroolsQueryImpl)object).isOpen())) {
            useLeftMemory = false;
        }
        return useLeftMemory;
    }

    public static void normalizeStagedTuples(TupleSets stagedLeftTuples, TupleImpl childLeftTuple) {
        if (!childLeftTuple.isStagedOnRight()) {
            switch (childLeftTuple.getStagedType()) {
                case 1: {
                    stagedLeftTuples.removeInsert(childLeftTuple);
                    break;
                }
                case 2: {
                    stagedLeftTuples.removeUpdate(childLeftTuple);
                }
            }
        }
    }
}

