/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ValueResolver;
import org.drools.base.rule.EntryPointId;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ObjectTypeNodeId;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.BehaviorContext;
import org.drools.core.rule.BehaviorManager;
import org.drools.core.rule.BehaviorRuntime;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.util.bitmask.BitMask;
import org.kie.api.runtime.rule.FactHandle;

public class WindowNode
extends ObjectSource
implements ObjectSinkNode,
RightTupleSink,
MemoryFactory<WindowMemory> {
    private static final long serialVersionUID = 540L;
    private List<AlphaNodeFieldConstraint> constraints;
    protected BehaviorManager behavior;
    private EntryPointId entryPoint;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;
    private ObjectTypeNodeId rightInputOtnId = ObjectTypeNodeId.DEFAULT_ID;

    public WindowNode() {
    }

    public WindowNode(int id, List<AlphaNodeFieldConstraint> constraints, List<BehaviorRuntime> behaviors, ObjectSource objectSource, BuildContext context) {
        super(id, context.getPartitionId(), objectSource, context.getRuleBase().getRuleBaseConfiguration().getAlphaNodeHashingThreshold(), context.getRuleBase().getRuleBaseConfiguration().getAlphaNodeRangeIndexThreshold());
        this.constraints = new ArrayList<AlphaNodeFieldConstraint>(constraints);
        this.behavior = new BehaviorManager(behaviors);
        this.entryPoint = context.getCurrentEntryPoint();
        for (BehaviorRuntime b : behaviors) {
            if (!(b instanceof SlidingTimeWindow)) continue;
            ((SlidingTimeWindow)b).setWindowNode(this);
        }
        this.hashcode = this.calculateHashCode();
        this.initMemoryId(context);
    }

    public int getType() {
        return 4916233;
    }

    public List<AlphaNodeFieldConstraint> getConstraints() {
        return this.constraints;
    }

    public BehaviorRuntime[] getBehaviors() {
        return this.behavior.getBehaviors();
    }

    @Override
    public void doAttach(BuildContext context) {
        this.source.addObjectSink(this);
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        DefaultEventHandle evFh = (DefaultEventHandle)factHandle;
        for (AlphaNodeFieldConstraint constraint : this.constraints) {
            if (constraint.isAllowed((FactHandle)evFh, (ValueResolver)reteEvaluator)) continue;
            return;
        }
        RightTuple rightTuple = new RightTuple(evFh, this);
        rightTuple.setPropagationContext(pctx);
        DefaultEventHandle clonedFh = evFh.cloneAndLink();
        rightTuple.setContextObject(clonedFh);
        WindowMemory memory = reteEvaluator.getNodeMemory(this);
        if (!this.behavior.assertFact(memory.behaviorContext, clonedFh, pctx, reteEvaluator)) {
            return;
        }
        this.sink.propagateAssertObject(clonedFh, pctx, reteEvaluator);
    }

    @Override
    public void retractRightTuple(TupleImpl rightTuple, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        if (this.isInUse()) {
            WindowMemory memory = reteEvaluator.getNodeMemory(this);
            this.behavior.retractFact(memory.behaviorContext, rightTuple.getFactHandle(), pctx, reteEvaluator);
        }
        InternalFactHandle clonedFh = (InternalFactHandle)rightTuple.getContextObject();
        ObjectTypeNode.doRetractObject(clonedFh, pctx, reteEvaluator);
    }

    @Override
    public void modifyRightTuple(TupleImpl rightTuple, PropagationContext context, ReteEvaluator reteEvaluator) {
        DefaultEventHandle originalFactHandle = (DefaultEventHandle)rightTuple.getFactHandle();
        DefaultEventHandle cloneFactHandle = (DefaultEventHandle)rightTuple.getContextObject();
        originalFactHandle.quickCloneUpdate(cloneFactHandle);
        boolean isAllowed = true;
        for (AlphaNodeFieldConstraint constraint : this.constraints) {
            if (constraint.isAllowed((FactHandle)cloneFactHandle, (ValueResolver)reteEvaluator)) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(cloneFactHandle.detachLinkedTuples());
            this.sink.propagateModifyObject(cloneFactHandle, modifyPreviousTuples, context, reteEvaluator);
            modifyPreviousTuples.retractTuples(context, reteEvaluator);
        } else {
            ObjectTypeNode.doRetractObject(cloneFactHandle, context, reteEvaluator);
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        TupleImpl rightTuple = modifyPreviousTuples.peekRightTuple(this.partitionId);
        while (rightTuple != null && rightTuple.getInputOtnId().before(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple(this.partitionId);
            rightTuple.setPropagationContext(context);
            ((RightTuple)rightTuple).retractTuple(context, reteEvaluator);
            rightTuple = modifyPreviousTuples.peekRightTuple(this.partitionId);
        }
        if (rightTuple != null && rightTuple.getInputOtnId().equals(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple(this.partitionId);
            rightTuple.reAdd();
            this.modifyRightTuple(rightTuple, context, reteEvaluator);
        } else {
            this.assertObject(factHandle, context, reteEvaluator);
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, reteEvaluator);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        Iterator<InternalFactHandle> it = this.getObjectTypeNode().getFactHandlesIterator(workingMemory);
        while (it.hasNext()) {
            this.assertObject(it.next(), context, workingMemory);
        }
    }

    @Override
    public WindowMemory createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        WindowMemory memory = new WindowMemory();
        memory.behaviorContext = this.behavior.createBehaviorContext();
        return memory;
    }

    @Override
    public String toString() {
        return "[WindowNode(" + this.id + ") constraints=" + this.constraints + "]";
    }

    private int calculateHashCode() {
        return this.source.hashCode() * 17 + (this.constraints != null ? this.constraints.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WindowNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        WindowNode other = (WindowNode)object;
        return this.source.getId() == other.source.getId() && this.constraints.equals(other.constraints) && this.behavior.equals(other.behavior);
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public BitMask calculateDeclaredMask(Pattern pattern, ObjectType modifiedType, List<String> settableProperties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectTypeNodeId getRightInputOtnId() {
        return this.rightInputOtnId;
    }

    public void setRightInputOtnId(ObjectTypeNodeId rightInputOtnId) {
        this.rightInputOtnId = rightInputOtnId;
    }

    public static class WindowMemory
    implements Memory {
        public BehaviorContext[] behaviorContext;

        @Override
        public int getNodeType() {
            return 4916233;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return null;
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrevious(Memory previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNext(Memory next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
        }

        public Collection<DefaultEventHandle> getFactHandles() {
            ArrayList<DefaultEventHandle> eventFactHandles = new ArrayList<DefaultEventHandle>();
            for (BehaviorContext ctx : this.behaviorContext) {
                for (DefaultEventHandle efh : ctx.getFactHandles()) {
                    eventFactHandles.add(efh.getLinkedFactHandle());
                }
            }
            return eventFactHandles;
        }
    }
}

