/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.util.IndexedValueReader;
import org.drools.base.util.index.ConstraintTypeOperator;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.TupleRBTree;
import org.drools.core.util.index.AbstractTupleIndexTree;
import org.drools.core.util.index.TupleList;
import org.drools.util.CoercionUtil;

public class TupleIndexRBTree
extends AbstractTupleIndexTree
implements Externalizable,
TupleMemory {
    private TupleRBTree<Comparable<Comparable>> tree;

    public TupleIndexRBTree() {
    }

    public TupleIndexRBTree(ConstraintTypeOperator constraintType, IndexedValueReader index, boolean left) {
        this.index = index;
        this.constraintType = constraintType;
        this.left = left;
        this.tree = new TupleRBTree();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tree);
        out.writeObject(this.index);
        out.writeObject(this.constraintType);
        out.writeInt(this.factSize);
        out.writeBoolean(this.left);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tree = (TupleRBTree)in.readObject();
        this.index = (IndexedValueReader)in.readObject();
        this.constraintType = (ConstraintTypeOperator)in.readObject();
        this.factSize = in.readInt();
        this.left = in.readBoolean();
    }

    @Override
    public void add(TupleImpl tuple) {
        Comparable key = this.getIndexedValue(tuple, this.left);
        TupleRBTree.Node<Comparable<Comparable>> list = this.tree.insert(key);
        list.add(tuple);
        ++this.factSize;
    }

    @Override
    public void remove(TupleImpl tuple) {
        TupleList list = tuple.getMemory();
        list.remove(tuple);
        if (list.getFirst() == null) {
            this.tree.delete((Comparable<Comparable>)((TupleRBTree.Node)list).key);
        }
        --this.factSize;
    }

    @Override
    public void removeAdd(TupleImpl tuple) {
        this.remove(tuple);
        this.add(tuple);
    }

    @Override
    public int size() {
        return this.factSize;
    }

    @Override
    public TupleImpl getFirst(TupleImpl rightTuple) {
        Comparable key = this.getIndexedValue(rightTuple, !this.left);
        return this.getNext(key, true);
    }

    public Iterator<TupleImpl> iterator() {
        TupleRBTree.Node<Comparable<Comparable>> list = this.tree.first();
        TupleImpl firstTuple = list != null ? (TupleImpl)list.getFirst() : null;
        return new FastIterator.IteratorAdapter<TupleImpl>(this.fastIterator(), firstTuple);
    }

    @Override
    public FastIterator<TupleImpl> fastIterator() {
        return new TupleFastIterator();
    }

    @Override
    public FastIterator<TupleImpl> fullFastIterator() {
        return new TupleFastIterator();
    }

    @Override
    public FastIterator<TupleImpl> fullFastIterator(TupleImpl leftTuple) {
        FastIterator<TupleImpl> fastIterator = this.fullFastIterator();
        Comparable key = this.getLeftIndexedValue(leftTuple);
        fastIterator.next(this.getNext(key, true));
        return fastIterator;
    }

    private TupleImpl getNext(Comparable key, boolean first) {
        return this.left ? this.getNextLeft(key, first) : this.getNextRight(key, first);
    }

    private TupleImpl getNextLeft(Comparable key, boolean first) {
        key = TupleIndexRBTree.coerceType(this.index, this.tree.root != null ? (Comparable)this.tree.root.key : null, key);
        TupleRBTree.Node<Comparable<Comparable>> firstNode = switch (this.constraintType) {
            case ConstraintTypeOperator.LESS_THAN -> this.tree.findNearestNode(key, false, TupleRBTree.Boundary.LOWER);
            case ConstraintTypeOperator.LESS_OR_EQUAL -> this.tree.findNearestNode(key, first, TupleRBTree.Boundary.LOWER);
            case ConstraintTypeOperator.GREATER_THAN -> this.tree.findNearestNode(key, false, TupleRBTree.Boundary.UPPER);
            case ConstraintTypeOperator.GREATER_OR_EQUAL -> this.tree.findNearestNode(key, first, TupleRBTree.Boundary.UPPER);
            default -> throw new UnsupportedOperationException("Cannot call remove constraint of type: " + this.constraintType);
        };
        return firstNode == null ? null : (TupleImpl)firstNode.getFirst();
    }

    private TupleImpl getNextRight(Comparable key, boolean first) {
        if (key == null) {
            return null;
        }
        key = TupleIndexRBTree.coerceType(this.index, this.tree.root != null ? (Comparable)this.tree.root.key : null, key);
        TupleRBTree.Node<Comparable<Comparable>> firstNode = switch (this.constraintType) {
            case ConstraintTypeOperator.LESS_THAN -> this.tree.findNearestNode(key, false, TupleRBTree.Boundary.UPPER);
            case ConstraintTypeOperator.LESS_OR_EQUAL -> this.tree.findNearestNode(key, first, TupleRBTree.Boundary.UPPER);
            case ConstraintTypeOperator.GREATER_THAN -> this.tree.findNearestNode(key, false, TupleRBTree.Boundary.LOWER);
            case ConstraintTypeOperator.GREATER_OR_EQUAL -> this.tree.findNearestNode(key, first, TupleRBTree.Boundary.LOWER);
            default -> throw new UnsupportedOperationException("Cannot call remove constraint of type: " + this.constraintType);
        };
        return firstNode == null ? null : (TupleImpl)firstNode.getFirst();
    }

    public static Comparable coerceType(IndexedValueReader index, Comparable treeRootKey, Comparable key) {
        if (index.requiresCoercion() && key != null && treeRootKey != null && !key.getClass().equals(treeRootKey.getClass())) {
            if (treeRootKey instanceof Number && key instanceof Number) {
                key = (Comparable)((Object)CoercionUtil.coerceToNumber((Number)((Number)((Object)key)), treeRootKey.getClass()));
            } else {
                throw new RuntimeException("Not possible to coerce [" + key + "] from class " + key.getClass() + " to class " + treeRootKey.getClass());
            }
        }
        return key;
    }

    @Override
    public void clear() {
        this.tree = new TupleRBTree();
    }

    @Override
    public TupleMemory.IndexType getIndexType() {
        return TupleMemory.IndexType.COMPARISON;
    }

    public class TupleFastIterator
    implements FastIterator<TupleImpl> {
        @Override
        public TupleImpl next(TupleImpl tuple) {
            if (tuple == null) {
                TupleRBTree.Node<Comparable<Comparable>> firstNode = TupleIndexRBTree.this.tree.first();
                return firstNode == null ? null : (TupleImpl)firstNode.getFirst();
            }
            TupleImpl next = tuple.getNext();
            if (next != null) {
                return next;
            }
            Comparable key = TupleIndexRBTree.this.getLeftIndexedValue(tuple);
            return TupleIndexRBTree.this.getNext(key, false);
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }
    }
}

