/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.integration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class IoUtils {
    public static File copyInTempFile(InputStream input, String fileExtension) throws IOException {
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), "." + fileExtension);
        tempFile.deleteOnExit();
        IoUtils.copy(input, new FileOutputStream(tempFile));
        return tempFile;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = IoUtils.createBytesBuffer(input);
        long count = 0L;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private static byte[] createBytesBuffer(InputStream input) throws IOException {
        return new byte[Math.max(input.available(), 8192)];
    }

    public static File getTmpDirectory() {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        File f = new File(tmp, "_kie_repo_" + UUID.randomUUID().toString());
        if (f.exists()) {
            if (f.isFile()) {
                throw new IllegalStateException("The temp directory exists as a file. Nuke it now !");
            }
            IoUtils.deleteDir(f);
            f.mkdir();
        } else {
            f.mkdir();
        }
        return f;
    }

    private static void deleteDir(File dir) {
        String[] children;
        for (String child : children = dir.list()) {
            File file = new File(dir, child);
            if (file.isFile()) {
                IoUtils.deleteFile(file);
                continue;
            }
            IoUtils.deleteDir(file);
        }
        IoUtils.deleteFile(dir);
    }

    private static void deleteFile(File file) {
        if (!file.delete()) {
            int count = 0;
            while (!file.delete() && count++ < 5) {
                System.gc();
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("This should never happen");
                }
            }
        }
        if (file.exists()) {
            try {
                throw new RuntimeException("Unable to delete file:" + file.getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to delete file", e);
            }
        }
    }
}

