/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.rule.accessor.Evaluator;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.time.Interval;
import org.drools.base.util.TimeIntervalParser;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.core.common.DefaultEventHandle;
import org.drools.drl.parser.impl.Operator;
import org.drools.mvel.evaluators.BaseEvaluator;
import org.drools.mvel.evaluators.VariableRestriction;
import org.kie.api.runtime.rule.FactHandle;

public class FinishedByEvaluatorDefinition
implements EvaluatorDefinition {
    protected static final String finishedByOp = Operator.BuiltInOperator.FINISHED_BY.getSymbol();
    public static final Operator FINISHED_BY = Operator.determineOperator((String)finishedByOp, (boolean)false);
    public static final Operator NOT_FINISHED_BY = Operator.determineOperator((String)finishedByOp, (boolean)true);
    private static final String[] SUPPORTED_IDS = new String[]{finishedByOp};
    private Map<String, FinishedByEvaluator> cache = Collections.emptyMap();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        FinishedByEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, FinishedByEvaluator>();
        }
        if ((eval = this.cache.get(key = isNegated + ":" + parameterText)) == null) {
            long[] params = TimeIntervalParser.parse((String)parameterText);
            eval = new FinishedByEvaluator(type, isNegated, params, parameterText);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.HANDLE;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class FinishedByEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long endDev;
        private String paramText;

        public FinishedByEvaluator() {
        }

        public FinishedByEvaluator(ValueType type, boolean isNegated, long[] parameters, String paramText) {
            super(type, isNegated ? NOT_FINISHED_BY : FINISHED_BY);
            this.paramText = paramText;
            this.setParameters(parameters);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.endDev = in.readLong();
            this.paramText = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.endDev);
            out.writeObject(this.paramText);
        }

        @Override
        public boolean isTemporal() {
            return true;
        }

        @Override
        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(Long.MIN_VALUE, 0L);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor, FactHandle object1, FieldValue object2) {
            throw new RuntimeException("The 'finishedby' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        @Override
        public boolean evaluateCachedRight(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle left) {
            if (context.rightNull || context.declaration.getExtractor().isNullValue(valueResolver, left.getObject())) {
                return false;
            }
            long distStart = ((DefaultEventHandle)left).getStartTimestamp() - ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long distEnd = Math.abs(((DefaultEventHandle)left).getEndTimestamp() - ((VariableRestriction.TemporalVariableContextEntry)context).endTS);
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        @Override
        public boolean evaluateCachedLeft(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle right) {
            if (context.leftNull || context.extractor.isNullValue(valueResolver, right.getObject())) {
                return false;
            }
            long distStart = ((VariableRestriction.TemporalVariableContextEntry)context).startTS - ((DefaultEventHandle)right).getStartTimestamp();
            long distEnd = Math.abs(((VariableRestriction.TemporalVariableContextEntry)context).endTS - ((DefaultEventHandle)right).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor1, FactHandle handle1, ReadAccessor extractor2, FactHandle handle2) {
            if (extractor1.isNullValue(valueResolver, handle1.getObject()) || extractor2.isNullValue(valueResolver, handle2.getObject())) {
                return false;
            }
            long distStart = ((DefaultEventHandle)handle2).getStartTimestamp() - ((DefaultEventHandle)handle1).getStartTimestamp();
            long distEnd = Math.abs(((DefaultEventHandle)handle2).getEndTimestamp() - ((DefaultEventHandle)handle1).getEndTimestamp());
            return this.getOperator().isNegated() ^ (distStart > 0L && distEnd <= this.endDev);
        }

        @Override
        public String toString() {
            return "finishedby[" + (this.paramText != null ? this.paramText : "") + "]";
        }

        @Override
        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.endDev ^ this.endDev >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FinishedByEvaluator other = (FinishedByEvaluator)obj;
            return this.endDev == other.endDev;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void setParameters(long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.endDev = 0L;
                return;
            } else {
                if (parameters.length != 1) throw new RuntimeException("[FinishedBy Evaluator]: Not possible to use " + parameters.length + " parameters: '" + this.paramText + "'");
                if (parameters[0] < 0L) throw new RuntimeException("[FinishedBy Evaluator]: Not possible to use negative parameter: '" + this.paramText + "'");
                this.endDev = parameters[0];
            }
        }
    }
}

