/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.util.List;
import org.drools.base.evaluators.Operator;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.RestrictionDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.verifier.components.EnumField;
import org.drools.verifier.components.EnumRestriction;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.Import;
import org.drools.verifier.components.LiteralRestriction;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.OperatorDescrType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternVariable;
import org.drools.verifier.components.QualifiedIdentifierRestriction;
import org.drools.verifier.components.ReturnValueRestriction;
import org.drools.verifier.components.Variable;
import org.drools.verifier.components.VariableRestriction;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.solver.Solvers;
import org.drools.verifier.visitor.ObjectTypeFactory;
import org.drools.verifier.visitor.UnknownDescriptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldConstraintDescrVisitor {
    private final VerifierData data;
    private final ObjectType objectType;
    private final Pattern pattern;
    private Field field;
    private final int orderNumber;
    private final Solvers solvers;

    public FieldConstraintDescrVisitor(VerifierData data, Pattern pattern, Solvers solvers, int orderNumber) {
        this.data = data;
        this.pattern = pattern;
        this.solvers = solvers;
        this.orderNumber = orderNumber;
        this.objectType = (ObjectType)data.getVerifierObject(VerifierComponentType.OBJECT_TYPE, pattern.getObjectTypePath());
    }

    public void visitFieldConstraintDescr(FieldConstraintDescr descr) throws UnknownDescriptionException {
        this.field = this.data.getFieldByObjectTypeAndFieldName(this.objectType.getFullName(), descr.getFieldName());
        if (this.field == null) {
            this.field = ObjectTypeFactory.createField(descr.getFieldName(), this.objectType);
            this.data.add(this.field);
        }
        this.visit(descr.getRestriction());
    }

    public void visit(RestrictionDescr restrictionDescr) throws UnknownDescriptionException {
        if (restrictionDescr instanceof LiteralRestrictionDescr) {
            this.visit((LiteralRestrictionDescr)restrictionDescr);
        } else if (restrictionDescr instanceof QualifiedIdentifierRestrictionDescr) {
            this.visit((QualifiedIdentifierRestrictionDescr)restrictionDescr);
        } else if (restrictionDescr instanceof ReturnValueRestrictionDescr) {
            this.visit((ReturnValueRestrictionDescr)restrictionDescr);
        } else if (restrictionDescr instanceof VariableRestrictionDescr) {
            this.visit((VariableRestrictionDescr)restrictionDescr);
        } else if (restrictionDescr instanceof PredicateDescr) {
            this.visit((RestrictionDescr)((PredicateDescr)restrictionDescr));
        } else if (restrictionDescr instanceof RestrictionConnectiveDescr) {
            this.visit((RestrictionConnectiveDescr)restrictionDescr);
        } else {
            throw new UnknownDescriptionException((BaseDescr)restrictionDescr);
        }
    }

    private void visit(List<RestrictionDescr> restrictions) throws UnknownDescriptionException {
        for (RestrictionDescr restrictionDescr : restrictions) {
            this.visit(restrictionDescr);
        }
    }

    private void visit(RestrictionConnectiveDescr descr) throws UnknownDescriptionException {
        if (descr.getConnective() == RestrictionConnectiveDescr.AND) {
            this.solvers.startOperator(OperatorDescrType.AND);
            this.visit(descr.getRestrictions());
            this.solvers.endOperator();
        } else if (descr.getConnective() == RestrictionConnectiveDescr.OR) {
            this.solvers.startOperator(OperatorDescrType.OR);
            this.visit(descr.getRestrictions());
            this.solvers.endOperator();
        } else {
            throw new UnknownDescriptionException((BaseDescr)descr);
        }
    }

    private void visit(LiteralRestrictionDescr descr) {
        LiteralRestriction restriction = LiteralRestriction.createRestriction(this.pattern, descr.getText());
        restriction.setPatternIsNot(this.pattern.isPatternNot());
        restriction.setFieldPath(this.field.getPath());
        restriction.setOperator(Operator.determineOperator((String)descr.getEvaluator(), (boolean)descr.isNegated()));
        restriction.setOrderNumber(this.orderNumber);
        restriction.setParentPath(this.pattern.getPath());
        restriction.setParentType(this.pattern.getVerifierComponentType());
        this.field.setFieldType(restriction.getValueType());
        this.data.add(restriction);
        this.solvers.addPatternComponent(restriction);
    }

    private void visit(QualifiedIdentifierRestrictionDescr descr) {
        String text = descr.getText();
        String base = text.substring(0, text.indexOf("."));
        String fieldName = text.substring(text.indexOf("."));
        Variable patternVariable = this.data.getVariableByRuleAndVariableName(this.pattern.getRuleName(), base);
        if (patternVariable != null) {
            QualifiedIdentifierRestriction restriction = new QualifiedIdentifierRestriction(this.pattern);
            restriction.setPatternIsNot(this.pattern.isPatternNot());
            restriction.setFieldPath(this.field.getPath());
            restriction.setOperator(Operator.determineOperator((String)descr.getEvaluator(), (boolean)descr.isNegated()));
            restriction.setVariablePath(patternVariable.getPath());
            restriction.setVariableName(base);
            restriction.setVariablePath(fieldName);
            restriction.setOrderNumber(this.orderNumber);
            restriction.setParentPath(this.pattern.getPath());
            restriction.setParentType(this.pattern.getVerifierComponentType());
            this.field.setFieldType("Variable");
            this.data.add(restriction);
            this.solvers.addPatternComponent(restriction);
        } else {
            EnumField enumField = (EnumField)this.data.getFieldByObjectTypeAndFieldName(base, fieldName);
            if (enumField == null) {
                ObjectType objectType = this.data.getObjectTypeByFullName(base);
                if (objectType == null) {
                    Import objectImport = this.data.getImportByName(base);
                    objectType = objectImport != null ? ObjectTypeFactory.createObjectType(objectImport) : ObjectTypeFactory.createObjectType(base);
                    this.data.add(objectType);
                }
                enumField = new EnumField();
                enumField.setObjectTypePath(objectType.getPath());
                enumField.setObjectTypeName(objectType.getName());
                enumField.setName(fieldName);
                objectType.getFields().add(enumField);
                this.data.add(enumField);
            }
            EnumRestriction restriction = new EnumRestriction(this.pattern);
            restriction.setPatternIsNot(this.pattern.isPatternNot());
            restriction.setFieldPath(this.field.getPath());
            restriction.setOperator(Operator.determineOperator((String)descr.getEvaluator(), (boolean)descr.isNegated()));
            restriction.setEnumBasePath(enumField.getPath());
            restriction.setEnumBase(base);
            restriction.setEnumName(fieldName);
            restriction.setOrderNumber(this.orderNumber);
            restriction.setParentPath(this.pattern.getPath());
            restriction.setParentType(this.pattern.getVerifierComponentType());
            this.field.setFieldType("Enum");
            this.data.add(restriction);
            this.solvers.addPatternComponent(restriction);
        }
    }

    private void visit(VariableRestrictionDescr descr) {
        PatternVariable patternVariable = (PatternVariable)this.data.getVariableByRuleAndVariableName(this.pattern.getRuleName(), descr.getIdentifier());
        VariableRestriction restriction = new VariableRestriction(this.pattern);
        restriction.setPatternIsNot(this.pattern.isPatternNot());
        restriction.setFieldPath(this.field.getPath());
        restriction.setOperator(Operator.determineOperator((String)descr.getEvaluator(), (boolean)descr.isNegated()));
        restriction.setVariable(patternVariable);
        restriction.setOrderNumber(this.orderNumber);
        restriction.setParentPath(this.pattern.getPath());
        restriction.setParentType(this.pattern.getVerifierComponentType());
        this.field.setFieldType("Variable");
        this.data.add(restriction);
        this.solvers.addPatternComponent(restriction);
    }

    private void visit(ReturnValueRestrictionDescr descr) {
        ReturnValueRestriction restriction = new ReturnValueRestriction(this.pattern);
        restriction.setPatternIsNot(this.pattern.isPatternNot());
        restriction.setFieldPath(this.field.getPath());
        restriction.setOperator(Operator.determineOperator((String)descr.getEvaluator(), (boolean)descr.isNegated()));
        restriction.setClassMethodName(descr.getClassMethodName());
        restriction.setContent(descr.getContent());
        restriction.setDeclarations(descr.getDeclarations());
        restriction.setOrderNumber(this.orderNumber);
        restriction.setParentPath(this.pattern.getPath());
        restriction.setParentType(this.pattern.getVerifierComponentType());
        this.data.add(restriction);
        this.solvers.addPatternComponent(restriction);
    }
}

