/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkAdapter;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.PropagationContext;

public class QueryRiaFixerNode
extends LeftTupleSource
implements LeftTupleSinkNode {
    private static final long serialVersionUID = 510L;
    private LeftTupleSource tupleSource;
    protected boolean tupleMemoryEnabled;
    private AccumulateNode accumulateNode;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public QueryRiaFixerNode() {
    }

    public QueryRiaFixerNode(int id, LeftTupleSource tupleSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.tupleSource = tupleSource;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.accumulateNode = (AccumulateNode)in.readObject();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.accumulateNode);
        out.writeObject(this.tupleSource);
        out.writeBoolean(this.tupleMemoryEnabled);
    }

    public AccumulateNode getAccumulateNode() {
        return this.accumulateNode;
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void addTupleSink(LeftTupleSink tupleSink) {
        this.accumulateNode = (AccumulateNode)tupleSink;
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        context.getQueue2().addLast(new ReteooWorkingMemory.QueryRiaFixerNodeFixer(context, leftTuple, false, this.accumulateNode));
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        context.getQueue2().addLast(new ReteooWorkingMemory.QueryRiaFixerNodeFixer(context, leftTuple, true, this.accumulateNode));
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple leftTuple = modifyPreviousTuples.removeLeftTuple(this);
        if (leftTuple != null) {
            leftTuple.reAdd();
            this.modifyLeftTuple(leftTuple, context, workingMemory);
        } else {
            this.assertLeftTuple(new LeftTupleImpl(factHandle, (LeftTupleSink)this, true), context, workingMemory);
        }
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        context.getQueue2().addLast(new ReteooWorkingMemory.QueryRiaFixerNodeFixer(context, leftTuple, false, this.accumulateNode));
    }

    public String toString() {
        return "[RiaQueryFixerNode: ]";
    }

    public int hashCode() {
        return this.tupleSource.hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        RiaQueryFixerNodeAdapter adapter = new RiaQueryFixerNodeAdapter(this, sink);
        this.tupleSource.updateSink(adapter, context, workingMemory);
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        this.tupleSource.remove(context, builder, this, workingMemories);
    }

    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public short getType() {
        return 3;
    }

    public boolean isInUse() {
        return this.accumulateNode != null;
    }

    private static class RiaQueryFixerNodeAdapter
    implements LeftTupleSink,
    LeftTupleSinkAdapter {
        private final QueryRiaFixerNode node;
        private final LeftTupleSink sink;

        public RiaQueryFixerNodeAdapter(QueryRiaFixerNode node, LeftTupleSink sink) {
            this.node = node;
            this.sink = sink;
        }

        public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public short getType() {
            return 0;
        }

        public boolean isLeftTupleMemoryEnabled() {
            return false;
        }

        public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("LeftTupleSinkUpdateAdapter onlys supports assertLeftTuple method calls");
        }

        public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("LeftTupleSinkUpdateAdapter onlys supports assertLeftTuple method calls");
        }

        public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("LeftTupleSinkUpdateAdapter onlys supports assertLeftTuple method calls");
        }

        public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
            throw new UnsupportedOperationException("LeftTupleSinkUpdateAdapter onlys supports assertLeftTuple method calls");
        }

        public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput arg0) throws IOException {
        }

        public int getId() {
            return 0;
        }

        public RuleBasePartitionId getPartitionId() {
            return this.sink.getPartitionId();
        }

        public LeftTupleSink getRealSink() {
            return this.node;
        }
    }
}

