/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.DelayedPostInsertIdentifier;
import org.hibernate.action.EntityAction;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityIdentityInsertAction
extends EntityAction {
    private final Object[] state;
    private final boolean isDelayed;
    private final EntityKey delayedEntityKey;
    private Serializable generatedId;

    public EntityIdentityInsertAction(Object[] state, Object instance, EntityPersister persister, SessionImplementor session, boolean isDelayed) throws HibernateException {
        super(session, null, instance, persister);
        this.state = state;
        this.isDelayed = isDelayed;
        this.delayedEntityKey = isDelayed ? this.generateDelayedEntityKey() : null;
    }

    public void execute() throws HibernateException {
        boolean veto;
        EntityPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        boolean stats = session.getFactory().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        if (!(veto = this.preInsert())) {
            this.generatedId = persister.insert(this.state, instance, session);
            if (persister.hasInsertGeneratedProperties()) {
                persister.processInsertGeneratedProperties(this.generatedId, instance, this.state, session);
            }
            persister.setIdentifier(instance, this.generatedId, session.getEntityMode());
        }
        this.postInsert();
        if (stats && !veto) {
            session.getFactory().getStatisticsImplementor().insertEntity(this.getPersister().getEntityName(), System.currentTimeMillis() - startTime);
        }
    }

    private void postInsert() {
        PostInsertEventListener[] postListeners;
        if (this.isDelayed) {
            this.getSession().getPersistenceContext().replaceDelayedEntityIdentityInsertKeys(this.delayedEntityKey, this.generatedId);
        }
        if ((postListeners = this.getSession().getListeners().getPostInsertEventListeners()).length > 0) {
            PostInsertEvent postEvent = new PostInsertEvent(this.getInstance(), this.generatedId, this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostInsert(postEvent);
            }
        }
    }

    private void postCommitInsert() {
        PostInsertEventListener[] postListeners = this.getSession().getListeners().getPostCommitInsertEventListeners();
        if (postListeners.length > 0) {
            PostInsertEvent postEvent = new PostInsertEvent(this.getInstance(), this.generatedId, this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostInsert(postEvent);
            }
        }
    }

    private boolean preInsert() {
        PreInsertEventListener[] preListeners = this.getSession().getListeners().getPreInsertEventListeners();
        boolean veto = false;
        if (preListeners.length > 0) {
            PreInsertEvent preEvent = new PreInsertEvent(this.getInstance(), null, this.state, this.getPersister(), this.getSession());
            for (int i = 0; i < preListeners.length; ++i) {
                veto = preListeners[i].onPreInsert(preEvent) || veto;
            }
        }
        return veto;
    }

    public void afterTransactionCompletion(boolean success) throws HibernateException {
        this.postCommitInsert();
    }

    public boolean hasAfterTransactionCompletion() {
        return this.hasPostCommitEventListeners();
    }

    protected boolean hasPostCommitEventListeners() {
        return this.getSession().getListeners().getPostCommitInsertEventListeners().length > 0;
    }

    public final Serializable getGeneratedId() {
        return this.generatedId;
    }

    public EntityKey getDelayedEntityKey() {
        return this.delayedEntityKey;
    }

    private synchronized EntityKey generateDelayedEntityKey() {
        if (!this.isDelayed) {
            throw new AssertionFailure("cannot request delayed entity-key for non-delayed post-insert-id generation");
        }
        return new EntityKey(new DelayedPostInsertIdentifier(), this.getPersister(), this.getSession().getEntityMode());
    }
}

