/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.drools.FactHandle;
import org.drools.RuntimeDroolsException;
import org.drools.base.EvaluatorWrapper;
import org.drools.base.ModifyInterceptor;
import org.drools.base.mvel.MVELCalendarCoercion;
import org.drools.base.mvel.MVELDateCoercion;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.common.AgendaItem;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.definition.rule.Rule;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.Declaration;
import org.drools.spi.GlobalResolver;
import org.drools.spi.KnowledgeHelper;
import org.mvel2.ConversionHandler;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.UnresolveablePropertyException;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.BaseVariableResolverFactory;
import org.mvel2.integration.impl.CachingMapVariableResolverFactory;
import org.mvel2.integration.impl.IndexVariableResolver;
import org.mvel2.integration.impl.MapVariableResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELCompilationUnit
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 510L;
    private String name;
    private String expression;
    private String[] pkgImports;
    private String[] importClasses;
    private String[] importMethods;
    private String[] importFields;
    private String[] globalIdentifiers;
    private EvaluatorWrapper[] operators;
    private Declaration[] previousDeclarations;
    private Declaration[] localDeclarations;
    private String[] otherIdentifiers;
    private String[] inputIdentifiers;
    private String[] inputTypes;
    private String[] shadowIdentifiers;
    private int languageLevel;
    private boolean strictMode;
    private static Map interceptors = new HashMap(2);
    private static final Map<String, Class<?>> primitivesMap;
    public static final Object COMPILER_LOCK;

    public MVELCompilationUnit() {
    }

    public MVELCompilationUnit(String name, String expression, String[] pkgImports, String[] importClasses, String[] importMethods, String[] importFields, String[] globalIdentifiers, EvaluatorWrapper[] operators, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] otherIdentifiers, String[] inputIdentifiers, String[] inputTypes, int languageLevel, boolean strictMode) {
        this.name = name;
        this.expression = expression;
        this.pkgImports = pkgImports;
        this.importClasses = importClasses;
        this.importMethods = importMethods;
        this.importFields = importFields;
        this.globalIdentifiers = globalIdentifiers;
        this.operators = operators;
        this.previousDeclarations = previousDeclarations;
        this.localDeclarations = localDeclarations;
        this.otherIdentifiers = otherIdentifiers;
        this.inputIdentifiers = inputIdentifiers;
        this.inputTypes = inputTypes;
        this.languageLevel = languageLevel;
        this.strictMode = strictMode;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setShadowIdentifiers(String[] shadowIdentifiers) {
        this.shadowIdentifiers = shadowIdentifiers;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.expression);
        out.writeObject(this.pkgImports);
        out.writeObject(this.importClasses);
        out.writeObject(this.importMethods);
        out.writeObject(this.importFields);
        out.writeObject(this.globalIdentifiers);
        out.writeObject(this.operators);
        out.writeObject(this.previousDeclarations);
        out.writeObject(this.localDeclarations);
        out.writeObject(this.otherIdentifiers);
        out.writeObject(this.inputIdentifiers);
        out.writeObject(this.inputTypes);
        out.writeObject(this.shadowIdentifiers);
        out.writeInt(this.languageLevel);
        out.writeBoolean(this.strictMode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.expression = in.readUTF();
        this.pkgImports = (String[])in.readObject();
        this.importClasses = (String[])in.readObject();
        this.importMethods = (String[])in.readObject();
        this.importFields = (String[])in.readObject();
        this.globalIdentifiers = (String[])in.readObject();
        this.operators = (EvaluatorWrapper[])in.readObject();
        this.previousDeclarations = (Declaration[])in.readObject();
        this.localDeclarations = (Declaration[])in.readObject();
        this.otherIdentifiers = (String[])in.readObject();
        this.inputIdentifiers = (String[])in.readObject();
        this.inputTypes = (String[])in.readObject();
        this.shadowIdentifiers = (String[])in.readObject();
        this.languageLevel = in.readInt();
        this.strictMode = in.readBoolean();
    }

    public Serializable getCompiledExpression(ClassLoader classLoader) {
        Class cls;
        HashMap<String, AnnotatedElement> resolvedImports = new HashMap<String, AnnotatedElement>(this.importClasses.length + this.importMethods.length + this.importFields.length);
        String lastName = null;
        try {
            String className;
            String name2;
            int i$;
            String[] arr$ = this.importClasses;
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                lastName = name2 = arr$[i$];
                Class cls2 = this.loadClass(classLoader, name2);
                resolvedImports.put(cls2.getSimpleName(), cls2);
            }
            arr$ = this.importMethods;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                lastName = name2 = arr$[i$];
                int lastDot = name2.lastIndexOf(46);
                className = name2.substring(0, lastDot);
                cls = this.loadClass(classLoader, className);
                String methodName = name2.substring(lastDot + 1);
                Method method = null;
                for (Method item : cls.getMethods()) {
                    if (!methodName.equals(item.getName())) continue;
                    method = item;
                    break;
                }
                resolvedImports.put(method.getName(), method);
            }
            for (String name2 : this.importFields) {
                int lastDot = name2.lastIndexOf(46);
                className = name2.substring(0, lastDot);
                cls = this.loadClass(classLoader, className);
                String fieldName = name2.substring(lastDot + 1);
                Field field = cls.getField(fieldName);
                resolvedImports.put(field.getName(), field);
            }
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Unable to resolve import '" + lastName + "'");
        }
        ParserConfiguration conf = new ParserConfiguration();
        conf.setImports(resolvedImports);
        conf.setPackageImports(new HashSet<String>(Arrays.asList(this.pkgImports)));
        conf.setClassLoader(classLoader);
        ParserContext parserContext = new ParserContext(conf);
        if (MVELDebugHandler.isDebugMode()) {
            parserContext.setDebugSymbols(true);
        }
        parserContext.setStrictTypeEnforcement(this.strictMode);
        parserContext.setStrongTyping(this.strictMode);
        parserContext.setIndexAllocation(true);
        if (interceptors != null) {
            parserContext.setInterceptors(interceptors);
        }
        parserContext.addIndexedVariables(this.inputIdentifiers);
        String identifier = null;
        String type = null;
        try {
            int length = this.inputIdentifiers.length;
            for (int i = 0; i < length; ++i) {
                identifier = this.inputIdentifiers[i];
                type = this.inputTypes[i];
                cls = this.loadClass(classLoader, this.inputTypes[i]);
                parserContext.addInput(this.inputIdentifiers[i], cls);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Unable to resolve class '" + type + "' for identifier '" + identifier);
        }
        parserContext.setSourceFile(this.name);
        return MVELCompilationUnit.compile(this.expression, classLoader, parserContext, this.languageLevel);
    }

    public DroolsMVELIndexedFactory getFactory(Object knowledgeHelper, Rule rule, Object rightObject, LeftTuple tuples, Object[] otherVars, InternalWorkingMemory workingMemory, GlobalResolver globals) {
        int varLength = this.inputIdentifiers.length;
        Object[] vals = new Object[varLength];
        int i = 0;
        if (rightObject != null) {
            vals[i++] = rightObject;
        }
        vals[i++] = knowledgeHelper;
        vals[i++] = knowledgeHelper;
        vals[i++] = rule;
        if (this.globalIdentifiers != null) {
            int length = this.globalIdentifiers.length;
            for (int j = 0; j < length; ++j) {
                vals[i++] = globals.resolveGlobal(this.globalIdentifiers[j]);
            }
        }
        InternalFactHandle[] handles = tuples != null ? tuples.toFactHandles() : new InternalFactHandle[]{};
        if (this.operators != null) {
            int length = this.operators.length;
            for (int j = 0; j < length; ++j) {
                vals[i++] = this.operators[j].setWorkingMemory(workingMemory);
                if (this.operators[j].getLeftBinding() != null) {
                    if (this.operators[j].getLeftBinding().getIdentifier().equals("this")) {
                        this.operators[j].setLeftHandle((InternalFactHandle)workingMemory.getFactHandle(rightObject));
                    } else {
                        this.operators[j].setLeftHandle(MVELCompilationUnit.getFactHandle(this.operators[j].getLeftBinding(), handles));
                    }
                }
                if (this.operators[j].getRightBinding() == null) continue;
                if (this.operators[j].getRightBinding().getIdentifier().equals("this")) {
                    this.operators[j].setRightHandle((InternalFactHandle)workingMemory.getFactHandle(rightObject));
                    continue;
                }
                this.operators[j].setRightHandle(MVELCompilationUnit.getFactHandle(this.operators[j].getRightBinding(), handles));
            }
        }
        IdentityHashMap<Object, FactHandle> identityMap = null;
        if (knowledgeHelper != null) {
            identityMap = new IdentityHashMap<Object, FactHandle>();
        }
        if (tuples != null && this.previousDeclarations != null && this.previousDeclarations.length > 0) {
            Declaration[] prevDecl = this.previousDeclarations;
            if (knowledgeHelper != null) {
                prevDecl = ((AgendaItem)((KnowledgeHelper)knowledgeHelper).getActivation()).getRuleTerminalNode().getDeclarations();
            }
            for (Declaration decl : prevDecl) {
                InternalFactHandle handle = MVELCompilationUnit.getFactHandle(decl, handles);
                Object o = decl.getValue(workingMemory, handle.getObject());
                if (knowledgeHelper != null && decl.isPatternDeclaration()) {
                    identityMap.put(decl.getIdentifier(), handle);
                }
                vals[i++] = o;
            }
        }
        if (this.localDeclarations != null && this.localDeclarations.length > 0) {
            for (Declaration decl : this.localDeclarations) {
                Object o = decl.getValue(workingMemory, rightObject);
                vals[i++] = o;
            }
        }
        int otherVarsPos = 0;
        if (otherVars != null) {
            otherVarsPos = i;
            for (Object o : otherVars) {
                vals[i++] = o;
            }
        }
        int otherVarsLength = i - otherVarsPos;
        CachingMapVariableResolverFactory locals = new CachingMapVariableResolverFactory(new HashMap());
        DroolsMVELIndexedFactory factory = new DroolsMVELIndexedFactory(this.inputIdentifiers, vals, (VariableResolverFactory)locals);
        factory.setOtherVarsPos(otherVarsPos);
        factory.setOtherVarsLength(otherVarsLength);
        if (knowledgeHelper != null && knowledgeHelper instanceof KnowledgeHelper) {
            KnowledgeHelper kh = (KnowledgeHelper)knowledgeHelper;
            kh.setIdentityMap(identityMap);
            factory.setKnowledgeHelper(kh);
        }
        return factory;
    }

    private static InternalFactHandle getFactHandle(Declaration declaration, InternalFactHandle[] handles) {
        return handles.length >= declaration.getPattern().getOffset() ? handles[declaration.getPattern().getOffset()] : null;
    }

    public static Serializable compile(String text, ClassLoader classLoader, ParserContext parserContext, int languageLevel) {
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        if (MVELDebugHandler.isDebugMode()) {
            parserContext.setDebugSymbols(true);
        }
        Serializable expr = null;
        expr = MVEL.compileExpression((String)text.trim(), (ParserContext)parserContext);
        return expr;
    }

    private Class loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        Class<?> cls = primitivesMap.get(className);
        if (cls == null) {
            cls = classLoader.loadClass(className);
        }
        return cls;
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        int i;
        if (this.previousDeclarations != null) {
            for (i = 0; i < this.previousDeclarations.length; ++i) {
                if (!this.previousDeclarations[i].equals(declaration)) continue;
                this.previousDeclarations[i] = resolved;
            }
        }
        if (this.localDeclarations != null) {
            for (i = 0; i < this.localDeclarations.length; ++i) {
                if (!this.localDeclarations[i].equals(declaration)) continue;
                this.localDeclarations[i] = resolved;
            }
        }
    }

    public MVELCompilationUnit clone() {
        return new MVELCompilationUnit(this.name, this.expression, this.pkgImports, this.importClasses, this.importMethods, this.importFields, this.globalIdentifiers, this.operators, this.previousDeclarations, this.localDeclarations, this.otherIdentifiers, this.inputIdentifiers, this.inputTypes, this.languageLevel, this.strictMode);
    }

    public static long getSerialversionuid() {
        return 510L;
    }

    public String getName() {
        return this.name;
    }

    public String[] getPkgImports() {
        return this.pkgImports;
    }

    public String[] getImportClasses() {
        return this.importClasses;
    }

    public String[] getImportMethods() {
        return this.importMethods;
    }

    public String[] getImportFields() {
        return this.importFields;
    }

    public String[] getGlobalIdentifiers() {
        return this.globalIdentifiers;
    }

    public Declaration[] getPreviousDeclarations() {
        return this.previousDeclarations;
    }

    public void setPreviousDeclarations(Declaration[] previousDeclarations) {
        this.previousDeclarations = previousDeclarations;
    }

    public Declaration[] getLocalDeclarations() {
        return this.localDeclarations;
    }

    public String[] getOtherIdentifiers() {
        return this.otherIdentifiers;
    }

    public String[] getInputIdentifiers() {
        return this.inputIdentifiers;
    }

    public String[] getInputTypes() {
        return this.inputTypes;
    }

    public String[] getShadowIdentifiers() {
        return this.shadowIdentifiers;
    }

    public int getLanguageLevel() {
        return this.languageLevel;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public static Map getInterceptors() {
        return interceptors;
    }

    public static Map<String, Class<?>> getPrimitivesmap() {
        return primitivesMap;
    }

    public static Object getCompilerLock() {
        return COMPILER_LOCK;
    }

    static {
        interceptors.put("Modify", new ModifyInterceptor());
        DataConversion.addConversionHandler(Date.class, (ConversionHandler)new MVELDateCoercion());
        DataConversion.addConversionHandler(Calendar.class, (ConversionHandler)new MVELCalendarCoercion());
        primitivesMap = new HashMap();
        primitivesMap.put("int", Integer.TYPE);
        primitivesMap.put("boolean", Boolean.TYPE);
        primitivesMap.put("float", Float.TYPE);
        primitivesMap.put("long", Long.TYPE);
        primitivesMap.put("short", Short.TYPE);
        primitivesMap.put("byte", Byte.TYPE);
        primitivesMap.put("double", Double.TYPE);
        primitivesMap.put("char", Character.TYPE);
        COMPILER_LOCK = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DroolsMVELIndexedFactory
    extends BaseVariableResolverFactory {
        private KnowledgeHelper knowledgeHelper;
        private int otherVarsPos;
        private int otherVarsLength;
        private Object[] values;

        public DroolsMVELIndexedFactory(String[] varNames, Object[] values) {
            this.indexedVariableNames = varNames;
            this.values = values;
            this.indexedVariableResolvers = DroolsMVELIndexedFactory.createResolvers(values);
        }

        public DroolsMVELIndexedFactory(String[] varNames, Object[] values, VariableResolverFactory factory) {
            this.indexedVariableNames = varNames;
            this.values = values;
            this.nextFactory = new MapVariableResolverFactory();
            this.nextFactory.setNextFactory(factory);
            this.indexedVariableResolvers = DroolsMVELIndexedFactory.createResolvers(values);
        }

        private static VariableResolver[] createResolvers(Object[] values) {
            VariableResolver[] vr = new VariableResolver[values.length];
            for (int i = 0; i < values.length; ++i) {
                vr[i] = new IndexVariableResolver(i, values);
            }
            return vr;
        }

        public KnowledgeHelper getKnowledgeHelper() {
            return this.knowledgeHelper;
        }

        public void setKnowledgeHelper(KnowledgeHelper kh) {
            this.knowledgeHelper = kh;
        }

        public int getOtherVarsPos() {
            return this.otherVarsPos;
        }

        public void setOtherVarsPos(int otherVarsPos) {
            this.otherVarsPos = otherVarsPos;
        }

        public int getOtherVarsLength() {
            return this.otherVarsLength;
        }

        public void setOtherVarsLength(int otherVarsLength) {
            this.otherVarsLength = otherVarsLength;
        }

        public VariableResolver createIndexedVariable(int index, String name, Object value) {
            this.indexedVariableResolvers[index].setValue(value);
            return this.indexedVariableResolvers[index];
        }

        public VariableResolver getIndexedVariableResolver(int index) {
            return this.indexedVariableResolvers[index];
        }

        public VariableResolver createVariable(String name, Object value) {
            VariableResolver vr = this.getResolver(name);
            if (vr != null) {
                vr.setValue(value);
                return vr;
            }
            if (this.nextFactory == null) {
                this.nextFactory = new MapVariableResolverFactory(new HashMap());
            }
            return this.nextFactory.createVariable(name, value);
        }

        public VariableResolver createVariable(String name, Object value, Class<?> type) {
            VariableResolver vr = this.getResolver(name);
            if (vr != null) {
                if (vr.getType() != null) {
                    throw new RuntimeException("variable already defined within scope: " + vr.getType() + " " + name);
                }
                vr.setValue(value);
                return vr;
            }
            if (this.nextFactory == null) {
                this.nextFactory = new MapVariableResolverFactory(new HashMap());
            }
            return this.nextFactory.createVariable(name, value, type);
        }

        public VariableResolver getVariableResolver(String name) {
            VariableResolver vr = this.getResolver(name);
            if (vr != null) {
                return vr;
            }
            if (this.nextFactory != null) {
                return this.nextFactory.getVariableResolver(name);
            }
            throw new UnresolveablePropertyException("unable to resolve variable '" + name + "'");
        }

        public boolean isResolveable(String name) {
            return this.isTarget(name) || this.nextFactory != null && this.nextFactory.isResolveable(name);
        }

        protected VariableResolver addResolver(String name, VariableResolver vr) {
            this.variableResolvers.put(name, vr);
            return vr;
        }

        private VariableResolver getResolver(String name) {
            for (int i = 0; i < this.indexedVariableNames.length; ++i) {
                if (!this.indexedVariableNames[i].equals(name)) continue;
                return this.indexedVariableResolvers[i];
            }
            return null;
        }

        public boolean isTarget(String name) {
            for (String indexedVariableName : this.indexedVariableNames) {
                if (!indexedVariableName.equals(name)) continue;
                return true;
            }
            return false;
        }

        public Set<String> getKnownVariables() {
            HashSet<String> vars = new HashSet<String>();
            for (int i = 0; i < this.indexedVariableNames.length; ++i) {
                vars.add(this.indexedVariableNames[i]);
            }
            return vars;
        }

        public void clear() {
        }

        public boolean isIndexedFactory() {
            return true;
        }
    }
}

