/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.Agenda;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.QueryResults;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.SessionConfiguration;
import org.drools.WorkingMemoryEntryPoint;
import org.drools.base.CalendarsImpl;
import org.drools.base.MapGlobalResolver;
import org.drools.common.ConcurrentNodeMemories;
import org.drools.common.EndOperationListener;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemoryActions;
import org.drools.common.InternalWorkingMemoryEntryPoint;
import org.drools.common.NamedEntryPoint;
import org.drools.common.NodeMemories;
import org.drools.common.NodeMemory;
import org.drools.common.ObjectStore;
import org.drools.common.ObjectTypeConfigurationRegistry;
import org.drools.common.RuleBasePartitionId;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.common.WorkingMemoryAction;
import org.drools.concurrent.ExternalExecutorService;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaEventSupport;
import org.drools.event.RuleBaseEventListener;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.event.WorkingMemoryEventSupport;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.process.ProcessEventManager;
import org.drools.management.DroolsManagementAgent;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.impl.ObjectMarshallingStrategyStore;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.InitialFactImpl;
import org.drools.reteoo.LIANodePropagation;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.reteoo.PartitionManager;
import org.drools.reteoo.PartitionTaskManager;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Declaration;
import org.drools.rule.EntryPoint;
import org.drools.rule.Rule;
import org.drools.runtime.Calendars;
import org.drools.runtime.Channel;
import org.drools.runtime.Environment;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.ExitPoint;
import org.drools.runtime.Globals;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.impl.ExecutionResultImpl;
import org.drools.runtime.process.InternalProcessRuntime;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.ProcessRuntimeFactory;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.spi.Activation;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AsyncExceptionHandler;
import org.drools.spi.FactHandleFactory;
import org.drools.spi.GlobalResolver;
import org.drools.time.SessionClock;
import org.drools.time.TimerService;
import org.drools.time.TimerServiceFactory;
import org.drools.type.DateFormats;
import org.drools.type.DateFormatsImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWorkingMemory
implements InternalWorkingMemoryActions,
EventSupport,
ProcessEventManager {
    protected int id;
    protected NodeMemories nodeMemories;
    protected NamedEntryPoint defaultEntryPoint;
    protected GlobalResolver globalResolver;
    protected Calendars calendars;
    protected DateFormats dateFormats;
    protected WorkingMemoryEventSupport workingMemoryEventSupport;
    protected AgendaEventSupport agendaEventSupport;
    protected List __ruleBaseEventListeners;
    protected transient InternalRuleBase ruleBase;
    protected FactHandleFactory handleFactory;
    protected TruthMaintenanceSystem tms;
    protected InternalAgenda agenda;
    protected Queue<WorkingMemoryAction> actionQueue;
    protected AtomicBoolean evaluatingActionQueue;
    protected ReentrantLock lock;
    protected boolean discardOnLogicalOverride;
    protected AtomicLong propagationIdCounter;
    private boolean sequential;
    private List liaPropagations;
    protected volatile AtomicBoolean firing;
    private WorkItemManager workItemManager;
    private TimerService timerService;
    protected Map<String, WorkingMemoryEntryPoint> entryPoints;
    protected InternalFactHandle initialFactHandle;
    protected SessionConfiguration config;
    protected PartitionManager partitionManager;
    protected transient AtomicReference<ExternalExecutorService> threadPool = new AtomicReference();
    private InternalKnowledgeRuntime kruntime;
    private Map<String, ExitPoint> exitPoints;
    private Map<String, Channel> channels;
    private Environment environment;
    private ExecutionResults batchExecutionResult;
    private AtomicLong opCounter;
    private AtomicLong lastIdleTimestamp;
    private InternalProcessRuntime processRuntime;
    private transient ObjectMarshallingStrategyStore marshallingStore;
    private EndOperationListener endOperationListener;

    public AbstractWorkingMemory() {
    }

    public AbstractWorkingMemory(int id, InternalRuleBase ruleBase, FactHandleFactory handleFactory, SessionConfiguration config, Environment environment) {
        this(id, ruleBase, handleFactory, null, 0L, config, environment);
    }

    public AbstractWorkingMemory(int id, InternalRuleBase ruleBase, FactHandleFactory handleFactory, SessionConfiguration config, Environment environment, WorkingMemoryEventSupport workingMemoryEventSupport, AgendaEventSupport agendaEventSupport) {
        this(id, ruleBase, handleFactory, null, 0L, config, environment, workingMemoryEventSupport, agendaEventSupport);
    }

    public AbstractWorkingMemory(int id, InternalRuleBase ruleBase, FactHandleFactory handleFactory, InternalFactHandle initialFactHandle, long propagationContext, SessionConfiguration config, Environment environment) {
        this(id, ruleBase, handleFactory, initialFactHandle, propagationContext, config, environment, new WorkingMemoryEventSupport(), new AgendaEventSupport());
    }

    public AbstractWorkingMemory(int id, InternalRuleBase ruleBase, FactHandleFactory handleFactory, InternalFactHandle initialFactHandle, long propagationContext, SessionConfiguration config, Environment environment, WorkingMemoryEventSupport workingMemoryEventSupport, AgendaEventSupport agendaEventSupport) {
        this.id = id;
        this.config = config;
        this.ruleBase = ruleBase;
        this.handleFactory = handleFactory;
        this.environment = environment;
        Globals globals = (Globals)this.environment.get("drools.Globals");
        this.globalResolver = globals != null ? (!(globals instanceof GlobalResolver) ? new GlobalsAdapter(globals) : (GlobalResolver)globals) : new MapGlobalResolver();
        this.calendars = new CalendarsImpl();
        this.dateFormats = (DateFormats)this.environment.get("org.drools.build.DateFormats");
        if (this.dateFormats == null) {
            this.dateFormats = new DateFormatsImpl();
            this.environment.set("org.drools.build.DateFormats", (Object)this.dateFormats);
        }
        RuleBaseConfiguration conf = this.ruleBase.getConfiguration();
        this.sequential = conf.isSequential();
        this.initialFactHandle = initialFactHandle == null ? handleFactory.newFactHandle(InitialFactImpl.getInstance(), null, this, this) : initialFactHandle;
        this.actionQueue = new ConcurrentLinkedQueue<WorkingMemoryAction>();
        this.evaluatingActionQueue = new AtomicBoolean(false);
        this.workingMemoryEventSupport = workingMemoryEventSupport;
        this.agendaEventSupport = agendaEventSupport;
        this.__ruleBaseEventListeners = new LinkedList();
        this.lock = new ReentrantLock();
        this.liaPropagations = Collections.EMPTY_LIST;
        this.timerService = TimerServiceFactory.getTimerService(this.config);
        this.nodeMemories = new ConcurrentNodeMemories(this.ruleBase);
        this.tms = new TruthMaintenanceSystem(this);
        this.propagationIdCounter = new AtomicLong(propagationContext);
        this.discardOnLogicalOverride = RuleBaseConfiguration.LogicalOverride.DISCARD.equals(conf.getLogicalOverride());
        this.firing = new AtomicBoolean(false);
        this.exitPoints = new ConcurrentHashMap<String, ExitPoint>();
        this.channels = new ConcurrentHashMap<String, Channel>();
        this.initPartitionManagers();
        this.initTransient();
        this.opCounter = new AtomicLong(0L);
        this.lastIdleTimestamp = new AtomicLong(-1L);
        this.initManagementBeans();
    }

    private void initManagementBeans() {
        if (this.ruleBase.getConfiguration().isMBeansEnabled()) {
            DroolsManagementAgent.getInstance().registerKnowledgeSession(this);
        }
    }

    private InternalProcessRuntime createProcessRuntime() {
        try {
            return ProcessRuntimeFactory.newProcessRuntime(this);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getEntryPointId() {
        return EntryPoint.DEFAULT.getEntryPointId();
    }

    @Override
    public void updateEntryPointsCache() {
        Map<EntryPoint, EntryPointNode> reteEPs = this.ruleBase.getRete().getEntryPointNodes();
        HashMap<String, WorkingMemoryEntryPoint> cache = new HashMap<String, WorkingMemoryEntryPoint>(this.entryPoints);
        for (EntryPointNode entryPointNode : reteEPs.values()) {
            EntryPoint id = entryPointNode.getEntryPoint();
            cache.remove(id.getEntryPointId());
            if (EntryPoint.DEFAULT.equals(id) || this.entryPoints.containsKey(id)) continue;
            NamedEntryPoint wmEntryPoint = new NamedEntryPoint(id, entryPointNode, this);
            this.entryPoints.put(entryPointNode.getEntryPoint().getEntryPointId(), wmEntryPoint);
        }
        this.entryPoints.keySet().removeAll(cache.keySet());
    }

    private void initPartitionManagers() {
        if (this.ruleBase.getConfiguration().isMultithreadEvaluation()) {
            this.partitionManager = new PartitionManager(this);
            for (RuleBasePartitionId partitionId : this.ruleBase.getPartitionIds()) {
                this.partitionManager.manage(partitionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPartitionManagers() {
        this.startOperation();
        try {
            if (this.ruleBase.getConfiguration().isMultithreadEvaluation()) {
                int maxThreads;
                int n = maxThreads = this.ruleBase.getConfiguration().getMaxThreads() > 0 ? this.ruleBase.getConfiguration().getMaxThreads() : this.ruleBase.getPartitionIds().size();
                if (this.threadPool.compareAndSet(null, this.createExecutorService(maxThreads))) {
                    this.partitionManager.setPool(this.threadPool.get());
                }
            }
        }
        finally {
            this.endOperation();
        }
    }

    private ExternalExecutorService createExecutorService(int maxThreads) {
        return new ExternalExecutorService(Executors.newFixedThreadPool(maxThreads));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPartitionManagers() {
        this.startOperation();
        try {
            ExternalExecutorService service;
            if (this.ruleBase.getConfiguration().isMultithreadEvaluation() && this.threadPool.compareAndSet(service = this.threadPool.get(), null)) {
                service.shutdown();
                this.partitionManager.shutdown();
            }
        }
        finally {
            this.endOperation();
        }
    }

    public boolean isPartitionManagersActive() {
        return this.threadPool.get() != null;
    }

    private void initTransient() {
        EntryPointNode epn = this.ruleBase.getRete().getEntryPointNode(EntryPoint.DEFAULT);
        this.defaultEntryPoint = new NamedEntryPoint(EntryPoint.DEFAULT, epn, this);
        this.entryPoints = new ConcurrentHashMap<String, WorkingMemoryEntryPoint>();
        this.entryPoints.put("DEFAULT", this.defaultEntryPoint);
        this.updateEntryPointsCache();
    }

    @Override
    public SessionConfiguration getSessionConfiguration() {
        return this.config;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("This should not be called");
    }

    public void reset(int handleId, long handleCounter, long propagationCounter) {
        this.nodeMemories.clear();
        this.agenda.clear();
        for (WorkingMemoryEntryPoint ep : this.entryPoints.values()) {
            InternalWorkingMemoryEntryPoint iep = (InternalWorkingMemoryEntryPoint)((Object)ep);
            iep.reset();
        }
        this.handleFactory.clear(handleId, handleCounter);
        this.tms.clear();
        this.liaPropagations.clear();
        this.actionQueue.clear();
        this.propagationIdCounter = new AtomicLong(propagationCounter);
        this.opCounter.set(0L);
        this.lastIdleTimestamp.set(-1L);
    }

    @Override
    public void setWorkingMemoryEventSupport(WorkingMemoryEventSupport workingMemoryEventSupport) {
        this.workingMemoryEventSupport = workingMemoryEventSupport;
    }

    @Override
    public void setAgendaEventSupport(AgendaEventSupport agendaEventSupport) {
        this.agendaEventSupport = agendaEventSupport;
    }

    @Override
    public boolean isSequential() {
        return this.sequential;
    }

    @Override
    public void addLIANodePropagation(LIANodePropagation liaNodePropagation) {
        if (this.liaPropagations == Collections.EMPTY_LIST) {
            this.liaPropagations = new ArrayList();
        }
        this.liaPropagations.add(liaNodePropagation);
    }

    @Override
    public void addEventListener(WorkingMemoryEventListener listener) {
        this.workingMemoryEventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(WorkingMemoryEventListener listener) {
        this.workingMemoryEventSupport.removeEventListener(listener);
    }

    @Override
    public List getWorkingMemoryEventListeners() {
        return this.workingMemoryEventSupport.getEventListeners();
    }

    @Override
    public void addEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.removeEventListener(listener);
    }

    @Override
    public List getAgendaEventListeners() {
        return this.agendaEventSupport.getEventListeners();
    }

    @Override
    public void addEventListener(RuleBaseEventListener listener) {
        this.ruleBase.addEventListener(listener);
        this.__ruleBaseEventListeners.add(listener);
    }

    public List getRuleBaseEventListeners() {
        return Collections.unmodifiableList(this.__ruleBaseEventListeners);
    }

    @Override
    public void removeEventListener(RuleBaseEventListener listener) {
        this.ruleBase.removeEventListener(listener);
        this.__ruleBaseEventListeners.remove(listener);
    }

    public void addEventListener(ProcessEventListener listener) {
        this.processRuntime.addEventListener(listener);
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.processRuntime.getProcessEventListeners();
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.processRuntime.removeEventListener(listener);
    }

    @Override
    public FactHandleFactory getFactHandleFactory() {
        return this.handleFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobal(String identifier, Object value) {
        if (value == null) {
            return;
        }
        try {
            this.ruleBase.readLock();
            this.lock.lock();
            this.startOperation();
            Map globalDefintions = this.ruleBase.getGlobals();
            Class type = (Class)globalDefintions.get(identifier);
            if (type == null) {
                throw new RuntimeException("Unexpected global [" + identifier + "]");
            }
            if (!type.isInstance(value)) {
                throw new RuntimeException("Illegal class for global. Expected [" + type.getName() + "], " + "found [" + value.getClass().getName() + "].");
            }
            this.globalResolver.setGlobal(identifier, value);
        }
        finally {
            this.endOperation();
            this.lock.unlock();
            this.ruleBase.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalResolver(GlobalResolver globalResolver) {
        try {
            this.lock.lock();
            this.globalResolver = globalResolver;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public GlobalResolver getGlobalResolver() {
        return this.globalResolver;
    }

    @Override
    public Calendars getCalendars() {
        return this.calendars;
    }

    @Override
    public DateFormats getDateFormats() {
        return this.dateFormats;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getGlobal(String identifier) {
        try {
            this.lock.lock();
            Object object = this.globalResolver.resolveGlobal(identifier);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public Agenda getAgenda() {
        return this.agenda;
    }

    @Override
    public void clearAgenda() {
        this.agenda.clearAndCancel();
    }

    @Override
    public void clearAgendaGroup(String group) {
        this.agenda.clearAndCancelAgendaGroup(group);
    }

    @Override
    public void clearActivationGroup(String group) {
        this.agenda.clearAndCancelActivationGroup(group);
    }

    @Override
    public void clearRuleFlowGroup(String group) {
        this.agenda.clearAndCancelRuleFlowGroup(group);
    }

    @Override
    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    @Override
    public void halt() {
        this.agenda.halt();
    }

    @Override
    public int fireAllRules() throws FactException {
        return this.fireAllRules(null, -1);
    }

    @Override
    public int fireAllRules(int fireLimit) throws FactException {
        return this.fireAllRules(null, fireLimit);
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter) throws FactException {
        return this.fireAllRules(agendaFilter, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) throws FactException {
        if (this.firing.compareAndSet(false, true)) {
            try {
                AbstractWorkingMemory abstractWorkingMemory = this;
                synchronized (abstractWorkingMemory) {
                    if (this.isSequential()) {
                        Iterator it = this.liaPropagations.iterator();
                        while (it.hasNext()) {
                            ((LIANodePropagation)it.next()).doPropagation(this);
                        }
                    }
                    this.executeQueuedActions();
                    int fireCount = 0;
                    int n = fireCount = this.agenda.fireAllRules(agendaFilter, fireLimit);
                    return n;
                }
            }
            finally {
                this.firing.set(false);
            }
        }
        return 0;
    }

    public void fireUntilHalt() {
        this.fireUntilHalt(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUntilHalt(AgendaFilter agendaFilter) {
        if (this.isSequential()) {
            throw new IllegalStateException("fireUntilHalt() can not be called in sequential mode.");
        }
        if (this.firing.compareAndSet(false, true)) {
            try {
                AbstractWorkingMemory abstractWorkingMemory = this;
                synchronized (abstractWorkingMemory) {
                    this.executeQueuedActions();
                    this.agenda.fireUntilHalt(agendaFilter);
                }
            }
            finally {
                this.firing.set(false);
            }
        }
    }

    @Override
    public Object getObject(org.drools.runtime.rule.FactHandle handle) {
        return this.defaultEntryPoint.getObject(handle);
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.defaultEntryPoint.getObjectStore();
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        return this.defaultEntryPoint.getFactHandle(object);
    }

    @Override
    public FactHandle getFactHandleByIdentity(Object object) {
        return this.getObjectStore().getHandleForObjectIdentity(object);
    }

    public Iterator iterateObjects() {
        return this.getObjectStore().iterateObjects();
    }

    public Iterator iterateObjects(ObjectFilter filter) {
        return this.getObjectStore().iterateObjects(filter);
    }

    public Iterator iterateFactHandles() {
        return this.getObjectStore().iterateFactHandles();
    }

    public Iterator iterateFactHandles(ObjectFilter filter) {
        return this.getObjectStore().iterateFactHandles(filter);
    }

    public abstract QueryResults getQueryResults(String var1);

    @Override
    public void setFocus(String focus) {
        this.agenda.setFocus(focus);
    }

    @Override
    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.tms;
    }

    @Override
    public FactHandle insert(Object object) throws FactException {
        return this.insert(object, false, false, null, null);
    }

    public FactHandle insertLogical(Object object) throws FactException {
        return this.insert(object, false, true, null, null);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic) throws FactException {
        return this.insert(object, dynamic, false, null, null);
    }

    @Override
    public FactHandle insertLogical(Object object, boolean dynamic) throws FactException {
        return this.insert(object, dynamic, true, null, null);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic, boolean logical, Rule rule, Activation activation) throws FactException {
        return this.defaultEntryPoint.insert(object, dynamic, logical, rule, activation);
    }

    @Override
    public void insert(InternalFactHandle handle, Object object, Rule rule, Activation activation, ObjectTypeConf typeConf) {
        this.defaultEntryPoint.insert(handle, object, rule, activation, typeConf);
    }

    @Override
    public void retract(org.drools.runtime.rule.FactHandle handle) throws FactException {
        this.retract((FactHandle)handle, true, true, null, null);
    }

    @Override
    public void retract(FactHandle factHandle, boolean removeLogical, boolean updateEqualsMap, Rule rule, Activation activation) throws FactException {
        this.defaultEntryPoint.retract(factHandle, removeLogical, updateEqualsMap, rule, activation);
    }

    @Override
    public EntryPointNode getEntryPointNode() {
        return this.defaultEntryPoint.getEntryPointNode();
    }

    @Override
    public void update(org.drools.runtime.rule.FactHandle handle, Object object) throws FactException {
        this.update((FactHandle)handle, object, (Rule)null, (Activation)null);
    }

    @Override
    public void update(org.drools.runtime.rule.FactHandle factHandle, Object object, Rule rule, Activation activation) throws FactException {
        this.update((FactHandle)factHandle, object, rule, activation);
    }

    @Override
    public void update(FactHandle factHandle, Object object, Rule rule, Activation activation) throws FactException {
        this.defaultEntryPoint.update(factHandle, object, rule, activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void executeQueuedActions() {
        try {
            this.startOperation();
            if (!this.evaluatingActionQueue.compareAndSet(false, true)) return;
            try {
                if (this.actionQueue.isEmpty()) return;
                WorkingMemoryAction action = null;
                while ((action = this.actionQueue.poll()) != null) {
                    try {
                        action.execute(this);
                    }
                    catch (Exception e) {
                        throw new RuntimeDroolsException("Unexpected exception executing action " + action.toString(), e);
                        return;
                    }
                }
            }
            finally {
                this.evaluatingActionQueue.compareAndSet(true, false);
            }
        }
        finally {
            this.endOperation();
        }
    }

    public Queue<WorkingMemoryAction> getActionQueue() {
        return this.actionQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueWorkingMemoryAction(WorkingMemoryAction action) {
        try {
            this.startOperation();
            this.actionQueue.add(action);
            this.agenda.notifyHalt();
        }
        finally {
            this.endOperation();
        }
    }

    @Override
    public Object getNodeMemory(NodeMemory node) {
        return this.nodeMemories.getNodeMemory(node);
    }

    @Override
    public void clearNodeMemory(NodeMemory node) {
        this.nodeMemories.clearNodeMemory(node);
    }

    @Override
    public WorkingMemoryEventSupport getWorkingMemoryEventSupport() {
        return this.workingMemoryEventSupport;
    }

    @Override
    public AgendaEventSupport getAgendaEventSupport() {
        return this.agendaEventSupport;
    }

    @Override
    public void setAsyncExceptionHandler(AsyncExceptionHandler handler) {
    }

    @Override
    public long getNextPropagationIdCounter() {
        return this.propagationIdCounter.incrementAndGet();
    }

    public long getPropagationIdCounter() {
        return this.propagationIdCounter.get();
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public InternalProcessRuntime getProcessRuntime() {
        return this.processRuntime;
    }

    @Override
    public ProcessInstance startProcess(String processId) {
        return this.processRuntime.startProcess(processId);
    }

    @Override
    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return this.processRuntime.startProcess(processId, parameters);
    }

    public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return this.processRuntime.createProcessInstance(processId, parameters);
    }

    public ProcessInstance startProcessInstance(long processInstanceId) {
        return this.processRuntime.startProcessInstance(processInstanceId);
    }

    @Override
    public Collection<ProcessInstance> getProcessInstances() {
        return this.processRuntime.getProcessInstances();
    }

    @Override
    public ProcessInstance getProcessInstance(long processInstanceId) {
        return this.processRuntime.getProcessInstance(processInstanceId);
    }

    @Override
    public WorkItemManager getWorkItemManager() {
        if (this.workItemManager == null) {
            this.workItemManager = this.config.getWorkItemManagerFactory().createWorkItemManager(this.getKnowledgeRuntime());
            Map<String, WorkItemHandler> workItemHandlers = this.config.getWorkItemHandlers();
            if (workItemHandlers != null) {
                for (Map.Entry<String, WorkItemHandler> entry : workItemHandlers.entrySet()) {
                    this.workItemManager.registerWorkItemHandler(entry.getKey(), entry.getValue());
                }
            }
        }
        return this.workItemManager;
    }

    public List iterateObjectsToList() {
        ArrayList result = new ArrayList();
        Iterator iterator = this.iterateObjects();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public List iterateNonDefaultEntryPointObjectsToList() {
        ArrayList<EntryPointObjects> result = new ArrayList<EntryPointObjects>();
        for (Map.Entry<String, WorkingMemoryEntryPoint> entry : this.getEntryPoints().entrySet()) {
            WorkingMemoryEntryPoint entryPoint = entry.getValue();
            if (!(entryPoint instanceof NamedEntryPoint)) continue;
            result.add(new EntryPointObjects(entry.getKey(), new ArrayList(entry.getValue().getObjects())));
        }
        return result;
    }

    public Map.Entry[] getActivationParameters(long activationId) {
        Activation[] activations = this.getAgenda().getActivations();
        for (int i = 0; i < activations.length; ++i) {
            if (activations[i].getActivationNumber() != activationId) continue;
            Map params = this.getActivationParameters(activations[i]);
            return params.entrySet().toArray(new Map.Entry[params.size()]);
        }
        return new Map.Entry[0];
    }

    public Map getActivationParameters(Activation activation) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Declaration[] declarations = ((RuleTerminalNode)activation.getTuple().getLeftTupleSink()).getDeclarations();
        for (int i = 0; i < declarations.length; ++i) {
            InternalFactHandle handle = activation.getTuple().get(declarations[i]);
            if (!(handle instanceof InternalFactHandle)) continue;
            result.put(declarations[i].getIdentifier(), declarations[i].getValue(this, handle.getObject()));
        }
        return result;
    }

    @Override
    public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String name) {
        WorkingMemoryEntryPoint wmEntryPoint = this.entryPoints.get(name);
        return wmEntryPoint;
    }

    public Collection<WorkingMemoryEntryPoint> getWorkingMemoryEntryPoints() {
        return this.entryPoints.values();
    }

    @Override
    public ObjectTypeConfigurationRegistry getObjectTypeConfigurationRegistry() {
        return this.defaultEntryPoint.getObjectTypeConfigurationRegistry();
    }

    @Override
    public InternalFactHandle getInitialFactHandle() {
        return this.initialFactHandle;
    }

    public void setInitialFactHandle(InternalFactHandle initialFactHandle) {
        this.initialFactHandle = initialFactHandle;
    }

    @Override
    public TimerService getTimerService() {
        return this.timerService;
    }

    @Override
    public SessionClock getSessionClock() {
        return (SessionClock)this.timerService;
    }

    @Override
    public PartitionTaskManager getPartitionTaskManager(RuleBasePartitionId partitionId) {
        return this.partitionManager.getPartitionTaskManager(partitionId);
    }

    @Override
    public void startBatchExecution(ExecutionResultImpl results) {
        this.ruleBase.readLock();
        this.lock.lock();
        this.batchExecutionResult = results;
    }

    @Override
    public ExecutionResultImpl getExecutionResult() {
        return (ExecutionResultImpl)this.batchExecutionResult;
    }

    @Override
    public void endBatchExecution() {
        this.batchExecutionResult = null;
        this.lock.unlock();
        this.ruleBase.readUnlock();
    }

    public void dispose() {
        if (this.ruleBase.getConfiguration().isMBeansEnabled()) {
            DroolsManagementAgent.getInstance().unregisterKnowledgeSession(this);
        }
        this.workingMemoryEventSupport.reset();
        this.agendaEventSupport.reset();
        Iterator it = this.__ruleBaseEventListeners.iterator();
        while (it.hasNext()) {
            this.ruleBase.removeEventListener((RuleBaseEventListener)it.next());
        }
        this.stopPartitionManagers();
        if (this.processRuntime != null) {
            this.processRuntime.dispose();
        }
    }

    @Override
    public void setKnowledgeRuntime(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
        this.processRuntime = this.createProcessRuntime();
    }

    @Override
    public InternalKnowledgeRuntime getKnowledgeRuntime() {
        return this.kruntime;
    }

    @Deprecated
    public void registerExitPoint(String name, ExitPoint exitPoint) {
        this.exitPoints.put(name, exitPoint);
    }

    @Deprecated
    public void unregisterExitPoint(String name) {
        this.exitPoints.remove(name);
    }

    @Override
    @Deprecated
    public Map<String, ExitPoint> getExitPoints() {
        return this.exitPoints;
    }

    public void registerChannel(String name, Channel channel) {
        this.channels.put(name, channel);
    }

    public void unregisterChannel(String name) {
        this.channels.remove(name);
    }

    @Override
    public Map<String, Channel> getChannels() {
        return this.channels;
    }

    public Map<String, WorkingMemoryEntryPoint> getEntryPoints() {
        return this.entryPoints;
    }

    public long getFactCount() {
        return this.getObjectStore().size();
    }

    @Override
    public long getTotalFactCount() {
        long result = 0L;
        for (WorkingMemoryEntryPoint ep : this.entryPoints.values()) {
            result += ep.getFactCount();
        }
        return result;
    }

    @Override
    public void startOperation() {
        if (this.opCounter.getAndIncrement() == 0L) {
            this.lastIdleTimestamp.set(-1L);
        }
    }

    public void setEndOperationListener(EndOperationListener listener) {
        this.endOperationListener = listener;
    }

    @Override
    public void endOperation() {
        if (this.opCounter.decrementAndGet() == 0L) {
            this.lastIdleTimestamp.set(this.timerService.getCurrentTime());
            if (this.endOperationListener != null) {
                this.endOperationListener.endOperation(this.getKnowledgeRuntime());
            }
        }
    }

    @Override
    public long getIdleTime() {
        long lastIdle = this.lastIdleTimestamp.get();
        return lastIdle > -1L ? this.timerService.getCurrentTime() - lastIdle : -1L;
    }

    public long getLastIdleTimestamp() {
        return this.lastIdleTimestamp.get();
    }

    @Override
    public long getTimeToNextJob() {
        return this.timerService.getTimeToNextJob();
    }

    @Override
    public void prepareToFireActivation() {
        if (this.partitionManager != null) {
            this.partitionManager.holdTasks();
            this.partitionManager.waitForPendingTasks();
        }
    }

    @Override
    public void activationFired() {
        if (this.partitionManager != null) {
            this.partitionManager.releaseTasks();
        }
    }

    public ObjectMarshallingStrategyStore getObjectMarshallingStrategyStore() {
        if (this.marshallingStore == null) {
            this.marshallingStore = new ObjectMarshallingStrategyStore((ObjectMarshallingStrategy[])this.environment.get("drools.marshalling.ObjectMarshallingStrategies"));
        }
        return this.marshallingStore;
    }

    private class EntryPointObjects {
        private String name;
        private List objects;

        public EntryPointObjects(String name, List objects) {
            this.name = name;
            this.objects = objects;
        }
    }

    public class RuleFlowDeactivateEvent {
        public void propagate() {
        }
    }

    public static class GlobalsAdapter
    implements GlobalResolver {
        private Globals globals;

        public GlobalsAdapter(Globals globals) {
            this.globals = globals;
        }

        public Object resolveGlobal(String identifier) {
            return this.globals.get(identifier);
        }

        public void setGlobal(String identifier, Object value) {
            this.globals.set(identifier, value);
        }
    }
}

