/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.common.InternalFactHandle;
import org.drools.core.util.Entry;
import org.drools.core.util.RightTupleList;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTupleSink;

public class RightTuple
implements Entry {
    protected InternalFactHandle handle;
    private RightTuple handlePrevious;
    private RightTuple handleNext;
    private RightTupleList memory;
    private Entry previous;
    private Entry next;
    public LeftTuple firstChild;
    public LeftTuple lastChild;
    private LeftTuple blocked;
    protected RightTupleSink sink;

    public RightTuple() {
    }

    public RightTuple(InternalFactHandle handle) {
        this.handle = handle;
    }

    public RightTuple(InternalFactHandle handle, RightTupleSink sink) {
        this.handle = handle;
        this.sink = sink;
        RightTuple last = handle.getLastRightTuple();
        if (last == null) {
            handle.setFirstRightTuple(this);
            handle.setLastRightTuple(this);
        } else {
            this.handlePrevious = last;
            last.setHandleNext(this);
            this.handle.setLastRightTuple(this);
        }
    }

    public RightTupleSink getRightTupleSink() {
        return this.sink;
    }

    public void reAdd() {
        RightTuple last = this.handle.getLastRightTuple();
        if (last == null) {
            this.handle.setFirstRightTuple(this);
            this.handle.setLastRightTuple(this);
        } else {
            this.handleNext = null;
            this.handlePrevious = last;
            last.setHandleNext(this);
            this.handle.setLastRightTuple(this);
        }
    }

    public void unlinkFromRightParent() {
        RightTuple previousParent = this.handlePrevious;
        RightTuple nextParent = this.handleNext;
        if (previousParent != null && nextParent != null) {
            this.handlePrevious.handleNext = nextParent;
            this.handleNext.handlePrevious = previousParent;
        } else if (nextParent != null) {
            this.handleNext.handlePrevious = null;
            this.handle.setFirstRightTuple(this.handleNext);
        } else if (previousParent != null) {
            this.handlePrevious.handleNext = null;
            this.handle.setLastRightTuple(this.handlePrevious);
        } else {
            this.handle.setFirstRightTuple(null);
            this.handle.setLastRightTuple(null);
        }
        this.handle = null;
        this.handlePrevious = null;
        this.handleNext = null;
        this.blocked = null;
        this.previous = null;
        this.next = null;
        this.memory = null;
        this.firstChild = null;
        this.lastChild = null;
        this.sink = null;
    }

    public InternalFactHandle getFactHandle() {
        return this.handle;
    }

    public LeftTuple getBlocked() {
        return this.blocked;
    }

    public void nullBlocked() {
        this.blocked = null;
    }

    public void addBlocked(LeftTuple leftTuple) {
        if (this.blocked != null && leftTuple != null) {
            leftTuple.setBlockedNext(this.blocked);
            this.blocked.setBlockedPrevious(leftTuple);
        }
        this.blocked = leftTuple;
    }

    public void removeBlocked(LeftTuple leftTuple) {
        LeftTuple previous = leftTuple.getBlockedPrevious();
        LeftTuple next = leftTuple.getBlockedNext();
        if (previous != null && next != null) {
            previous.setBlockedNext(next);
            next.setBlockedPrevious(previous);
        } else if (next != null) {
            this.blocked = next;
            next.setBlockedPrevious(null);
        } else if (previous != null) {
            previous.setBlockedNext(null);
        } else {
            this.blocked = null;
        }
    }

    public RightTupleList getMemory() {
        return this.memory;
    }

    public void setMemory(RightTupleList memory) {
        this.memory = memory;
    }

    public Entry getPrevious() {
        return this.previous;
    }

    public void setPrevious(Entry previous) {
        this.previous = previous;
    }

    public RightTuple getHandlePrevious() {
        return this.handlePrevious;
    }

    public void setHandlePrevious(RightTuple handlePrevious) {
        this.handlePrevious = handlePrevious;
    }

    public RightTuple getHandleNext() {
        return this.handleNext;
    }

    public void setHandleNext(RightTuple handleNext) {
        this.handleNext = handleNext;
    }

    public Entry getNext() {
        return this.next;
    }

    public void setNext(Entry next) {
        this.next = next;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return this.handle.toString() + "\n";
    }

    public boolean equals(RightTuple other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.hashCode() != other.hashCode()) {
            return false;
        }
        return this.handle == other.handle;
    }

    public boolean equals(Object object) {
        return this.equals((RightTuple)object);
    }
}

