/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.changeset;

import java.util.Collection;
import java.util.HashSet;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.impl.BaseResource;
import org.drools.io.impl.ClassPathResource;
import org.drools.io.impl.KnowledgeResource;
import org.drools.io.impl.URLClassPathResource;
import org.drools.io.impl.UrlResource;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHandler
extends BaseAbstractHandler
implements Handler {
    public ResourceHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet(1);
            this.validParents.add(Collection.class);
            this.validPeers = new HashSet(2);
            this.validPeers.add(null);
            this.validPeers.add(Resource.class);
            this.allowNesting = true;
        }
    }

    @Override
    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        Collection collection = (Collection)parser.getParent();
        String src = attrs.getValue("source");
        String type = attrs.getValue("type");
        String basicAuthentication = attrs.getValue("basicAuthentication");
        String username = attrs.getValue("username");
        String password = attrs.getValue("password");
        this.emptyAttributeCheck(localName, "source", src, parser);
        this.emptyAttributeCheck(localName, "type", type, parser);
        BaseResource resource = null;
        if (src.trim().startsWith("classpath:")) {
            resource = new ClassPathResource(src.substring(src.indexOf(58) + 1));
        } else if (src.trim().startsWith("URLClasspath:")) {
            resource = new URLClassPathResource(src.substring(src.indexOf(58) + 1));
        } else {
            resource = new UrlResource(src);
            ((UrlResource)resource).setBasicAuthentication(basicAuthentication);
            ((UrlResource)resource).setUsername(username);
            ((UrlResource)resource).setPassword(password);
        }
        resource.setResourceType(ResourceType.getResourceType((String)type));
        return resource;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Collection collection = (Collection)parser.getParent();
        Resource resource = (Resource)parser.getCurrent();
        collection.add(resource);
        return resource;
    }

    @Override
    public Class<?> generateNodeFor() {
        return KnowledgeResource.class;
    }
}

