/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.drools.RuntimeDroolsException;
import org.drools.base.EnabledBoolean;
import org.drools.base.SalienceInteger;
import org.drools.compiler.RuleBuildError;
import org.drools.core.util.DateUtils;
import org.drools.core.util.StringUtils;
import org.drools.lang.descr.AnnotationDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.GroupElement;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.spi.Salience;
import org.drools.time.TimeUtils;
import org.drools.time.impl.CronExpression;
import org.drools.time.impl.CronTimer;
import org.drools.time.impl.IntervalTimer;
import org.drools.time.impl.Timer;
import org.drools.type.DateFormats;
import org.mvel2.MVEL;

public class RuleBuilder {
    public void build(RuleBuildContext context) {
        Pattern prefixPattern;
        RuleDescr ruleDescr = context.getRuleDescr();
        if (null != ruleDescr.getParentName() && null != context.getPkg().getRule(ruleDescr.getParentName())) {
            context.getRule().setParent(context.getPkg().getRule(ruleDescr.getParentName()));
        }
        this.buildMetaAttributes(context);
        RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(ruleDescr.getLhs().getClass());
        if (builder != null) {
            prefixPattern = null;
            if (context.getRuleDescr() instanceof QueryDescr) {
                prefixPattern = context.getDialect().getQueryBuilder().build(context, (QueryDescr)context.getRuleDescr());
            }
        } else {
            throw new RuntimeDroolsException("BUG: builder not found for descriptor class " + ruleDescr.getLhs().getClass());
        }
        GroupElement ce = (GroupElement)builder.build(context, ruleDescr.getLhs(), prefixPattern);
        context.getRule().setLhs(ce);
        this.buildAttributes(context);
        if (!(ruleDescr instanceof QueryDescr)) {
            ConsequenceBuilder consequenceBuilder = context.getDialect().getConsequenceBuilder();
            consequenceBuilder.build(context, "default");
            for (String name : ruleDescr.getNamedConsequences().keySet()) {
                consequenceBuilder.build(context, name);
            }
        }
    }

    public void buildMetaAttributes(RuleBuildContext context) {
        Rule rule = context.getRule();
        for (String metaAttr : context.getRuleDescr().getAnnotationNames()) {
            Object value = this.resolveValue((String)context.getRuleDescr().getAnnotation(metaAttr).getValue());
            rule.addMetaAttribute(metaAttr, value);
        }
    }

    private Object resolveValue(String value) {
        Object result = value;
        try {
            Object resolvedValue;
            result = resolvedValue = MVEL.eval((String)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void buildAttributes(RuleBuildContext context) {
        Rule rule = context.getRule();
        RuleDescr ruleDescr = context.getRuleDescr();
        for (AttributeDescr attributeDescr : ruleDescr.getAttributes().values()) {
            Calendar cal;
            String name = attributeDescr.getName();
            if (name.equals("no-loop")) {
                rule.setNoLoop(this.getBooleanValue(attributeDescr, true));
                continue;
            }
            if (name.equals("auto-focus")) {
                rule.setAutoFocus(this.getBooleanValue(attributeDescr, true));
                continue;
            }
            if (name.equals("agenda-group")) {
                rule.setAgendaGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("activation-group")) {
                rule.setActivationGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("ruleflow-group")) {
                rule.setRuleFlowGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("lock-on-active")) {
                rule.setLockOnActive(this.getBooleanValue(attributeDescr, true));
                continue;
            }
            if (name.equals("duration") || name.equals("timer")) {
                String duration = attributeDescr.getValue();
                this.buildTimer(rule, duration, context);
                continue;
            }
            if (name.equals("calendars")) {
                this.buildCalendars(rule, attributeDescr.getValue(), context);
                continue;
            }
            if (name.equals("date-effective")) {
                cal = Calendar.getInstance();
                cal.setTime(DateUtils.parseDate((String)attributeDescr.getValue(), (DateFormats)context.getPackageBuilder().getDateFormats()));
                rule.setDateEffective(cal);
                continue;
            }
            if (!name.equals("date-expires")) continue;
            cal = Calendar.getInstance();
            cal.setTime(DateUtils.parseDate((String)attributeDescr.getValue(), (DateFormats)context.getPackageBuilder().getDateFormats()));
            rule.setDateExpires(cal);
        }
        this.buildSalience(context);
        this.buildEnabled(context);
        AnnotationDescr ann = ruleDescr.getAnnotation("activationListener");
        if (ann != null && !StringUtils.isEmpty((CharSequence)((String)ann.getValue()))) {
            rule.setActivationListener(MVEL.evalToString((String)((String)ann.getValue())));
        }
    }

    private boolean getBooleanValue(AttributeDescr attributeDescr, boolean defaultValue) {
        return attributeDescr.getValue() == null || "".equals(attributeDescr.getValue().trim()) ? defaultValue : Boolean.valueOf(attributeDescr.getValue());
    }

    private void buildEnabled(RuleBuildContext context) {
        String enabledText = context.getRuleDescr().getEnabled();
        if (enabledText != null) {
            if ("true".equalsIgnoreCase(enabledText.trim()) || "false".equalsIgnoreCase(enabledText.trim())) {
                if (Boolean.parseBoolean(enabledText)) {
                    context.getRule().setEnabled(EnabledBoolean.ENABLED_TRUE);
                } else {
                    context.getRule().setEnabled(EnabledBoolean.ENABLED_FALSE);
                }
            } else {
                context.getDialect().getEnabledBuilder().build(context);
            }
        }
    }

    private void buildSalience(RuleBuildContext context) {
        String salienceText = context.getRuleDescr().getSalience();
        if (salienceText != null && !salienceText.equals("")) {
            try {
                SalienceInteger salience = new SalienceInteger(Integer.parseInt(salienceText));
                context.getRule().setSalience((Salience)salience);
            }
            catch (Exception e) {
                context.getDialect().getSalienceBuilder().build(context);
            }
        }
    }

    private void buildCalendars(Rule rule, String calendarsString, RuleBuildContext context) {
        Object val = null;
        try {
            val = MVEL.eval((String)calendarsString);
            String[] calNames = null;
            if (val instanceof List) {
                calNames = ((List)val).toArray(new String[((List)val).size()]);
            } else if (val instanceof String) {
                calNames = new String[]{(String)val};
            } else {
                context.getErrors().add("Calendars attribute did not return a String or String[] '" + val + "'");
            }
            if (calNames != null) {
                rule.setCalendars(calNames);
            }
        }
        catch (Exception e) {
            context.getErrors().add("Unable to build Calendars attribute '" + val + "'" + e.getMessage());
        }
    }

    private void buildTimer(Rule rule, String timerString, RuleBuildContext context) {
        int equalsPos;
        int p;
        if (timerString.indexOf(40) >= 0) {
            timerString = timerString.substring(timerString.indexOf(40) + 1, timerString.lastIndexOf(41)).trim();
        }
        int colonPos = timerString.indexOf(":");
        String protocol = null;
        protocol = colonPos == -1 ? "int" : timerString.substring(0, colonPos);
        int startPos = timerString.indexOf("start");
        int endPos = timerString.indexOf("end");
        int repeatPos = timerString.indexOf("repeat-limit");
        Date startDate = null;
        Date endDate = null;
        int repeatLimit = -1;
        int optionsPos = timerString.length();
        if (startPos != -1) {
            optionsPos = startPos;
            int n = p = endPos != -1 && endPos < repeatPos ? endPos : repeatPos;
            if (p == -1) {
                p = timerString.length();
            }
            equalsPos = timerString.indexOf(61, startPos);
            startDate = DateUtils.parseDate((String)timerString.substring(equalsPos + 1, p).trim(), (DateFormats)context.getPackageBuilder().getDateFormats());
        }
        if (endPos != -1) {
            if (optionsPos > endPos) {
                optionsPos = endPos;
            }
            int n = p = startPos != -1 && startPos < repeatPos ? startPos : repeatPos;
            if (p == -1) {
                p = timerString.length();
            }
            equalsPos = timerString.indexOf(61, endPos);
            endDate = DateUtils.parseDate((String)timerString.substring(equalsPos + 1, p).trim(), (DateFormats)context.getPackageBuilder().getDateFormats());
        }
        if (repeatPos != -1) {
            if (optionsPos > repeatPos) {
                optionsPos = repeatPos;
            }
            int n = p = startPos != -1 && startPos < endPos ? startPos : endPos;
            if (p == -1) {
                p = timerString.length();
            }
            equalsPos = timerString.indexOf(61, repeatPos);
            repeatLimit = Integer.parseInt(timerString.substring(equalsPos + 1, p).trim());
        }
        String body = timerString.substring(colonPos + 1, optionsPos).trim();
        CronTimer timer = null;
        if ("cron".equals(protocol)) {
            try {
                timer = new CronTimer(startDate, endDate, repeatLimit, new CronExpression(body));
            }
            catch (ParseException e) {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Unable to build set timer '" + timerString + "'");
                context.getErrors().add(err);
                return;
            }
        } else if ("int".equals(protocol)) {
            String[] times = body.trim().split("\\s");
            long delay = 0L;
            long period = 0L;
            if (times.length == 1) {
                delay = TimeUtils.parseTimeString((String)times[0]);
            } else if (times.length == 2) {
                delay = TimeUtils.parseTimeString((String)times[0]);
                period = TimeUtils.parseTimeString((String)times[1]);
            } else {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Incorrect number of arguments for interval timer '" + timerString + "'");
                context.getErrors().add(err);
                return;
            }
            timer = new IntervalTimer(startDate, endDate, repeatLimit, delay, period);
        } else {
            context.getErrors().add("Protocol for timer does not exist '" + timerString + "'");
            return;
        }
        rule.setTimer((Timer)timer);
    }
}

