/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.util.Arrays;
import org.drools.factmodel.BuildUtils;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.factmodel.traits.TraitClassBuilder;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.MethodVisitor;

public class TraitClassBuilderImpl
implements TraitClassBuilder {
    public byte[] buildClass(ClassDefinition classDef) {
        ClassWriter cw = new ClassWriter(0);
        try {
            String cName = BuildUtils.getInternalType(classDef.getClassName());
            String genericTypes = BuildUtils.getGenericTypes(classDef.getInterfaces());
            String superType = BuildUtils.getInternalType("java.lang.Object");
            String[] intfaces = null;
            if (Object.class.getName().equals(classDef.getSuperClass())) {
                intfaces = BuildUtils.getInternalTypes(classDef.getInterfaces());
            } else {
                intfaces = BuildUtils.getInternalTypes(classDef.getInterfaces());
                intfaces = Arrays.copyOf(intfaces, intfaces.length + 1);
                intfaces[intfaces.length - 1] = BuildUtils.getInternalType(classDef.getSuperClass());
            }
            cw.visit(49, 1537, cName, genericTypes, superType, intfaces);
            for (FieldDefinition field : classDef.getFieldsDefinitions()) {
                String name = field.getName();
                name = name.substring(0, 1).toUpperCase() + name.substring(1);
                String target = BuildUtils.getTypeDescriptor(field.getTypeName());
                String prefix = BuildUtils.isBoolean(field.getTypeName()) ? "is" : "get";
                MethodVisitor mv = cw.visitMethod(1025, prefix + name, "()" + target, null, null);
                mv.visitEnd();
                mv = cw.visitMethod(1025, "set" + name, "(" + target + ")V", null, null);
                mv.visitEnd();
            }
            cw.visitEnd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cw.toByteArray();
    }
}

