/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.sudoku;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.drools.KnowledgeBase;
import org.drools.examples.sudoku.Sudoku;
import org.drools.examples.sudoku.rules.DroolsUtil;
import org.drools.examples.sudoku.swing.SudokuGridSamples;
import org.drools.examples.sudoku.swing.SudokuGridView;

public class SudokuExample
implements ActionListener {
    private JFrame mainFrame;
    private SudokuGridView sudokuGridView;
    private Sudoku sudoku;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu("File");
    private JMenu samplesMenu = new JMenu("Samples");
    private JMenuItem openMenuItem = new JMenuItem("Open...");
    private JMenuItem exitMenuItem = new JMenuItem("Exit");
    private BorderLayout borderLayout = new BorderLayout();
    private FlowLayout flowLayout = new FlowLayout(2);
    private JPanel buttonPanel = new JPanel(this.flowLayout);
    private JButton solveButton = new JButton("Solve");
    private JButton stepButton = new JButton("Step");
    private JButton dumpButton = new JButton("Dump");
    private JFileChooser fileChooser;

    public static void main(String[] args) {
        try {
            SudokuExample main = new SudokuExample();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SudokuExample() throws Exception {
        this.mainFrame = new JFrame("Drools Sudoku Example");
        for (String sampleName : SudokuGridSamples.getInstance().getSampleNames()) {
            JMenuItem menuItem = new JMenuItem(sampleName);
            menuItem.addActionListener(this);
            this.samplesMenu.add(menuItem);
        }
        this.fileMenu.add(this.samplesMenu);
        this.openMenuItem.addActionListener(this);
        this.fileMenu.add(this.openMenuItem);
        this.exitMenuItem.addActionListener(this);
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.mainFrame.setJMenuBar(this.menuBar);
        this.sudokuGridView = new SudokuGridView();
        KnowledgeBase kBase = DroolsUtil.readKnowledgeBase("/org/drools/examples/sudoku/sudoku.drl", "/org/drools/examples/sudoku/validate.drl");
        this.sudoku = new Sudoku(kBase);
        this.mainFrame.setLayout(this.borderLayout);
        this.mainFrame.add("Center", this.sudokuGridView);
        this.buttonPanel.add(this.solveButton);
        this.solveButton.addActionListener(this);
        this.buttonPanel.add(this.stepButton);
        this.stepButton.addActionListener(this);
        this.buttonPanel.add(this.dumpButton);
        this.buttonsActive(false);
        this.dumpButton.addActionListener(this);
        this.mainFrame.add("South", this.buttonPanel);
        this.mainFrame.setSize(400, 400);
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setResizable(false);
        this.mainFrame.setVisible(true);
        this.sudokuGridView.setModel(this.sudoku);
    }

    private void buttonsActive(boolean active) {
        this.solveButton.setEnabled(active);
        this.stepButton.setEnabled(active);
        this.dumpButton.setEnabled(active);
    }

    private void runFile(String path) {
        Integer[][] values = new Integer[9][];
        try {
            FileReader fr = new FileReader(path);
            BufferedReader rdr = new BufferedReader(fr);
            String line = rdr.readLine();
            for (int iRow = 0; iRow < 9; ++iRow) {
                values[iRow] = new Integer[9];
                for (int iCol = 0; iCol < 9; ++iCol) {
                    char c;
                    if (line == null || line.length() <= iCol || '1' > (c = line.charAt(iCol)) || c > '9') continue;
                    values[iRow][iCol] = c - 48;
                }
                line = rdr.readLine();
            }
            this.sudoku.setCellValues(values);
            this.sudoku.validate();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource().equals(this.solveButton)) {
            this.sudoku.solve();
            this.buttonsActive(false);
            if (!this.sudoku.isSolved()) {
                this.sudoku.dumpGrid();
                System.out.println("Sorry - can't solve this grid.");
            }
        } else if (ev.getSource().equals(this.stepButton)) {
            this.sudoku.step();
            if (this.sudoku.isSolved() || this.sudoku.isUnsolvable()) {
                this.buttonsActive(false);
            }
            if (this.sudoku.isUnsolvable()) {
                this.sudoku.dumpGrid();
                System.out.println("Sorry - can't solve this grid.");
            }
        } else if (ev.getSource().equals(this.dumpButton)) {
            this.sudoku.dumpGrid();
        } else if (ev.getSource().equals(this.openMenuItem)) {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
            }
            try {
                if (this.fileChooser.showOpenDialog(this.mainFrame) == 0) {
                    String path = this.fileChooser.getSelectedFile().getCanonicalPath();
                    System.out.println(path);
                    this.runFile(path);
                    this.buttonsActive(true);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (ev.getSource().equals(this.exitMenuItem)) {
            System.exit(0);
        } else if (ev.getSource() instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)ev.getSource();
            this.sudoku.setCellValues(SudokuGridSamples.getInstance().getSample(menuItem.getText()));
            this.sudoku.validate();
            this.buttonsActive(true);
        }
    }
}

