/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.wumpus;

import java.util.ArrayList;
import java.util.Random;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.examples.wumpus.Cell;
import org.drools.examples.wumpus.Gold;
import org.drools.examples.wumpus.Hero;
import org.drools.examples.wumpus.Pitt;
import org.drools.examples.wumpus.Wumpus;
import org.drools.examples.wumpus.view.GameUI;
import org.drools.examples.wumpus.view.GameView;
import org.drools.examples.wumpus.view.SensorsView;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;

public class WumpusWorldServer {
    public static void main(String[] args) throws InterruptedException {
        WumpusWorldServer ww = new WumpusWorldServer();
        ww.init();
    }

    public void init() throws InterruptedException {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource("commands.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("failed to build:\n" + kbuilder.getErrors().toString());
        }
        kbuilder.add(ResourceFactory.newClassPathResource("sensors.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("failed to build:\n" + kbuilder.getErrors().toString());
        }
        kbuilder.add(ResourceFactory.newClassPathResource("collision.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("failed to build:\n" + kbuilder.getErrors().toString());
        }
        kbuilder.add(ResourceFactory.newClassPathResource("ui.drl", GameView.class), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("failed to build:\n" + kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        GameView data = new GameView();
        data.setKbase(kbase);
        data.setWumpusWorld(this);
        this.setData(data);
        GameUI.run(data);
    }

    public void setData(GameView data) {
        KnowledgeBase kbase = data.getKbase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        KnowledgeRuntimeLogger klogger = KnowledgeRuntimeLoggerFactory.newFileLogger(ksession, "log/wumpus");
        data.setKlogger(klogger);
        ArrayList<Pitt> pitts = new ArrayList<Pitt>();
        Random gen = new Random();
        Cell[][] cells = new Cell[5][5];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                Cell cell;
                cells[i][j] = cell = new Cell(i, j);
                if (i == 0 && j == 0) {
                    cell.setHidden(false);
                }
                ksession.insert(cell);
                if (j == 0 || i == 0 || gen.nextInt(99) > 19) continue;
                Pitt pitt = new Pitt(i, j);
                ksession.insert(pitt);
                pitts.add(pitt);
            }
        }
        int row = 0;
        int col = 0;
        while (row == 0 && col == 0 || pitts.contains(new Pitt(row, col))) {
            row = gen.nextInt(4);
            col = gen.nextInt(4);
        }
        Wumpus wumpus = new Wumpus(row, col);
        row = 0;
        col = 0;
        while (row == 0 && col == 0 || wumpus.getRow() == row && wumpus.getCol() == col || pitts.contains(new Pitt(row, col))) {
            row = gen.nextInt(4);
            col = gen.nextInt(4);
        }
        Gold gold = new Gold(row, col);
        Hero hero = new Hero(0, 0);
        SensorsView sensors = new SensorsView();
        ksession.insert(wumpus);
        ksession.insert(gold);
        ksession.insert(hero);
        ksession.insert(sensors);
        ksession.insert(data);
        ksession.fireAllRules();
        data.init(cells, sensors, pitts, wumpus, gold, hero);
        data.setKsession(ksession);
    }
}

