/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.wumpus.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.drools.examples.wumpus.Cell;
import org.drools.examples.wumpus.Gold;
import org.drools.examples.wumpus.Hero;
import org.drools.examples.wumpus.Move;
import org.drools.examples.wumpus.MoveCommand;
import org.drools.examples.wumpus.Pitt;
import org.drools.examples.wumpus.ShootCommand;
import org.drools.examples.wumpus.Wumpus;
import org.drools.examples.wumpus.view.GameView;
import org.drools.examples.wumpus.view.SensorsView;

public class GameUI {
    private JFrame frame;
    private GameView gameData;
    private CavePanel cavePanel;
    private SensorPanel sensorPanel;

    public static final void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    GameUI window = new GameUI();
                    window.initialize();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public GameUI() {
        this.gameData = new GameView();
        this.gameData.init(new Cell[5][5], new SensorsView(), new ArrayList<Pitt>(), new Wumpus(2, 1), new Gold(3, 1), new Hero(0, 0));
    }

    public static final void run(GameView gameData) {
        GameUI window = new GameUI(gameData);
        window.initialize();
    }

    public GameUI(GameView gameData) {
        this.gameData = gameData;
    }

    private void initialize() {
        this.frame = new JFrame("Display image");
        this.frame.getContentPane().setBackground(Color.WHITE);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setSize(840, 602);
        this.frame.getContentPane().setLayout((LayoutManager)new MigLayout("", "[grow]", "[300px:n,grow][100px:n,grow]"));
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        this.frame.getContentPane().add((Component)panel, "cell 0 0,grow");
        panel.setLayout((LayoutManager)new MigLayout("", "[200px:200px:200px,left][grow]", "[grow]"));
        JPanel controls = new JPanel();
        controls.setBackground(Color.WHITE);
        controls.setLayout((LayoutManager)new MigLayout("", "[grow,fill]", "[::100px,top][200px,top]"));
        controls.add((Component)this.drawActionPanel(), "cell 0 0,alignx left,aligny top");
        controls.add((Component)this.drawMovePanel(), "cell 0 1,alignx left,growy");
        panel.add((Component)controls, "cell 0 0,grow");
        this.cavePanel = this.drawCave();
        panel.add((Component)this.cavePanel, "cell 1 0,grow");
        JPanel panel_1 = new JPanel();
        panel_1.setBackground(Color.WHITE);
        panel_1.setLayout((LayoutManager)new MigLayout("", "[grow]", "[150px:n,grow]"));
        this.sensorPanel = this.drawSensorPanel();
        panel_1.add((Component)this.sensorPanel, "cell 0 0,grow");
        this.frame.getContentPane().add((Component)panel_1, "cell 0 1,grow");
        this.frame.setVisible(true);
    }

    public synchronized void updateCave() {
        this.cavePanel.repaint();
        this.cavePanel.revalidate();
    }

    public synchronized void updateSensors() {
        this.sensorPanel.repaint();
        this.sensorPanel.revalidate();
    }

    public SensorPanel drawSensorPanel() {
        SensorPanel sensorPanel_1 = new SensorPanel(this.gameData);
        FlowLayout fl_sensorPanel_1 = (FlowLayout)sensorPanel_1.getLayout();
        fl_sensorPanel_1.setVgap(10);
        sensorPanel_1.setBackground(Color.WHITE);
        return sensorPanel_1;
    }

    public CavePanel drawCave() {
        CavePanel cavelPanel = new CavePanel(this.gameData);
        FlowLayout flowLayout = (FlowLayout)cavelPanel.getLayout();
        flowLayout.setVgap(10);
        cavelPanel.setBackground(Color.WHITE);
        return cavelPanel;
    }

    public JPanel drawActionPanel() {
        JPanel actionPanel = new JPanel();
        actionPanel.setBackground(Color.WHITE);
        actionPanel.setLayout(new GridLayout(0, 2, 0, 0));
        JButton btnNewButton_4 = new JButton("START");
        btnNewButton_4.setBackground(Color.LIGHT_GRAY);
        btnNewButton_4.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GameUI.this.gameData.getWumpusWorld().setData(GameUI.this.gameData);
                GameUI.this.updateCave();
                GameUI.this.updateSensors();
            }
        });
        actionPanel.add(btnNewButton_4);
        JButton btnNewButton_5 = new JButton("SHOOT");
        btnNewButton_5.setBackground(Color.LIGHT_GRAY);
        btnNewButton_5.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GameUI.this.gameData.getKsession().insert(new ShootCommand());
                GameUI.this.gameData.getKsession().fireAllRules();
                GameUI.this.updateCave();
                GameUI.this.updateSensors();
            }
        });
        actionPanel.add(btnNewButton_5);
        JButton btnNewButton_8 = new JButton("CAVE?");
        btnNewButton_8.setBackground(Color.LIGHT_GRAY);
        btnNewButton_8.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (GameUI.this.gameData.isShowAllCells()) {
                    GameUI.this.gameData.setShowAllCells(false);
                } else {
                    GameUI.this.gameData.setShowAllCells(true);
                }
                GameUI.this.updateCave();
            }
        });
        actionPanel.add(btnNewButton_8);
        return actionPanel;
    }

    public JPanel drawMovePanel() {
        JPanel movePanel = new JPanel();
        movePanel.setBackground(Color.WHITE);
        movePanel.setLayout(new GridLayout(0, 3, 0, 0));
        JPanel panel_2 = new JPanel();
        panel_2.setBackground(Color.WHITE);
        movePanel.add(panel_2);
        JButton btnNewButton = new JButton("");
        btnNewButton.setForeground(Color.WHITE);
        btnNewButton.setBackground(Color.WHITE);
        btnNewButton.setIcon(new ImageIcon(this.getClass().getResource("up.png")));
        btnNewButton.addMouseListener(new MoveButtonPressed(Move.MOVE_FORWARD));
        movePanel.add(btnNewButton);
        JPanel panel_7 = new JPanel();
        panel_7.setBackground(Color.WHITE);
        movePanel.add(panel_7);
        JButton btnNewButton_3 = new JButton("");
        btnNewButton_3.setForeground(Color.WHITE);
        btnNewButton_3.setBackground(Color.WHITE);
        btnNewButton_3.setIcon(new ImageIcon(this.getClass().getResource("left.png")));
        btnNewButton_3.addMouseListener(new MoveButtonPressed(Move.TURN_LEFT));
        movePanel.add(btnNewButton_3);
        JPanel panel_8 = new JPanel();
        panel_8.setBackground(Color.WHITE);
        movePanel.add(panel_8);
        JButton btnNewButton_2 = new JButton("");
        btnNewButton_2.setForeground(Color.WHITE);
        btnNewButton_2.setBackground(Color.WHITE);
        btnNewButton_2.setIcon(new ImageIcon(this.getClass().getResource("right.png")));
        btnNewButton_2.addMouseListener(new MoveButtonPressed(Move.TURN_RIGHT));
        movePanel.add(btnNewButton_2);
        JPanel panel_9 = new JPanel();
        panel_9.setBackground(Color.WHITE);
        movePanel.add(panel_9);
        JButton btnNewButton_1 = new JButton("");
        btnNewButton_1.setForeground(Color.WHITE);
        btnNewButton_1.setBackground(Color.WHITE);
        btnNewButton_1.setIcon(new ImageIcon(this.getClass().getResource("down.png")));
        btnNewButton_1.addMouseListener(new MoveButtonPressed(Move.MOVE_BACKWARD));
        movePanel.add(btnNewButton_1);
        JPanel panel_10 = new JPanel();
        panel_10.setBackground(Color.WHITE);
        movePanel.add(panel_10);
        return movePanel;
    }

    public static class CavePanel
    extends JPanel {
        private GameView gameData;

        public CavePanel(GameView gameData) {
            this.gameData = gameData;
        }

        public void paint(Graphics g) {
            super.paintComponent(g);
            try {
                int rowIndent = 20;
                int colIndent = 5;
                int rowPad = 0;
                for (int row = 0; row < 5; ++row) {
                    int colPad = 0;
                    for (int col = 0; col < 5; ++col) {
                        int x = (4 - row) * 50 - rowPad + rowIndent;
                        int y = col * 50 + colPad + colIndent;
                        BufferedImage image = null;
                        if (!this.gameData.isShowAllCells() && this.gameData.getCells() != null && this.gameData.getCells()[row][col].isHidden()) {
                            image = ImageIO.read(this.getClass().getResource("hidden_room.png"));
                        } else if (this.gameData.getPits().contains(new Pitt(row, col))) {
                            image = ImageIO.read(this.getClass().getResource("pitt.png"));
                        } else if (row == this.gameData.getWumpus().getRow() && col == this.gameData.getWumpus().getCol()) {
                            image = this.gameData.getWumpus().isAlive() ? ImageIO.read(this.getClass().getResource("alive_wumpus.png")) : ImageIO.read(this.getClass().getResource("dead_wumpus.png"));
                        } else if (row == this.gameData.getGold().getRow() && col == this.gameData.getGold().getCol()) {
                            image = ImageIO.read(this.getClass().getResource("g.png"));
                        } else if (row == this.gameData.getHero().getRow() && col == this.gameData.getHero().getCol()) {
                            Hero hero = this.gameData.getHero();
                            switch (hero.getDirection()) {
                                case UP: {
                                    image = ImageIO.read(this.getClass().getResource("hero_up.png"));
                                    break;
                                }
                                case DOWN: {
                                    image = ImageIO.read(this.getClass().getResource("hero_down.png"));
                                    break;
                                }
                                case LEFT: {
                                    image = ImageIO.read(this.getClass().getResource("hero_left.png"));
                                    break;
                                }
                                case RIGHT: {
                                    image = ImageIO.read(this.getClass().getResource("hero_right.png"));
                                }
                            }
                        } else {
                            image = ImageIO.read(this.getClass().getResource("empty_room.png"));
                        }
                        g.drawImage(image, y, x, 50, 50, this);
                        colPad += 3;
                    }
                    rowPad += 3;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public static class SensorPanel
    extends JPanel {
        private GameView gameData;

        public SensorPanel(GameView gameData) {
            this.gameData = gameData;
        }

        public void paint(Graphics g) {
            super.paintComponent(g);
            try {
                BufferedImage image;
                SensorsView sensor = this.gameData.getSensorsview();
                if (sensor.isFeelBreeze()) {
                    image = ImageIO.read(this.getClass().getResource("breeze.png"));
                    g.drawImage(image, 0, 0, 150, 150, this);
                }
                if (sensor.isSmellStench()) {
                    image = ImageIO.read(this.getClass().getResource("stench.png"));
                    g.drawImage(image, 153, 0, 150, 150, this);
                }
                if (sensor.isSeeGlitter()) {
                    image = ImageIO.read(this.getClass().getResource("glitter.png"));
                    g.drawImage(image, 306, 0, 150, 150, this);
                }
                if (sensor.isFeelBump()) {
                    image = ImageIO.read(this.getClass().getResource("bump.png"));
                    g.drawImage(image, 459, 0, 150, 150, this);
                }
                if (sensor.isHearScream()) {
                    image = ImageIO.read(this.getClass().getResource("scream.png"));
                    g.drawImage(image, 612, 0, 150, 150, this);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private final class MoveButtonPressed
    extends MouseAdapter {
        private Move move;

        public MoveButtonPressed(Move move) {
            this.move = move;
        }

        public void mousePressed(MouseEvent e) {
            GameUI.this.gameData.getKsession().insert(new MoveCommand(this.move));
            GameUI.this.gameData.getKsession().fireAllRules();
            if (GameUI.this.gameData.isPittDeath() || GameUI.this.gameData.isWumpusDeath()) {
                GameUI.this.gameData.getKlogger().close();
                GameUI.this.gameData.setShowAllCells(true);
                GameUI.this.updateCave();
                GameUI.this.updateSensors();
                int answre = JOptionPane.showConfirmDialog(null, "Play Again1?", "DEAD", 0);
                GameUI.this.gameData.getWumpusWorld().setData(GameUI.this.gameData);
                GameUI.this.updateCave();
                GameUI.this.updateSensors();
            } else if (GameUI.this.gameData.isGoldWin()) {
                GameUI.this.gameData.getKlogger().close();
                GameUI.this.gameData.setShowAllCells(true);
                GameUI.this.updateCave();
                GameUI.this.updateSensors();
                int answre = JOptionPane.showConfirmDialog(null, "Play Again1?", "WIN", 0);
                GameUI.this.gameData.getWumpusWorld().setData(GameUI.this.gameData);
                GameUI.this.updateCave();
                GameUI.this.updateSensors();
            } else {
                GameUI.this.updateCave();
                GameUI.this.updateSensors();
            }
        }
    }
}

